/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.UnmodifiableMultivaluedMap;

public class HttpHeadersImpl
implements HttpHeaders {
    private final MultivaluedMap<String, String> requestHeaders = new CaseInsensitiveMap();
    private final MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private Map<String, Cookie> cookies;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public HttpHeadersImpl(Iterable<Map.Entry<String, String>> vertxHeaders) {
        for (Map.Entry<String, String> entry : vertxHeaders) {
            this.requestHeaders.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap(this.requestHeaders, false);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get((Object)name);
        return vals == null ? Collections.emptyList() : vals;
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = Collections.unmodifiableMap(HeaderUtil.getCookies(this.requestHeaders));
        }
        return this.cookies;
    }

    public Date getDate() {
        return HeaderUtil.getDate(this.requestHeaders);
    }

    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.requestHeaders, (String)name);
    }

    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.requestHeaders);
    }

    public int getLength() {
        return HeaderUtil.getLength(this.requestHeaders);
    }

    public MediaType getMediaType() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaType.valueOf((String)obj);
        return this.cachedMediaType;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List<MediaType> modifiableAcceptableMediaTypes = this.getModifiableAcceptableMediaTypes();
        if (modifiableAcceptableMediaTypes.size() > 1) {
            return Collections.unmodifiableList(modifiableAcceptableMediaTypes);
        }
        return modifiableAcceptableMediaTypes;
    }

    public List<MediaType> getModifiableAcceptableMediaTypes() {
        return HeaderUtil.getAcceptableMediaTypes(this.requestHeaders);
    }

    public List<Locale> getAcceptableLanguages() {
        return HeaderUtil.getAcceptableLanguages(this.requestHeaders);
    }
}

