/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.server.core.AsyncExceptionMapperContextImpl;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveAsyncExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveExceptionMapper;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ExceptionMapping {
    private static final Logger log = Logger.getLogger(ExceptionMapping.class);
    private final Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers = new HashMap<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>>();

    public void mapException(Throwable throwable, ResteasyReactiveRequestContext context) {
        Class<?> klass = throwable.getClass();
        boolean isWebApplicationException = throwable instanceof WebApplicationException;
        Response response = null;
        if (isWebApplicationException) {
            response = ((WebApplicationException)throwable).getResponse();
        }
        if (response != null && response.hasEntity()) {
            context.setResult(response);
            return;
        }
        ExceptionMapper<?> exceptionMapper = this.getExceptionMapper(klass, context);
        if (exceptionMapper != null) {
            if (exceptionMapper instanceof ResteasyReactiveAsyncExceptionMapper) {
                ((ResteasyReactiveAsyncExceptionMapper)exceptionMapper).asyncResponse(throwable, new AsyncExceptionMapperContextImpl(context));
                return;
            }
            response = exceptionMapper instanceof ResteasyReactiveExceptionMapper ? ((ResteasyReactiveExceptionMapper)exceptionMapper).toResponse(throwable, context) : exceptionMapper.toResponse(throwable);
            context.setResult(response);
            return;
        }
        if (isWebApplicationException) {
            context.setResult(response);
            return;
        }
        if (throwable instanceof IOException) {
            log.debugf(throwable, "IOError processing HTTP request to %s failed, the client likely terminated the connection.", (Object)context.serverRequest().getRequestAbsoluteUri());
        } else {
            log.error((Object)"Request failed ", throwable);
        }
        context.handleUnmappedException(throwable);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> clazz, ResteasyReactiveRequestContext context) {
        ExceptionMapper<T> result;
        Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> classExceptionMappers = this.getClassExceptionMappers(context);
        if (classExceptionMappers != null && !classExceptionMappers.isEmpty() && (result = this.doGetExceptionMapper(clazz, classExceptionMappers)) != null) {
            return result;
        }
        return this.doGetExceptionMapper(clazz, this.mappers);
    }

    private Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getClassExceptionMappers(ResteasyReactiveRequestContext context) {
        if (context == null) {
            return null;
        }
        return context.getTarget() != null ? context.getTarget().getClassExceptionMappers() : null;
    }

    private <T extends Throwable> ExceptionMapper<T> doGetExceptionMapper(Class<T> clazz, Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers) {
        Class<T> klass = clazz;
        do {
            ResourceExceptionMapper<? extends Throwable> mapper;
            if ((mapper = mappers.get(klass)) == null) continue;
            return (ExceptionMapper)mapper.getFactory().createInstance().getInstance();
        } while ((klass = klass.getSuperclass()) != null);
        return null;
    }

    public <T extends Throwable> void addExceptionMapper(Class<T> exceptionClass, ResourceExceptionMapper<T> mapper) {
        ResourceExceptionMapper<? extends Throwable> existing = this.mappers.get(exceptionClass);
        if (existing != null && existing.getPriority() < mapper.getPriority()) {
            return;
        }
        this.mappers.put(exceptionClass, mapper);
    }

    public Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getMappers() {
        return this.mappers;
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (Map.Entry<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> entry : this.mappers.entrySet()) {
            if (entry.getValue().getFactory() != null) continue;
            entry.getValue().setFactory(factoryCreator.apply(entry.getValue().getClassName()));
        }
    }
}

