/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import io.smallrye.common.annotation.Blocking;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.server.core.AsyncExceptionMapperContextImpl;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveAsyncExceptionMapper;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveExceptionMapper;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ExceptionMapping {
    private static final Logger log = Logger.getLogger(ExceptionMapping.class);
    private final Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers = new HashMap<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>>();
    private final Set<Class<? extends Throwable>> blockingProblemExceptionClasses = new HashSet<Class>(Arrays.asList(BlockingNotAllowedException.class));

    public void mapException(Throwable throwable, ResteasyReactiveRequestContext context) {
        Class<?> klass = throwable.getClass();
        boolean isWebApplicationException = throwable instanceof WebApplicationException;
        Response response = null;
        if (isWebApplicationException) {
            response = ((WebApplicationException)throwable).getResponse();
        }
        if (response != null && response.hasEntity()) {
            context.setResult(response);
            return;
        }
        ExceptionMapper<?> exceptionMapper = this.getExceptionMapper(klass, context);
        if (exceptionMapper != null) {
            context.requireCDIRequestScope();
            if (exceptionMapper instanceof ResteasyReactiveAsyncExceptionMapper) {
                ((ResteasyReactiveAsyncExceptionMapper)exceptionMapper).asyncResponse(throwable, new AsyncExceptionMapperContextImpl(context));
                this.logBlockingErrorIfRequired(throwable, context);
                return;
            }
            response = exceptionMapper instanceof ResteasyReactiveExceptionMapper ? ((ResteasyReactiveExceptionMapper)exceptionMapper).toResponse(throwable, context) : exceptionMapper.toResponse(throwable);
            context.setResult(response);
            this.logBlockingErrorIfRequired(throwable, context);
            return;
        }
        if (isWebApplicationException) {
            context.setResult(response);
            this.logBlockingErrorIfRequired(throwable, context);
            return;
        }
        if (throwable instanceof IOException) {
            log.debugf(throwable, "IOError processing HTTP request to %s failed, the client likely terminated the connection.", (Object)context.serverRequest().getRequestAbsoluteUri());
        } else if (context.handlesUnmappedException()) {
            log.error((Object)"Request failed ", throwable);
        }
        this.logBlockingErrorIfRequired(throwable, context);
        context.handleUnmappedException(throwable);
    }

    private void logBlockingErrorIfRequired(Throwable throwable, ResteasyReactiveRequestContext context) {
        boolean blockingProblem = this.isBlockingProblem(throwable);
        if (blockingProblem) {
            log.error((Object)("A blocking operation occurred on the IO thread. This likely means you need to annotate " + context.getTarget().getResourceClass().getName() + "#" + context.getTarget().getJavaMethodName() + "(" + Arrays.stream(context.getTarget().getParameterTypes()).map(Objects::toString).collect(Collectors.joining(", ")) + ") with @" + Blocking.class.getName() + ". Alternatively you can annotate the class " + context.getTarget().getResourceClass().getName() + " to make every method on the class blocking, or annotate your sub class of the " + Application.class.getName() + " class to make the whole application blocking"));
        }
    }

    private boolean isBlockingProblem(Throwable throwable) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        for (Throwable e = throwable; e != null; e = e.getCause()) {
            if (seen.contains(e)) {
                return false;
            }
            seen.add(e);
            if (!this.blockingProblemExceptionClasses.contains(e.getClass())) continue;
            return true;
        }
        return false;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> clazz, ResteasyReactiveRequestContext context) {
        ExceptionMapper<T> result;
        Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> classExceptionMappers = this.getClassExceptionMappers(context);
        if (classExceptionMappers != null && !classExceptionMappers.isEmpty() && (result = this.doGetExceptionMapper(clazz, classExceptionMappers)) != null) {
            return result;
        }
        return this.doGetExceptionMapper(clazz, this.mappers);
    }

    private Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getClassExceptionMappers(ResteasyReactiveRequestContext context) {
        if (context == null) {
            return null;
        }
        return context.getTarget() != null ? context.getTarget().getClassExceptionMappers() : null;
    }

    private <T extends Throwable> ExceptionMapper<T> doGetExceptionMapper(Class<T> clazz, Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> mappers) {
        Class<T> klass = clazz;
        do {
            ResourceExceptionMapper<? extends Throwable> mapper;
            if ((mapper = mappers.get(klass)) == null) continue;
            return (ExceptionMapper)mapper.getFactory().createInstance().getInstance();
        } while ((klass = klass.getSuperclass()) != null);
        return null;
    }

    public void addBlockingProblem(Class<? extends Throwable> clazz) {
        this.blockingProblemExceptionClasses.add(clazz);
    }

    public <T extends Throwable> void addExceptionMapper(Class<T> exceptionClass, ResourceExceptionMapper<T> mapper) {
        ResourceExceptionMapper<? extends Throwable> existing = this.mappers.get(exceptionClass);
        if (existing != null && existing.getPriority() < mapper.getPriority()) {
            return;
        }
        this.mappers.put(exceptionClass, mapper);
    }

    public Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getMappers() {
        return this.mappers;
    }

    public Set<Class<? extends Throwable>> getBlockingProblemExceptionClasses() {
        return this.blockingProblemExceptionClasses;
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (Map.Entry<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> entry : this.mappers.entrySet()) {
            if (entry.getValue().getFactory() != null) continue;
            entry.getValue().setFactory(factoryCreator.apply(entry.getValue().getClassName()));
        }
    }
}

