/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.common.util.types.TypeSignatureParser;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.parameters.AsyncResponseExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.BodyParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ContextParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.CookieParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.FormParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.HeaderParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.InjectParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.LocatableResourcePathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.MatrixParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.NullParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.PathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.QueryParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.core.startup.CustomServerRestHandlers;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeInterceptorDeployment;
import org.jboss.resteasy.reactive.server.handlers.AbortChainHandler;
import org.jboss.resteasy.reactive.server.handlers.BlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ExceptionHandler;
import org.jboss.resteasy.reactive.server.handlers.FixedProducesHandler;
import org.jboss.resteasy.reactive.server.handlers.FormBodyHandler;
import org.jboss.resteasy.reactive.server.handlers.InputHandler;
import org.jboss.resteasy.reactive.server.handlers.InstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.InvocationHandler;
import org.jboss.resteasy.reactive.server.handlers.ParameterHandler;
import org.jboss.resteasy.reactive.server.handlers.PerRequestInstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceLocatorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.SseResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.VariableProducesHandler;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class RuntimeResourceDeployment {
    public static final ServerRestHandler[] EMPTY_REST_HANDLER_ARRAY = new ServerRestHandler[0];
    private static final Logger log = Logger.getLogger(RuntimeResourceDeployment.class);
    private final DeploymentInfo info;
    private final ServerSerialisers serialisers;
    private final ResteasyReactiveConfig quarkusRestConfig;
    private final Supplier<Executor> executorSupplier;
    private final CustomServerRestHandlers customServerRestHandlers;
    private final RuntimeInterceptorDeployment runtimeInterceptorDeployment;
    private final DynamicEntityWriter dynamicEntityWriter;
    private final ResourceLocatorHandler resourceLocatorHandler;
    private final boolean defaultBlocking;

    public RuntimeResourceDeployment(DeploymentInfo info, Supplier<Executor> executorSupplier, CustomServerRestHandlers customServerRestHandlers, RuntimeInterceptorDeployment runtimeInterceptorDeployment, DynamicEntityWriter dynamicEntityWriter, ResourceLocatorHandler resourceLocatorHandler, boolean defaultBlocking) {
        this.info = info;
        this.serialisers = info.getSerialisers();
        this.quarkusRestConfig = info.getConfig();
        this.executorSupplier = executorSupplier;
        this.customServerRestHandlers = customServerRestHandlers;
        this.runtimeInterceptorDeployment = runtimeInterceptorDeployment;
        this.dynamicEntityWriter = dynamicEntityWriter;
        this.resourceLocatorHandler = resourceLocatorHandler;
        this.defaultBlocking = defaultBlocking;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RuntimeResource buildResourceMethod(ResourceClass clazz, ServerResourceMethod method, boolean locatableResource, URITemplate classPathTemplate, DeploymentInfo info) {
        void var22_41;
        List responseFilterHandlers;
        void var23_48;
        void var22_34;
        List<MediaType> consumesMediaTypes;
        URITemplate methodPathTemplate = new URITemplate(method.getPath(), false);
        QuarkusMultivaluedHashMap score = new QuarkusMultivaluedHashMap();
        Map<String, Integer> pathParameterIndexes = this.buildParamIndexMap(classPathTemplate, methodPathTemplate);
        ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>();
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_MATCH);
        MediaType sseElementType = null;
        if (method.getSseElementType() != null) {
            sseElementType = MediaType.valueOf((String)method.getSseElementType());
        }
        if (method.getConsumes() == null) {
            consumesMediaTypes = Collections.emptyList();
        } else {
            consumesMediaTypes = new ArrayList(method.getConsumes().length);
            for (String string : method.getConsumes()) {
                consumesMediaTypes.add(MediaType.valueOf((String)string));
            }
        }
        Class resourceClass = DeploymentUtils.loadClass((String)clazz.getClassName());
        Class[] parameterClasses = new Class[method.getParameters().length];
        for (int i = 0; i < method.getParameters().length; ++i) {
            parameterClasses[i] = DeploymentUtils.loadClass((String)method.getParameters()[i].declaredType);
        }
        HashSet<String> classAnnotationNames = new HashSet<String>();
        for (Annotation annotation : resourceClass.getAnnotations()) {
            classAnnotationNames.add(annotation.annotationType().getName());
        }
        ResteasyReactiveResourceInfo resteasyReactiveResourceInfo = new ResteasyReactiveResourceInfo(method.getName(), resourceClass, parameterClasses, classAnnotationNames, method.getMethodAnnotationNames());
        RuntimeInterceptorDeployment.MethodInterceptorContext interceptorDeployment = this.runtimeInterceptorDeployment.forMethod(method, resteasyReactiveResourceInfo);
        handlers.addAll(interceptorDeployment.setupInterceptorHandler());
        ArrayList<ServerRestHandler> abortHandlingChain = new ArrayList<ServerRestHandler>(handlers);
        Optional optional = Optional.empty();
        if (!this.defaultBlocking) {
            if (method.isBlocking()) {
                handlers.add(new BlockingHandler(this.executorSupplier));
                Optional<Integer> optional2 = Optional.of(handlers.size() - 1);
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionBlocking);
            } else {
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionNonBlocking);
            }
        }
        if (method.getReturnType().equals("Lio/vertx/core/file/AsyncFile;") && interceptorDeployment.hasWriterInterceptors()) {
            throw new RuntimeException("Endpoints that return an AsyncFile cannot have any WriterInterceptor set");
        }
        if (method.getHttpMethod() != null) {
            void var18_27;
            List<ResourceRequestFilterHandler> containerRequestFilterHandlers = interceptorDeployment.setupRequestFilterHandler();
            if (var18_27.isPresent()) {
                int initialIndex = (Integer)var18_27.get();
                for (int i = 0; i < containerRequestFilterHandlers.size(); ++i) {
                    ResourceRequestFilterHandler resourceRequestFilterHandler = containerRequestFilterHandlers.get(i);
                    if (resourceRequestFilterHandler.isNonBlockingRequired()) {
                        handlers.add(initialIndex + i, resourceRequestFilterHandler);
                        continue;
                    }
                    handlers.add(resourceRequestFilterHandler);
                }
            } else {
                handlers.addAll(containerRequestFilterHandlers);
            }
        }
        MethodParameter[] parameters = method.getParameters();
        MethodParameter bodyParameter = null;
        int bodyParameterIndex = -1;
        boolean bl = false;
        while (var22_34 < parameters.length) {
            MethodParameter methodParameter = parameters[var22_34];
            if (methodParameter.parameterType == ParameterType.BODY) {
                bodyParameter = methodParameter;
                bodyParameterIndex = var22_34;
                break;
            }
            ++var22_34;
        }
        if (method.isFormParamRequired() || method.isMultipart()) {
            handlers.add(new FormBodyHandler(bodyParameter != null, this.executorSupplier));
        } else if (bodyParameter != null && !this.defaultBlocking) {
            if (method.isBlocking()) {
                Supplier<ServerRestHandler> supplier = this.customServerRestHandlers.getBlockingInputHandlerSupplier();
                if (supplier == null) throw new RuntimeException("The current execution environment does not implement a ServerRestHandler for blocking input");
                handlers.add(supplier.get());
            } else if (!method.isBlocking()) {
                handlers.add(new InputHandler(this.quarkusRestConfig.getInputBufferSize(), this.executorSupplier));
            }
        }
        if (bodyParameter != null) {
            void var23_45;
            Class clazz2;
            Class clazz3 = clazz2 = DeploymentUtils.loadClass((String)bodyParameter.declaredType);
            if (!bodyParameter.type.equals(bodyParameter.declaredType)) {
                Type type = TypeSignatureParser.parse((String)bodyParameter.signature);
            }
            handlers.add(new RequestDeserializeHandler(clazz2, (Type)var23_45, consumesMediaTypes.isEmpty() ? null : (MediaType)consumesMediaTypes.get(0), this.serialisers, bodyParameterIndex));
        }
        Object var22_37 = null;
        if (!locatableResource) {
            void var22_40;
            if (clazz.isPerRequestResource()) {
                PerRequestInstanceHandler perRequestInstanceHandler = new PerRequestInstanceHandler((BeanFactory<Object>)clazz.getFactory(), info.getClientProxyUnwrapper());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourcePerRequest);
            } else {
                InstanceHandler instanceHandler = new InstanceHandler((BeanFactory<Object>)clazz.getFactory());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourceSingleton);
            }
            handlers.add((ServerRestHandler)var22_40);
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.RESOLVE_METHOD_PARAMETERS);
        boolean bl2 = false;
        while (var23_48 < parameters.length) {
            boolean userProviderConvertersExist;
            ServerMethodParameter param = (ServerMethodParameter)parameters[var23_48];
            boolean single = param.isSingle();
            ParameterExtractor extractor = this.parameterExtractor(pathParameterIndexes, locatableResource, param.parameterType, param.type, param.name, single, param.encoded, param.customerParameterExtractor);
            ParameterConverter converter = null;
            ParamConverterProviders paramConverterProviders = info.getParamConverterProviders();
            boolean bl3 = userProviderConvertersExist = !paramConverterProviders.getParamConverterProviders().isEmpty();
            if (param.converter != null) {
                converter = (ParameterConverter)param.converter.get();
                if (userProviderConvertersExist) {
                    Method javaMethod = resteasyReactiveResourceInfo.getMethod();
                    converter.init(paramConverterProviders, javaMethod.getParameterTypes()[var23_48], javaMethod.getGenericParameterTypes()[var23_48], javaMethod.getParameterAnnotations()[var23_48]);
                    converter = new RuntimeResolvedConverter(converter);
                    converter.init(paramConverterProviders, javaMethod.getParameterTypes()[var23_48], javaMethod.getGenericParameterTypes()[var23_48], javaMethod.getParameterAnnotations()[var23_48]);
                }
            }
            handlers.add(new ParameterHandler((int)var23_48, param.getDefaultValue(), extractor, converter, param.parameterType, param.isObtainedAsCollection(), param.isOptional()));
            ++var23_48;
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.BEFORE_METHOD_INVOKE);
        EndpointInvoker endpointInvoker = method.getInvoker().get();
        ServerRestHandler alternate = this.alternateInvoker(method, endpointInvoker);
        if (alternate != null) {
            handlers.add(alternate);
        } else {
            handlers.add(new InvocationHandler(endpointInvoker));
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE);
        Type returnType = TypeSignatureParser.parse((String)method.getReturnType());
        Type nonAsyncReturnType = this.getNonAsyncReturnType(returnType);
        Class<?> rawNonAsyncReturnType = this.getRawType(nonAsyncReturnType);
        ServerMediaType serverMediaType = null;
        if (method.getProduces() != null && method.getProduces().length > 0) {
            serverMediaType = new ServerMediaType(ServerMediaType.mediaTypesFromArray((String[])method.getProduces()), StandardCharsets.UTF_8.name(), false, true);
        }
        if (method.getHttpMethod() == null) {
            handlers.add(this.resourceLocatorHandler);
        } else if (!Response.class.isAssignableFrom(rawNonAsyncReturnType)) {
            if (method.getProduces() != null && method.getProduces().length > 0) {
                if (method.getProduces().length == 1) {
                    MediaType mediaType = MediaType.valueOf((String)method.getProduces()[0]);
                    if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
                        handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                    } else if (rawNonAsyncReturnType != Void.class && rawNonAsyncReturnType != Void.TYPE) {
                        List buildTimeWriters = this.serialisers.findBuildTimeWriters(rawNonAsyncReturnType, RuntimeType.SERVER, Collections.singletonList(MediaTypeHelper.withSuffixAsSubtype((MediaType)MediaType.valueOf((String)method.getProduces()[0]))));
                        if (buildTimeWriters == null) {
                            handlers.add(new FixedProducesHandler(mediaType, this.dynamicEntityWriter));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (buildTimeWriters.isEmpty()) {
                            log.warn((Object)("Cannot find any combination of response writers for the method " + clazz.getClassName() + "#" + method.getName() + "(" + Arrays.toString(method.getParameters()) + ")"));
                            handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (this.isSingleEffectiveWriter(buildTimeWriters)) {
                            MessageBodyWriter writer = (MessageBodyWriter)buildTimeWriters.get(0);
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriter(writer, this.serialisers)));
                            if (writer instanceof ServerMessageBodyWriter) {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeDirect(writer));
                            } else {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTime(writer));
                            }
                        } else {
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriterArray(buildTimeWriters.toArray(new MessageBodyWriter[0]), this.serialisers)));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeMultiple(buildTimeWriters));
                        }
                    } else {
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterNotRequired);
                    }
                } else {
                    handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                    score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                }
            } else {
                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
            }
        } else {
            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
        }
        if (method.isSse()) {
            handlers.add(new SseResponseWriterHandler());
            responseFilterHandlers = Collections.emptyList();
        } else {
            handlers.add(new ResponseHandler());
            this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED);
            responseFilterHandlers = new ArrayList<ServerRestHandler>(interceptorDeployment.setupResponseFilterHandler());
            handlers.addAll(responseFilterHandlers);
            handlers.add(new ResponseWriterHandler(this.dynamicEntityWriter));
        }
        if (!clazz.resourceExceptionMapper().isEmpty() && var22_41 != null) {
            abortHandlingChain.add((ServerRestHandler)var22_41);
        }
        abortHandlingChain.add(new ExceptionHandler());
        abortHandlingChain.add(new ResponseHandler());
        abortHandlingChain.addAll(responseFilterHandlers);
        abortHandlingChain.add(new ResponseWriterHandler(this.dynamicEntityWriter));
        handlers.add(0, new AbortChainHandler(abortHandlingChain.toArray(EMPTY_REST_HANDLER_ARRAY)));
        return new RuntimeResource(method.getHttpMethod(), methodPathTemplate, classPathTemplate, method.getProduces() == null ? null : serverMediaType, consumesMediaTypes, endpointInvoker, (BeanFactory<Object>)clazz.getFactory(), handlers.toArray(EMPTY_REST_HANDLER_ARRAY), method.getName(), parameterClasses, nonAsyncReturnType, method.isBlocking(), resourceClass, resteasyReactiveResourceInfo, pathParameterIndexes, (Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>>)score, sseElementType, clazz.resourceExceptionMapper());
    }

    private boolean isSingleEffectiveWriter(List<MessageBodyWriter<?>> buildTimeWriters) {
        if (buildTimeWriters.size() == 1) {
            return true;
        }
        return buildTimeWriters.get(0) instanceof ServerMessageBodyWriter.AllWriteableMessageBodyWriter;
    }

    private void addHandlers(List<ServerRestHandler> handlers, ResourceClass clazz, ServerResourceMethod method, DeploymentInfo info, HandlerChainCustomizer.Phase phase) {
        int i;
        for (i = 0; i < info.getGlobalHandlerCustomizers().size(); ++i) {
            handlers.addAll(info.getGlobalHandlerCustomizers().get(i).handlers(phase, clazz, method));
        }
        for (i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            handlers.addAll(method.getHandlerChainCustomizers().get(i).handlers(phase, clazz, method));
        }
    }

    private ServerRestHandler alternateInvoker(ServerResourceMethod method, EndpointInvoker invoker) {
        for (int i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            ServerRestHandler ret = method.getHandlerChainCustomizers().get(i).alternateInvocationHandler(invoker);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ParameterExtractor parameterExtractor(Map<String, Integer> pathParameterIndexes, boolean locatableResource, ParameterType type, String javaType, String name, boolean single, boolean encoded, ParameterExtractor customExtractor) {
        switch (type) {
            case HEADER: {
                return new HeaderParamExtractor(name, single);
            }
            case COOKIE: {
                return new CookieParamExtractor(name);
            }
            case FORM: {
                return new FormParamExtractor(name, single, encoded);
            }
            case PATH: {
                Integer index = pathParameterIndexes.get(name);
                ParameterExtractor extractor = index == null ? (locatableResource ? new LocatableResourcePathParamExtractor(name) : new NullParamExtractor()) : new PathParamExtractor(index, encoded);
                return extractor;
            }
            case CONTEXT: {
                return new ContextParamExtractor(javaType);
            }
            case ASYNC_RESPONSE: {
                return new AsyncResponseExtractor();
            }
            case QUERY: {
                QueryParamExtractor extractor = new QueryParamExtractor(name, single, encoded);
                return extractor;
            }
            case BODY: {
                return new BodyParamExtractor();
            }
            case MATRIX: {
                MatrixParamExtractor extractor = new MatrixParamExtractor(name, single, encoded);
                return extractor;
            }
            case BEAN: {
                return new InjectParamExtractor(this.info.getFactoryCreator().apply(DeploymentUtils.loadClass((String)javaType)));
            }
            case MULTI_PART_FORM: {
                return new InjectParamExtractor((BeanFactory<Object>)new ReflectionBeanFactoryCreator().apply(javaType));
            }
            case CUSTOM: {
                return customExtractor;
            }
        }
        throw new RuntimeException("Unknown param type: " + type);
    }

    public Map<String, Integer> buildParamIndexMap(URITemplate classPathTemplate, URITemplate methodPathTemplate) {
        HashMap<String, Integer> pathParameterIndexes = new HashMap<String, Integer>();
        int pathCount = 0;
        if (classPathTemplate != null) {
            for (URITemplate.TemplateComponent i : classPathTemplate.components) {
                if (i.name != null) {
                    pathParameterIndexes.put(i.name, pathCount++);
                    continue;
                }
                if (i.names == null) continue;
                for (String nm : i.names) {
                    pathParameterIndexes.put(nm, pathCount++);
                }
            }
        }
        for (URITemplate.TemplateComponent i : methodPathTemplate.components) {
            if (i.name != null) {
                pathParameterIndexes.put(i.name, pathCount++);
                continue;
            }
            if (i.names == null) continue;
            for (String nm : i.names) {
                pathParameterIndexes.put(nm, pathCount++);
            }
        }
        return pathParameterIndexes;
    }

    private Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return (Class)ptype.getRawType();
        }
        throw new UnsupportedOperationException("Endpoint return type not supported yet: " + type);
    }

    private Type getNonAsyncReturnType(Type returnType) {
        if (returnType instanceof Class) {
            return returnType;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            if (type.getRawType() == CompletionStage.class) {
                return type.getActualTypeArguments()[0];
            }
            if (type.getRawType() == Uni.class) {
                return type.getActualTypeArguments()[0];
            }
            if (type.getRawType() == Multi.class) {
                return type.getActualTypeArguments()[0];
            }
            if (type.getRawType() == RestResponse.class) {
                return type.getActualTypeArguments()[0];
            }
            return returnType;
        }
        throw new UnsupportedOperationException("Endpoint return type not supported yet: " + returnType);
    }
}

