/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jboss.resteasy.reactive.server.mapping.Dumpable;

public class URITemplate
implements Dumpable,
Comparable<URITemplate> {
    public final String template;
    public final String stem;
    public final int literalCharacterCount;
    public final int capturingGroups;
    public final int complexExpressions;
    public final TemplateComponent[] components;
    public final boolean prefixMatch;

    public URITemplate(String template, boolean prefixMatch) {
        this.prefixMatch = prefixMatch;
        if (!((String)template).startsWith("/")) {
            template = "/" + (String)template;
        }
        this.template = template;
        ArrayList<TemplateComponent> components = new ArrayList<TemplateComponent>();
        String name = null;
        String stem = null;
        int litChars = 0;
        int capGroups = 0;
        int complexGroups = 0;
        int bracesCount = 0;
        StringBuilder sb = new StringBuilder();
        int state = 0;
        block9: for (int i = 0; i < ((String)template).length(); ++i) {
            char c = ((String)template).charAt(i);
            switch (state) {
                case 0: {
                    if (c == '{') {
                        state = 1;
                        if (sb.length() > 0) {
                            String literal = sb.toString();
                            if (components.isEmpty()) {
                                stem = literal;
                            }
                            components.add(new TemplateComponent(Type.LITERAL, literal, null, null, null));
                        }
                        sb.setLength(0);
                        continue block9;
                    }
                    ++litChars;
                    sb.append(c);
                    continue block9;
                }
                case 1: {
                    if (c == '}') {
                        state = 0;
                        if (sb.length() > 0) {
                            ++capGroups;
                            if (i + 1 == ((String)template).length() || ((String)template).charAt(i + 1) == '/') {
                                components.add(new TemplateComponent(Type.DEFAULT_REGEX, null, sb.toString(), null, null));
                            } else {
                                components.add(new TemplateComponent(Type.CUSTOM_REGEX, "[^/]+?", sb.toString(), null, null));
                            }
                        } else {
                            throw new IllegalArgumentException("Invalid template " + (String)template);
                        }
                        sb.setLength(0);
                        continue block9;
                    }
                    if (c == ':') {
                        name = sb.toString();
                        sb.setLength(0);
                        state = 2;
                        continue block9;
                    }
                    sb.append(c);
                    continue block9;
                }
                case 2: {
                    if (c == '}' && bracesCount == 0) {
                        state = 0;
                        if (sb.length() > 0) {
                            ++capGroups;
                            ++complexGroups;
                        } else {
                            throw new IllegalArgumentException("Invalid template " + (String)template);
                        }
                        components.add(new TemplateComponent(Type.CUSTOM_REGEX, sb.toString(), name, null, null));
                        sb.setLength(0);
                        continue block9;
                    }
                    sb.append(c);
                    if (c == '{') {
                        ++bracesCount;
                        continue block9;
                    }
                    if (c != '}') continue block9;
                    --bracesCount;
                }
            }
        }
        switch (state) {
            case 0: {
                if (sb.length() <= 0) break;
                String literal = sb.toString();
                if (components.isEmpty()) {
                    stem = literal;
                }
                components.add(new TemplateComponent(Type.LITERAL, literal, null, null, null));
                break;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Invalid template " + (String)template);
            }
        }
        if (bracesCount > 0) {
            throw new IllegalArgumentException("Invalid template " + (String)template + " Unmatched { braces");
        }
        ArrayList<String> nameAggregator = null;
        StringBuilder regexAggregator = null;
        Iterator it = components.iterator();
        while (it.hasNext()) {
            TemplateComponent component = (TemplateComponent)it.next();
            if (nameAggregator != null) {
                it.remove();
                if (component.type == Type.LITERAL) {
                    regexAggregator.append(Pattern.quote(component.literalText));
                    continue;
                }
                if (component.type == Type.DEFAULT_REGEX) {
                    regexAggregator.append("(?<").append(component.name).append(">[^/]+?)");
                    nameAggregator.add(component.name);
                    continue;
                }
                if (component.type != Type.CUSTOM_REGEX) continue;
                regexAggregator.append("(?<").append(component.name).append(">").append(component.literalText.trim()).append(")");
                nameAggregator.add(component.name);
                continue;
            }
            if (component.type != Type.CUSTOM_REGEX) continue;
            it.remove();
            regexAggregator = new StringBuilder();
            nameAggregator = new ArrayList<String>();
            regexAggregator.append("(?<").append(component.name).append(">").append(component.literalText.trim()).append(")");
            nameAggregator.add(component.name);
        }
        if (nameAggregator != null) {
            if (!this.prefixMatch) {
                regexAggregator.append("$");
            }
            components.add(new TemplateComponent(Type.CUSTOM_REGEX, null, null, Pattern.compile(regexAggregator.toString()), nameAggregator.toArray(new String[0])));
        }
        this.stem = stem;
        this.literalCharacterCount = litChars;
        this.components = components.toArray(new TemplateComponent[0]);
        this.capturingGroups = capGroups;
        this.complexExpressions = complexGroups;
    }

    public URITemplate(String template, String stem, int literalCharacterCount, int capturingGroups, int complexExpressions, TemplateComponent[] components, boolean prefixMatch) {
        this.template = template;
        this.stem = stem;
        this.literalCharacterCount = literalCharacterCount;
        this.capturingGroups = capturingGroups;
        this.complexExpressions = complexExpressions;
        this.components = components;
        this.prefixMatch = prefixMatch;
    }

    @Override
    public int compareTo(URITemplate uriTemplate) {
        int val = this.stem.compareTo(uriTemplate.stem);
        if (val != 0) {
            return val;
        }
        val = Integer.compare(this.literalCharacterCount, uriTemplate.literalCharacterCount);
        if (val != 0) {
            return val;
        }
        val = Integer.compare(this.capturingGroups, uriTemplate.capturingGroups);
        if (val != 0) {
            return val;
        }
        val = Integer.compare(this.complexExpressions, uriTemplate.complexExpressions);
        if (val != 0) {
            return val;
        }
        return this.template.compareTo(uriTemplate.template);
    }

    public int countPathParamNames() {
        int classTemplateNameCount = 0;
        for (TemplateComponent i : this.components) {
            if (i.name != null) {
                ++classTemplateNameCount;
                continue;
            }
            if (i.names == null) continue;
            classTemplateNameCount += i.names.length;
        }
        return classTemplateNameCount;
    }

    public String toString() {
        return "URITemplate{ stem: " + this.stem + ", template: " + this.template + ", literalCharacterCount: " + this.literalCharacterCount + ", components: " + Arrays.toString(this.components) + " }";
    }

    @Override
    public void dump(int level) {
        this.indent(level);
        System.err.println("URITemplate");
        this.indent(level + 1);
        System.err.println("stem: " + this.stem);
        this.indent(level + 1);
        System.err.println("template: " + this.template);
        this.indent(level + 1);
        System.err.println("literalCharacterCount: " + this.literalCharacterCount);
        this.indent(level + 1);
        System.err.println("components: ");
        for (TemplateComponent component : this.components) {
            component.dump(level + 2);
        }
    }

    public static class TemplateComponent
    implements Dumpable {
        public final Type type;
        public final String literalText;
        public final String name;
        public final Pattern pattern;
        public final String[] names;

        public TemplateComponent(Type type, String literalText, String name, Pattern pattern, String[] names) {
            this.type = type;
            this.literalText = literalText;
            this.name = name;
            this.pattern = pattern;
            this.names = names;
        }

        public String toString() {
            return "TemplateComponent{ name: " + this.name + ", type: " + this.type + ", literalText: " + this.literalText + ", pattern: " + this.pattern + "}";
        }

        @Override
        public void dump(int level) {
            this.indent(level);
            System.err.println("TemplateComponent");
            this.indent(level + 1);
            System.err.println("name: " + this.name);
            this.indent(level + 1);
            System.err.println("type: " + this.type);
            this.indent(level + 1);
            System.err.println("literalText: " + this.literalText);
            this.indent(level + 1);
            System.err.println("pattern: " + this.pattern);
        }
    }

    public static enum Type {
        LITERAL,
        DEFAULT_REGEX,
        CUSTOM_REGEX;

    }
}

