/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class InputHandler
implements ServerRestHandler {
    final long maxBufferSize;
    private volatile Executor executor;
    private final Supplier<Executor> supplier;
    private final ClassLoader originalTCCL;

    public InputHandler(long maxBufferSize, Supplier<Executor> supplier) {
        this.maxBufferSize = maxBufferSize;
        this.supplier = supplier;
        this.originalTCCL = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void handle(ResteasyReactiveRequestContext context) throws Exception {
        if (context.hasInputStream()) {
            return;
        }
        if (context.serverRequest().getRequestMethod().equals("GET") || context.serverRequest().getRequestMethod().equals("HEAD")) {
            return;
        }
        InputListener h = new InputListener(context);
        context.suspend();
        ServerHttpRequest req = context.serverRequest();
        if (!req.isRequestEnded()) {
            req.setReadListener(h);
            req.resumeRequestInput();
        } else {
            req.resumeRequestInput();
            h.done();
        }
    }

    class InputListener
    implements ServerHttpRequest.ReadCallback {
        final ResteasyReactiveRequestContext context;
        int dataCount;
        final List<ByteBuffer> data = new ArrayList<ByteBuffer>();

        InputListener(ResteasyReactiveRequestContext context) {
            this.context = context;
        }

        @Override
        public void done() {
            byte[] ar = new byte[this.dataCount];
            int count = 0;
            for (ByteBuffer i : this.data) {
                int remaining = i.remaining();
                i.get(ar, count, remaining);
                count += remaining;
            }
            this.context.setInputStream(new ByteArrayInputStream(ar));
            Thread.currentThread().setContextClassLoader(InputHandler.this.originalTCCL);
            this.context.resume();
        }

        @Override
        public void data(ByteBuffer event) {
            this.dataCount += event.remaining();
            this.data.add(event);
            if ((long)this.dataCount > InputHandler.this.maxBufferSize) {
                this.context.serverRequest().pauseRequestInput();
                if (InputHandler.this.executor == null) {
                    InputHandler.this.executor = InputHandler.this.supplier.get();
                }
                int count = 0;
                byte[] ar = new byte[this.dataCount];
                for (ByteBuffer i : this.data) {
                    int remaining = i.remaining();
                    i.get(ar, count, remaining);
                    count += remaining;
                }
                this.context.setInputStream(this.context.serverRequest().createInputStream(ByteBuffer.wrap(ar)));
                this.context.resume(InputHandler.this.executor);
            }
        }
    }
}

