/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.multipart.MultipartPartReadingException;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;

public final class MultipartSupport {
    private static final Logger log = Logger.getLogger(RequestDeserializeHandler.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    private MultipartSupport() {
    }

    public static Object convertFormAttribute(String value, Class type, Type genericType, MediaType mediaType, ResteasyReactiveRequestContext context, String attributeName) {
        if (value == null) {
            Deque<FormData.FormValue> fileUploadsForName;
            FormData formData = context.getFormData();
            if (formData != null && (fileUploadsForName = formData.get(attributeName)) != null) {
                for (FormData.FormValue fileUpload : fileUploadsForName) {
                    if (!fileUpload.isFileItem()) continue;
                    log.warn((Object)("Attribute '" + attributeName + "' of the multipart request is a file and therefore its value is not set. To obtain the contents of the file, use type '" + FileUpload.class + "' as the field type."));
                    break;
                }
            }
            return null;
        }
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        List readers = serialisers.findReaders(null, type, mediaType, RuntimeType.SERVER);
        if (readers.isEmpty()) {
            throw new NotSupportedException();
        }
        for (MessageBodyReader reader : readers) {
            if (reader instanceof ServerMessageBodyReader) {
                ServerMessageBodyReader serverMessageBodyReader = (ServerMessageBodyReader)reader;
                if (!serverMessageBodyReader.isReadable(type, genericType, context.getTarget().getLazyMethod(), mediaType)) continue;
                InputStream originalInputStream = context.getInputStream();
                try {
                    context.setInputStream(MultipartSupport.formAttributeValueToInputStream(value));
                    Object t = serverMessageBodyReader.readFrom(type, genericType, mediaType, context);
                    return t;
                }
                catch (IOException e) {
                    log.error((Object)("Unable to convert value provided for attribute '" + attributeName + "' of the multipart request into type '" + type.getName() + "'"), (Throwable)e);
                    throw new MultipartPartReadingException(e);
                }
                finally {
                    context.setInputStream(originalInputStream);
                }
            }
            if (!reader.isReadable(type, genericType, EMPTY_ANNOTATIONS, mediaType)) continue;
            try {
                return reader.readFrom(type, genericType, EMPTY_ANNOTATIONS, mediaType, context.getHttpHeaders().getRequestHeaders(), (InputStream)MultipartSupport.formAttributeValueToInputStream(value));
            }
            catch (IOException e) {
                log.error((Object)("Unable to convert value provided for attribute '" + attributeName + "' of the multipart request into type '" + type.getName() + "'"), (Throwable)e);
                throw new MultipartPartReadingException(e);
            }
        }
        throw new NotSupportedException("Media type '" + mediaType + "' in multipart request is not supported");
    }

    public static String getSingleFileUploadAsString(String formName, ResteasyReactiveRequestContext context) {
        DefaultFileUpload upload = MultipartSupport.getSingleFileUpload(formName, context);
        if (upload != null) {
            try {
                return Files.readString(upload.filePath(), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        return null;
    }

    public static byte[] getSingleFileUploadAsArrayBytes(String formName, ResteasyReactiveRequestContext context) {
        DefaultFileUpload upload = MultipartSupport.getSingleFileUpload(formName, context);
        if (upload != null) {
            try {
                return Files.readAllBytes(upload.filePath());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        return null;
    }

    public static InputStream getSingleFileUploadAsInputStream(String formName, ResteasyReactiveRequestContext context) {
        DefaultFileUpload upload = MultipartSupport.getSingleFileUpload(formName, context);
        if (upload != null) {
            try {
                return new FileInputStream(upload.filePath().toFile());
            }
            catch (IOException e) {
                throw new MultipartPartReadingException(e);
            }
        }
        return null;
    }

    public static DefaultFileUpload getSingleFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (uploads.size() > 1) {
            throw new BadRequestException("Found more than one files for attribute '" + formName + "'. Expected only one file");
        }
        if (uploads.size() == 1) {
            return uploads.get(0);
        }
        return null;
    }

    public static DefaultFileUpload getFileUpload(String formName, ResteasyReactiveRequestContext context) {
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        if (!uploads.isEmpty()) {
            return uploads.get(0);
        }
        return null;
    }

    public static List<DefaultFileUpload> getFileUploads(String formName, ResteasyReactiveRequestContext context) {
        Deque<FormData.FormValue> fileUploadsForName;
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        FormData fileUploads = context.getFormData();
        if (fileUploads != null && (fileUploadsForName = fileUploads.get(formName)) != null) {
            for (FormData.FormValue fileUpload : fileUploadsForName) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(formName, fileUpload));
            }
        }
        return result;
    }

    public static List<File> getJavaIOFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<File> result = new ArrayList<File>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile().toFile());
        }
        return result;
    }

    public static List<Path> getJavaPathFileUploads(String formName, ResteasyReactiveRequestContext context) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<DefaultFileUpload> uploads = MultipartSupport.getFileUploads(formName, context);
        for (DefaultFileUpload upload : uploads) {
            result.add(upload.uploadedFile());
        }
        return result;
    }

    public static List<DefaultFileUpload> getFileUploads(ResteasyReactiveRequestContext context) {
        FormData formData = context.getFormData();
        if (formData == null) {
            return Collections.emptyList();
        }
        ArrayList<DefaultFileUpload> result = new ArrayList<DefaultFileUpload>();
        for (String name : formData) {
            for (FormData.FormValue fileUpload : formData.get(name)) {
                if (!fileUpload.isFileItem()) continue;
                result.add(new DefaultFileUpload(name, fileUpload));
            }
        }
        return result;
    }

    private static ByteArrayInputStream formAttributeValueToInputStream(String formAttributeValue) {
        return new ByteArrayInputStream(formAttributeValue.getBytes(StandardCharsets.UTF_8));
    }
}

