/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.HasPriority;
import org.jboss.resteasy.reactive.common.model.ResourceDynamicFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.handlers.InterceptorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceResponseFilterHandler;
import org.jboss.resteasy.reactive.server.jaxrs.DynamicFeatureContext;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class RuntimeInterceptorDeployment {
    private static final LinkedHashMap<ResourceInterceptor, ReaderInterceptor> EMPTY_INTERCEPTOR_MAP = new LinkedHashMap();
    private final Map<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> globalRequestInterceptorsMap;
    private final Map<ResourceInterceptor<ContainerResponseFilter>, ContainerResponseFilter> globalResponseInterceptorsMap;
    private final Map<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> nameRequestInterceptorsMap;
    private final Map<ResourceInterceptor<ContainerResponseFilter>, ContainerResponseFilter> nameResponseInterceptorsMap;
    private final Map<ResourceInterceptor<ReaderInterceptor>, ReaderInterceptor> globalReaderInterceptorsMap;
    private final Map<ResourceInterceptor<WriterInterceptor>, WriterInterceptor> globalWriterInterceptorsMap;
    private final Map<ResourceInterceptor<ReaderInterceptor>, ReaderInterceptor> nameReaderInterceptorsMap;
    private final Map<ResourceInterceptor<WriterInterceptor>, WriterInterceptor> nameWriterInterceptorsMap;
    private final Map<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> preMatchContainerRequestFilters;
    private final List<ResourceRequestFilterHandler> globalRequestInterceptorHandlers;
    private final List<ResourceResponseFilterHandler> globalResponseInterceptorHandlers;
    private final InterceptorHandler globalInterceptorHandler;
    private final DeploymentInfo info;
    private final Consumer<Closeable> closeTaskHandler;
    private final ConfigurationImpl configurationImpl;

    /*
     * WARNING - void declaration
     */
    public RuntimeInterceptorDeployment(DeploymentInfo info, ConfigurationImpl configurationImpl, Consumer<Closeable> closeTaskHandler) {
        this.info = info;
        this.configurationImpl = configurationImpl;
        this.closeTaskHandler = closeTaskHandler;
        ResourceInterceptors interceptors = info.getInterceptors();
        this.globalRequestInterceptorsMap = this.createInterceptorInstances(interceptors.getContainerRequestFilters().getGlobalResourceInterceptors(), closeTaskHandler);
        this.globalResponseInterceptorsMap = this.createInterceptorInstances(interceptors.getContainerResponseFilters().getGlobalResourceInterceptors(), closeTaskHandler);
        this.nameRequestInterceptorsMap = this.createInterceptorInstances(interceptors.getContainerRequestFilters().getNameResourceInterceptors(), closeTaskHandler);
        this.nameResponseInterceptorsMap = this.createInterceptorInstances(interceptors.getContainerResponseFilters().getNameResourceInterceptors(), closeTaskHandler);
        this.globalReaderInterceptorsMap = this.createInterceptorInstances(interceptors.getReaderInterceptors().getGlobalResourceInterceptors(), closeTaskHandler);
        this.globalWriterInterceptorsMap = this.createInterceptorInstances(interceptors.getWriterInterceptors().getGlobalResourceInterceptors(), closeTaskHandler);
        this.nameReaderInterceptorsMap = this.createInterceptorInstances(interceptors.getReaderInterceptors().getNameResourceInterceptors(), closeTaskHandler);
        this.nameWriterInterceptorsMap = this.createInterceptorInstances(interceptors.getWriterInterceptors().getNameResourceInterceptors(), closeTaskHandler);
        this.preMatchContainerRequestFilters = this.createInterceptorInstances(interceptors.getContainerRequestFilters().getPreMatchInterceptors(), closeTaskHandler);
        Collection<ContainerResponseFilter> responseFilters = this.globalResponseInterceptorsMap.values();
        this.globalResponseInterceptorHandlers = new ArrayList<ResourceResponseFilterHandler>(responseFilters.size());
        for (ContainerResponseFilter containerResponseFilter : responseFilters) {
            this.globalResponseInterceptorHandlers.add(new ResourceResponseFilterHandler(containerResponseFilter));
        }
        this.globalRequestInterceptorHandlers = new ArrayList<ResourceRequestFilterHandler>(this.globalRequestInterceptorsMap.size());
        for (Map.Entry entry : this.globalRequestInterceptorsMap.entrySet()) {
            this.globalRequestInterceptorHandlers.add(new ResourceRequestFilterHandler((ContainerRequestFilter)entry.getValue(), false, ((ResourceInterceptor)entry.getKey()).isNonBlockingRequired(), ((ResourceInterceptor)entry.getKey()).isWithFormRead()));
        }
        InterceptorHandler globalInterceptorHandler = null;
        if (!this.globalReaderInterceptorsMap.isEmpty() || !this.globalWriterInterceptorsMap.isEmpty()) {
            void var7_12;
            int idx;
            Object var7_10 = null;
            ReaderInterceptor[] readers = null;
            if (!this.globalReaderInterceptorsMap.isEmpty()) {
                readers = new ReaderInterceptor[this.globalReaderInterceptorsMap.size()];
                idx = 0;
                for (ReaderInterceptor readerInterceptor : this.globalReaderInterceptorsMap.values()) {
                    readers[idx++] = readerInterceptor;
                }
            }
            if (!this.globalWriterInterceptorsMap.isEmpty()) {
                WriterInterceptor[] writerInterceptorArray = new WriterInterceptor[this.globalWriterInterceptorsMap.size()];
                idx = 0;
                for (WriterInterceptor writerInterceptor : this.globalWriterInterceptorsMap.values()) {
                    writerInterceptorArray[idx++] = writerInterceptor;
                }
            }
            globalInterceptorHandler = new InterceptorHandler((WriterInterceptor[])var7_12, readers);
        }
        this.globalInterceptorHandler = globalInterceptorHandler;
    }

    public InterceptorHandler getGlobalInterceptorHandler() {
        return this.globalInterceptorHandler;
    }

    public List<ResourceRequestFilterHandler> getGlobalRequestInterceptorHandlers() {
        return this.globalRequestInterceptorHandlers;
    }

    public List<ResourceResponseFilterHandler> getGlobalResponseInterceptorHandlers() {
        return this.globalResponseInterceptorHandlers;
    }

    public Map<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> getPreMatchContainerRequestFilters() {
        return this.preMatchContainerRequestFilters;
    }

    private <T> LinkedHashMap<ResourceInterceptor<T>, T> createInterceptorInstances(List<ResourceInterceptor<T>> interceptors, Consumer<Closeable> closeTaskHandler) {
        if (interceptors.isEmpty()) {
            return EMPTY_INTERCEPTOR_MAP;
        }
        LinkedHashMap<ResourceInterceptor<T>, Object> result = new LinkedHashMap<ResourceInterceptor<T>, Object>();
        ArrayList<BeanFactory.BeanInstance> responseBeanInstances = new ArrayList<BeanFactory.BeanInstance>(interceptors.size());
        Collections.sort(interceptors);
        for (ResourceInterceptor<T> interceptor : interceptors) {
            BeanFactory.BeanInstance beanInstance = interceptor.getFactory().createInstance();
            responseBeanInstances.add(beanInstance);
            Object containerResponseFilter = beanInstance.getInstance();
            result.put(interceptor, containerResponseFilter);
        }
        closeTaskHandler.accept((Closeable)new BeanFactory.BeanInstance.ClosingTask(responseBeanInstances));
        return result;
    }

    public MethodInterceptorContext forMethod(ResourceMethod method, ResteasyReactiveResourceInfo lazyMethod) {
        return new MethodInterceptorContext(method, lazyMethod);
    }

    <T> TreeMap<ResourceInterceptor<T>, T> buildInterceptorMap(Map<ResourceInterceptor<T>, T> globalInterceptorsMap, Map<ResourceInterceptor<T>, T> nameInterceptorsMap, Map<ResourceInterceptor<T>, T> methodSpecificInterceptorsMap, ResourceMethod method, boolean reversed) {
        TreeMap<ResourceInterceptor<T>, T> interceptorsToUse = new TreeMap<ResourceInterceptor<T>, T>(HasPriority.TreeMapComparator.INSTANCE);
        interceptorsToUse.putAll(globalInterceptorsMap);
        interceptorsToUse.putAll(methodSpecificInterceptorsMap);
        for (ResourceInterceptor<T> nameInterceptor : nameInterceptorsMap.keySet()) {
            if (!method.getNameBindingNames().containsAll(nameInterceptor.getNameBindingNames())) continue;
            interceptorsToUse.put(nameInterceptor, nameInterceptorsMap.get(nameInterceptor));
        }
        return interceptorsToUse;
    }

    public static void validateRequestFilterThreadModel(Collection<ResourceInterceptor<ContainerRequestFilter>> requestFilters) {
        boolean unsetNonBlockingInterceptorFound = false;
        for (ResourceInterceptor<ContainerRequestFilter> filter : requestFilters) {
            if (filter.isNonBlockingRequired()) {
                if (!unsetNonBlockingInterceptorFound) continue;
                throw new RuntimeException("ContainerRequestFilters that are marked as '@NonBlocking' must be executed before any other filters.");
            }
            unsetNonBlockingInterceptorFound = true;
        }
    }

    public class MethodInterceptorContext {
        private final ResourceMethod method;
        final Map<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> methodSpecificRequestInterceptorsMap;
        final Map<ResourceInterceptor<ContainerResponseFilter>, ContainerResponseFilter> methodSpecificResponseInterceptorsMap;
        final Map<ResourceInterceptor<ReaderInterceptor>, ReaderInterceptor> methodSpecificReaderInterceptorsMap;
        final Map<ResourceInterceptor<WriterInterceptor>, WriterInterceptor> methodSpecificWriterInterceptorsMap;

        MethodInterceptorContext(ResourceMethod method, ResteasyReactiveResourceInfo lazyMethod) {
            boolean dynamicFeaturesExist;
            this.method = method;
            Map methodSpecificRequestInterceptorsMap = Collections.emptyMap();
            Map methodSpecificResponseInterceptorsMap = Collections.emptyMap();
            Map methodSpecificReaderInterceptorsMap = Collections.emptyMap();
            Map methodSpecificWriterInterceptorsMap = Collections.emptyMap();
            DynamicFeatures dynamicFeatures = RuntimeInterceptorDeployment.this.info.getDynamicFeatures();
            boolean bl = dynamicFeaturesExist = !dynamicFeatures.getResourceDynamicFeatures().isEmpty();
            if (dynamicFeaturesExist) {
                ResourceInterceptors dynamicallyConfiguredInterceptors = new ResourceInterceptors();
                DynamicFeatureContext context = new DynamicFeatureContext(dynamicallyConfiguredInterceptors, RuntimeInterceptorDeployment.this.configurationImpl, RuntimeInterceptorDeployment.this.info.getFactoryCreator());
                for (ResourceDynamicFeature resourceDynamicFeature : dynamicFeatures.getResourceDynamicFeatures()) {
                    DynamicFeature feature = (DynamicFeature)resourceDynamicFeature.getFactory().createInstance().getInstance();
                    feature.configure((ResourceInfo)lazyMethod, (FeatureContext)context);
                }
                dynamicallyConfiguredInterceptors.sort();
                if (!dynamicallyConfiguredInterceptors.getContainerRequestFilters().getGlobalResourceInterceptors().isEmpty()) {
                    methodSpecificRequestInterceptorsMap = RuntimeInterceptorDeployment.this.createInterceptorInstances(dynamicallyConfiguredInterceptors.getContainerRequestFilters().getGlobalResourceInterceptors(), RuntimeInterceptorDeployment.this.closeTaskHandler);
                }
                if (!dynamicallyConfiguredInterceptors.getContainerResponseFilters().getGlobalResourceInterceptors().isEmpty()) {
                    methodSpecificResponseInterceptorsMap = RuntimeInterceptorDeployment.this.createInterceptorInstances(dynamicallyConfiguredInterceptors.getContainerResponseFilters().getGlobalResourceInterceptors(), RuntimeInterceptorDeployment.this.closeTaskHandler);
                }
                if (!dynamicallyConfiguredInterceptors.getReaderInterceptors().getGlobalResourceInterceptors().isEmpty()) {
                    methodSpecificReaderInterceptorsMap = RuntimeInterceptorDeployment.this.createInterceptorInstances(dynamicallyConfiguredInterceptors.getReaderInterceptors().getGlobalResourceInterceptors(), RuntimeInterceptorDeployment.this.closeTaskHandler);
                }
                if (!dynamicallyConfiguredInterceptors.getWriterInterceptors().getGlobalResourceInterceptors().isEmpty()) {
                    methodSpecificWriterInterceptorsMap = RuntimeInterceptorDeployment.this.createInterceptorInstances(dynamicallyConfiguredInterceptors.getWriterInterceptors().getGlobalResourceInterceptors(), RuntimeInterceptorDeployment.this.closeTaskHandler);
                }
            }
            this.methodSpecificReaderInterceptorsMap = methodSpecificReaderInterceptorsMap;
            this.methodSpecificRequestInterceptorsMap = methodSpecificRequestInterceptorsMap;
            this.methodSpecificWriterInterceptorsMap = methodSpecificWriterInterceptorsMap;
            this.methodSpecificResponseInterceptorsMap = methodSpecificResponseInterceptorsMap;
        }

        public List<ServerRestHandler> setupResponseFilterHandler() {
            ArrayList<ServerRestHandler> responseFilterHandlers = new ArrayList<ServerRestHandler>();
            if (this.method.getNameBindingNames().isEmpty() && this.methodSpecificResponseInterceptorsMap.isEmpty()) {
                if (!RuntimeInterceptorDeployment.this.globalResponseInterceptorHandlers.isEmpty()) {
                    responseFilterHandlers.addAll(RuntimeInterceptorDeployment.this.globalResponseInterceptorHandlers);
                }
            } else if (RuntimeInterceptorDeployment.this.nameResponseInterceptorsMap.isEmpty() && this.methodSpecificResponseInterceptorsMap.isEmpty()) {
                if (!RuntimeInterceptorDeployment.this.globalResponseInterceptorHandlers.isEmpty()) {
                    responseFilterHandlers.addAll(RuntimeInterceptorDeployment.this.globalResponseInterceptorHandlers);
                }
            } else {
                TreeMap<ResourceInterceptor<ContainerResponseFilter>, ContainerResponseFilter> interceptorsToUse = RuntimeInterceptorDeployment.this.buildInterceptorMap(RuntimeInterceptorDeployment.this.globalResponseInterceptorsMap, RuntimeInterceptorDeployment.this.nameResponseInterceptorsMap, this.methodSpecificResponseInterceptorsMap, this.method, true);
                for (Map.Entry<ResourceInterceptor<ContainerResponseFilter>, ContainerResponseFilter> entry : interceptorsToUse.entrySet()) {
                    responseFilterHandlers.add(new ResourceResponseFilterHandler(entry.getValue()));
                }
            }
            return responseFilterHandlers;
        }

        public ServerRestHandler setupInterceptorHandler() {
            int idx;
            ArrayList handlers = new ArrayList();
            if (this.method.getNameBindingNames().isEmpty() && this.methodSpecificReaderInterceptorsMap.isEmpty() && this.methodSpecificWriterInterceptorsMap.isEmpty()) {
                return RuntimeInterceptorDeployment.this.globalInterceptorHandler;
            }
            if (RuntimeInterceptorDeployment.this.nameReaderInterceptorsMap.isEmpty() && RuntimeInterceptorDeployment.this.nameWriterInterceptorsMap.isEmpty() && this.methodSpecificReaderInterceptorsMap.isEmpty() && this.methodSpecificWriterInterceptorsMap.isEmpty()) {
                return RuntimeInterceptorDeployment.this.globalInterceptorHandler;
            }
            TreeMap<ResourceInterceptor<ReaderInterceptor>, ReaderInterceptor> readerInterceptorsToUse = RuntimeInterceptorDeployment.this.buildInterceptorMap(RuntimeInterceptorDeployment.this.globalReaderInterceptorsMap, RuntimeInterceptorDeployment.this.nameReaderInterceptorsMap, this.methodSpecificReaderInterceptorsMap, this.method, false);
            TreeMap<ResourceInterceptor<WriterInterceptor>, WriterInterceptor> writerInterceptorsToUse = RuntimeInterceptorDeployment.this.buildInterceptorMap(RuntimeInterceptorDeployment.this.globalWriterInterceptorsMap, RuntimeInterceptorDeployment.this.nameWriterInterceptorsMap, this.methodSpecificWriterInterceptorsMap, this.method, false);
            WriterInterceptor[] writers = null;
            ReaderInterceptor[] readers = null;
            if (!readerInterceptorsToUse.isEmpty()) {
                readers = new ReaderInterceptor[readerInterceptorsToUse.size()];
                idx = 0;
                for (ReaderInterceptor readerInterceptor : readerInterceptorsToUse.values()) {
                    readers[idx++] = readerInterceptor;
                }
            }
            if (!writerInterceptorsToUse.isEmpty()) {
                writers = new WriterInterceptor[writerInterceptorsToUse.size()];
                idx = 0;
                for (WriterInterceptor writerInterceptor : writerInterceptorsToUse.values()) {
                    writers[idx++] = writerInterceptor;
                }
            }
            return new InterceptorHandler(writers, readers);
        }

        public List<ResourceRequestFilterHandler> setupRequestFilterHandler() {
            ArrayList<ResourceRequestFilterHandler> handlers = new ArrayList<ResourceRequestFilterHandler>();
            if (this.method.getNameBindingNames().isEmpty() && this.methodSpecificRequestInterceptorsMap.isEmpty()) {
                if (!RuntimeInterceptorDeployment.this.globalRequestInterceptorHandlers.isEmpty()) {
                    handlers.addAll(RuntimeInterceptorDeployment.this.globalRequestInterceptorHandlers);
                }
            } else if (RuntimeInterceptorDeployment.this.nameRequestInterceptorsMap.isEmpty() && this.methodSpecificRequestInterceptorsMap.isEmpty()) {
                if (!RuntimeInterceptorDeployment.this.globalRequestInterceptorHandlers.isEmpty()) {
                    handlers.addAll(RuntimeInterceptorDeployment.this.globalRequestInterceptorHandlers);
                }
            } else {
                TreeMap<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> interceptorsToUse = RuntimeInterceptorDeployment.this.buildInterceptorMap(RuntimeInterceptorDeployment.this.globalRequestInterceptorsMap, RuntimeInterceptorDeployment.this.nameRequestInterceptorsMap, this.methodSpecificRequestInterceptorsMap, this.method, false);
                RuntimeInterceptorDeployment.validateRequestFilterThreadModel(interceptorsToUse.keySet());
                for (Map.Entry<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> entry : interceptorsToUse.entrySet()) {
                    handlers.add(new ResourceRequestFilterHandler(entry.getValue(), false, entry.getKey().isNonBlockingRequired(), entry.getKey().isWithFormRead()));
                }
            }
            return handlers;
        }

        public boolean hasWriterInterceptors() {
            if (this.method.getNameBindingNames().isEmpty() && this.methodSpecificReaderInterceptorsMap.isEmpty() && this.methodSpecificWriterInterceptorsMap.isEmpty()) {
                if (RuntimeInterceptorDeployment.this.globalInterceptorHandler != null) {
                    return RuntimeInterceptorDeployment.this.globalInterceptorHandler.hasWriterInterceptors();
                }
            } else if (RuntimeInterceptorDeployment.this.nameReaderInterceptorsMap.isEmpty() && RuntimeInterceptorDeployment.this.nameWriterInterceptorsMap.isEmpty() && this.methodSpecificReaderInterceptorsMap.isEmpty() && this.methodSpecificWriterInterceptorsMap.isEmpty()) {
                if (RuntimeInterceptorDeployment.this.globalInterceptorHandler != null) {
                    return RuntimeInterceptorDeployment.this.globalInterceptorHandler.hasWriterInterceptors();
                }
            } else {
                TreeMap<ResourceInterceptor<WriterInterceptor>, WriterInterceptor> writerInterceptorsToUse = RuntimeInterceptorDeployment.this.buildInterceptorMap(RuntimeInterceptorDeployment.this.globalWriterInterceptorsMap, RuntimeInterceptorDeployment.this.nameWriterInterceptorsMap, this.methodSpecificWriterInterceptorsMap, this.method, false);
                return !writerInterceptorsToUse.isEmpty();
            }
            return false;
        }
    }
}

