/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.core.multipart.FormDataParser;
import org.jboss.resteasy.reactive.server.core.multipart.FormParserFactory;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

public class FormEncodedDataDefinition
implements FormParserFactory.ParserDefinition<FormEncodedDataDefinition> {
    private static final Logger log = Logger.getLogger(FormEncodedDataDefinition.class);
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private String defaultEncoding = "ISO-8859-1";
    private boolean forceCreation = false;
    private int maxParams = 1000;
    private long maxAttributeSize = 2048L;

    @Override
    public FormDataParser create(ResteasyReactiveRequestContext exchange) {
        String mimeType = exchange.serverRequest().getRequestHeader("Content-Type");
        if (this.forceCreation || mimeType != null && mimeType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED)) {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = exchange.serverRequest().getRequestHeader("Content-Type");
            if (contentType != null && (cs = HeaderUtil.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                charset = cs;
            }
            log.tracef("Created form encoded parser for %s", (Object)exchange);
            return new FormEncodedDataParser(charset, exchange, this.maxParams, this.maxAttributeSize);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isForceCreation() {
        return this.forceCreation;
    }

    public int getMaxParams() {
        return this.maxParams;
    }

    public long getMaxAttributeSize() {
        return this.maxAttributeSize;
    }

    public FormEncodedDataDefinition setMaxAttributeSize(long maxAttributeSize) {
        this.maxAttributeSize = maxAttributeSize;
        return this;
    }

    public FormEncodedDataDefinition setMaxParams(int maxParams) {
        this.maxParams = maxParams;
        return this;
    }

    public FormEncodedDataDefinition setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
        return this;
    }

    @Override
    public FormEncodedDataDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private static final class FormEncodedDataParser
    implements ServerHttpRequest.ReadCallback,
    FormDataParser {
        private final ResteasyReactiveRequestContext exchange;
        private final FormData data;
        private final StringBuilder builder = new StringBuilder();
        private final long maxAttributeSize;
        private String name = null;
        private String charset;
        private int state = 0;

        private FormEncodedDataParser(String charset, ResteasyReactiveRequestContext exchange, int maxParams, long maxAttributeSize) {
            this.exchange = exchange;
            this.charset = charset;
            this.data = new FormData(maxParams);
            this.maxAttributeSize = maxAttributeSize;
        }

        private void doParse(ByteBuffer buffer) throws IOException {
            while (buffer.hasRemaining()) {
                byte n = buffer.get();
                switch (this.state) {
                    case 0: {
                        if (n == 61) {
                            if ((long)this.builder.length() > this.maxAttributeSize) {
                                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                            }
                            this.name = this.builder.toString();
                            this.builder.setLength(0);
                            this.state = 2;
                            break;
                        }
                        if (n == 38) {
                            if ((long)this.builder.length() > this.maxAttributeSize) {
                                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                            }
                            this.addPair(this.builder.toString(), "");
                            this.builder.setLength(0);
                            this.state = 0;
                            break;
                        }
                        if (n == 37 || n == 43 || n < 0) {
                            this.state = 1;
                            this.builder.append((char)(n & 0xFF));
                            break;
                        }
                        this.builder.append((char)n);
                        break;
                    }
                    case 1: {
                        if (n == 61) {
                            if ((long)this.builder.length() > this.maxAttributeSize) {
                                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                            }
                            this.name = this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder());
                            this.builder.setLength(0);
                            this.state = 2;
                            break;
                        }
                        if (n == 38) {
                            this.addPair(this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                            this.builder.setLength(0);
                            this.state = 0;
                            break;
                        }
                        this.builder.append((char)(n & 0xFF));
                        break;
                    }
                    case 2: {
                        if (n == 38) {
                            if ((long)this.builder.length() > this.maxAttributeSize) {
                                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                            }
                            this.addPair(this.name, this.builder.toString());
                            this.builder.setLength(0);
                            this.state = 0;
                            break;
                        }
                        if (n == 37 || n == 43 || n < 0) {
                            this.state = 3;
                            this.builder.append((char)(n & 0xFF));
                            break;
                        }
                        this.builder.append((char)n);
                        break;
                    }
                    case 3: {
                        if (n == 38) {
                            if ((long)this.builder.length() > this.maxAttributeSize) {
                                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                            }
                            this.addPair(this.name, this.decodeParameterValue(this.name, this.builder.toString(), this.charset, true, new StringBuilder()));
                            this.builder.setLength(0);
                            this.state = 0;
                            break;
                        }
                        this.builder.append((char)(n & 0xFF));
                    }
                }
            }
            if ((long)this.builder.length() > this.maxAttributeSize) {
                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            }
        }

        private void addPair(String name, String value) {
            if (name != null && value != null) {
                this.data.add(name, value);
            }
        }

        private String decodeParameterValue(String name, String value, String charset, boolean decodeSlash, StringBuilder stringBuilder) {
            return URLUtils.decode((String)value, (Charset)Charset.forName(charset), (boolean)decodeSlash, (StringBuilder)stringBuilder);
        }

        private String decodeParameterName(String name, String charset, boolean decodeSlash, StringBuilder stringBuilder) {
            return URLUtils.decode((String)name, (Charset)Charset.forName(charset), (boolean)decodeSlash, (StringBuilder)stringBuilder);
        }

        @Override
        public void parse() throws Exception {
            if (this.exchange.getFormData() != null) {
                return;
            }
            this.exchange.suspend();
            this.exchange.serverRequest().setReadListener(this);
            this.exchange.serverRequest().resumeRequestInput();
        }

        @Override
        public FormData parseBlocking() throws Exception {
            FormData existing = this.exchange.getFormData();
            if (existing != null) {
                return existing;
            }
            try (InputStream input = this.exchange.getInputStream();){
                int c;
                byte[] data = new byte[1024];
                while ((c = input.read(data)) > 0) {
                    ByteBuffer buf = ByteBuffer.wrap(data, 0, c);
                    this.doParse(buf);
                }
                this.inputDone();
                FormData formData = this.data;
                return formData;
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.charset = encoding;
        }

        @Override
        public void done() {
            this.inputDone();
            this.exchange.resume();
        }

        private void inputDone() {
            if (this.state == 2) {
                this.addPair(this.name, this.builder.toString());
            } else if (this.state == 3) {
                this.addPair(this.name, this.decodeParameterValue(this.name, this.builder.toString(), this.charset, true, new StringBuilder()));
            } else if (this.builder.length() > 0) {
                if (this.state == 1) {
                    this.addPair(this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                } else {
                    this.addPair(this.builder.toString(), "");
                }
            }
            this.state = 4;
            this.exchange.setFormData(this.data);
        }

        @Override
        public void data(ByteBuffer data) {
            try {
                this.doParse(data);
            }
            catch (Exception e) {
                this.exchange.resume(e);
            }
        }
    }
}

