/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.core.multipart.FormDataParser;
import org.jboss.resteasy.reactive.server.core.multipart.FormEncodedDataDefinition;
import org.jboss.resteasy.reactive.server.core.multipart.FormParserFactory;
import org.jboss.resteasy.reactive.server.core.multipart.MultiPartParserDefinition;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class FormBodyHandler
implements ServerRestHandler,
RuntimeConfigurableServerRestHandler {
    private static final byte[] NO_BYTES = new byte[0];
    private final boolean alsoSetInputStream;
    private final Supplier<Executor> executorSupplier;
    private volatile FormParserFactory formParserFactory;

    public FormBodyHandler(boolean alsoSetInputStream, Supplier<Executor> executorSupplier) {
        this.alsoSetInputStream = alsoSetInputStream;
        this.executorSupplier = executorSupplier;
    }

    @Override
    public void configure(RuntimeConfiguration configuration) {
        this.formParserFactory = FormParserFactory.builder(false, this.executorSupplier).addParser(new MultiPartParserDefinition(this.executorSupplier).setFileSizeThreshold(0L).setMaxAttributeSize(configuration.limits().maxFormAttributeSize()).setMaxEntitySize(configuration.limits().maxBodySize().orElse(-1L)).setDeleteUploadsOnEnd(configuration.body().deleteUploadedFilesOnEnd()).setTempFileLocation(Path.of(configuration.body().uploadsDirectory(), new String[0]))).addParser(new FormEncodedDataDefinition().setMaxAttributeSize(configuration.limits().maxFormAttributeSize())).build();
        try {
            Files.createDirectories(Paths.get(configuration.body().uploadsDirectory(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        if (requestContext.getFormData() != null) {
            return;
        }
        FormData existingParsedForm = requestContext.serverRequest().getExistingParsedForm();
        if (existingParsedForm != null) {
            requestContext.setFormData(existingParsedForm);
            return;
        }
        ServerHttpRequest serverHttpRequest = requestContext.serverRequest();
        if (BlockingOperationSupport.isBlockingAllowed()) {
            FormDataParser factory = this.formParserFactory.createParser(requestContext);
            if (factory == null) {
                return;
            }
            CapturingInputStream cis = null;
            if (this.alsoSetInputStream) {
                cis = new CapturingInputStream(requestContext.getInputStream());
                requestContext.setInputStream(cis);
            }
            factory.parseBlocking();
            if (this.alsoSetInputStream) {
                requestContext.setInputStream(new ByteArrayInputStream(cis.baos.toByteArray()));
            }
        } else if (this.alsoSetInputStream) {
            final FormDataParser factory = this.formParserFactory.createParser(requestContext);
            if (factory == null) {
                return;
            }
            requestContext.suspend();
            this.executorSupplier.get().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CapturingInputStream cis = new CapturingInputStream(requestContext.getInputStream());
                        requestContext.setInputStream(cis);
                        factory.parseBlocking();
                        requestContext.setInputStream(new ByteArrayInputStream(cis.baos.toByteArray()));
                        requestContext.resume();
                    }
                    catch (Throwable t) {
                        requestContext.resume(t);
                    }
                }
            });
        } else {
            FormDataParser factory = this.formParserFactory.createParser(requestContext);
            if (factory == null) {
                return;
            }
            factory.parse();
        }
    }

    static final class CapturingInputStream
    extends InputStream {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final InputStream delegate;

        CapturingInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            int res = this.delegate.read();
            this.baos.write(res);
            return res;
        }
    }
}

