/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.parameters.ContextParamExtractor;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ReflectiveContextInjectedBeanFactory<T>
implements BeanFactory<T> {
    public static final Function<Class<?>, BeanFactory<?>> FACTORY = new Function<Class<?>, BeanFactory<?>>(){

        @Override
        public BeanFactory<?> apply(Class<?> aClass) {
            return new ReflectiveContextInjectedBeanFactory(aClass);
        }
    };
    public static final Function<String, BeanFactory<?>> STRING_FACTORY = new Function<String, BeanFactory<?>>(){

        @Override
        public BeanFactory<?> apply(String name) {
            try {
                return new ReflectiveContextInjectedBeanFactory(Thread.currentThread().getContextClassLoader().loadClass(name));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Constructor<T> constructor;
    private final Map<Field, Object> proxiesToInject;

    public ReflectiveContextInjectedBeanFactory(Class<T> clazz) {
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
            this.constructor.setAccessible(true);
            this.proxiesToInject = new HashMap<Field, Object>();
            for (Class<T> c = clazz; c != Object.class; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                    final ContextParamExtractor contextParamExtractor = new ContextParamExtractor(f.getType());
                    if (!f.isAnnotationPresent(Context.class)) continue;
                    f.setAccessible(true);
                    this.proxiesToInject.put(f, Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{f.getType()}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object delegate = contextParamExtractor.extractParameter(CurrentRequestManager.get());
                            return method.invoke(delegate, args);
                        }
                    }));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public BeanFactory.BeanInstance<T> createInstance() {
        try {
            final T instance = this.constructor.newInstance(new Object[0]);
            for (Map.Entry<Field, Object> i : this.proxiesToInject.entrySet()) {
                i.getKey().set(instance, i.getValue());
            }
            return new BeanFactory.BeanInstance<T>(){

                public T getInstance() {
                    return instance;
                }

                public void close() {
                }
            };
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

