/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ExceptionMapping {
    final Map<String, ResourceExceptionMapper<? extends Throwable>> mappers = new HashMap<String, ResourceExceptionMapper<? extends Throwable>>();
    final List<Predicate<Throwable>> blockingProblemPredicates = new ArrayList<Predicate<Throwable>>();
    final List<Predicate<Throwable>> nonBlockingProblemPredicate = new ArrayList<Predicate<Throwable>>();
    final Set<String> unwrappedExceptions = new HashSet<String>();

    public void addBlockingProblem(Class<? extends Throwable> throwable) {
        this.blockingProblemPredicates.add(new ExceptionTypePredicate(throwable));
    }

    public void addBlockingProblem(Predicate<Throwable> predicate) {
        this.blockingProblemPredicates.add(predicate);
    }

    public void addNonBlockingProblem(Class<? extends Throwable> throwable) {
        this.nonBlockingProblemPredicate.add(new ExceptionTypePredicate(throwable));
    }

    public void addNonBlockingProblem(Predicate<Throwable> predicate) {
        this.nonBlockingProblemPredicate.add(predicate);
    }

    public void addUnwrappedException(String className) {
        this.unwrappedExceptions.add(className);
    }

    public Set<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public List<Predicate<Throwable>> getBlockingProblemPredicates() {
        return this.blockingProblemPredicates;
    }

    public List<Predicate<Throwable>> getNonBlockingProblemPredicate() {
        return this.nonBlockingProblemPredicate;
    }

    public <T extends Throwable> void addExceptionMapper(String exceptionClass, ResourceExceptionMapper<T> mapper) {
        ResourceExceptionMapper<? extends Throwable> existing = this.mappers.get(exceptionClass);
        if (existing != null && existing.getPriority() < mapper.getPriority()) {
            return;
        }
        this.mappers.put(exceptionClass, mapper);
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (Map.Entry<String, ResourceExceptionMapper<? extends Throwable>> entry : this.mappers.entrySet()) {
            if (entry.getValue().getFactory() != null) continue;
            entry.getValue().setFactory(factoryCreator.apply(entry.getValue().getClassName()));
        }
    }

    public Map<String, ResourceExceptionMapper<? extends Throwable>> getMappers() {
        return this.mappers;
    }

    public static class ExceptionTypeAndMessageContainsPredicate
    implements Predicate<Throwable> {
        private Class<? extends Throwable> throwable;
        private String messagePart;

        public ExceptionTypeAndMessageContainsPredicate() {
        }

        public ExceptionTypeAndMessageContainsPredicate(Class<? extends Throwable> throwable, String messagePart) {
            this.throwable = throwable;
            this.messagePart = messagePart;
        }

        public Class<? extends Throwable> getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        public String getMessagePart() {
            return this.messagePart;
        }

        public void setMessagePart(String messagePart) {
            this.messagePart = messagePart;
        }

        @Override
        public boolean test(Throwable t) {
            return t.getClass().equals(this.throwable) && t.getMessage().contains(this.messagePart);
        }
    }

    public static class ExceptionTypePredicate
    implements Predicate<Throwable> {
        private Class<? extends Throwable> throwable;

        public ExceptionTypePredicate() {
        }

        public ExceptionTypePredicate(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        public Class<? extends Throwable> getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        @Override
        public boolean test(Throwable t) {
            return t.getClass().equals(this.throwable);
        }
    }
}

