/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.providers.serialisers;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jboss.resteasy.reactive.common.providers.serialisers.PathBodyHandler;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Provider
@Produces(value={"*/*"})
public class ServerPathBodyHandler
extends PathBodyHandler
implements ServerMessageBodyWriter<Path> {
    public long getSize(Path o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            return Files.size(o);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return Path.class.isAssignableFrom(type);
    }

    @Override
    public void writeResponse(Path o, Type genericType, ServerRequestContext context) throws WebApplicationException {
        ServerHttpResponse serverResponse = context.serverResponse();
        serverResponse.sendFile(o.toString(), 0L, Long.MAX_VALUE);
    }
}

