/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.RuntimeExceptionMapper;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeInterceptorDeployment;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeMappingDeployment;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeResourceDeployment;
import org.jboss.resteasy.reactive.server.handlers.ClassRoutingHandler;
import org.jboss.resteasy.reactive.server.handlers.ExceptionHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceLocatorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.jaxrs.FeatureContextImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.GenericRuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RuntimeDeploymentManager {
    public static final ServerRestHandler[] EMPTY_REST_HANDLER_ARRAY = new ServerRestHandler[0];
    private final DeploymentInfo info;
    private final Supplier<Executor> executorSupplier;
    private final Supplier<Executor> virtualExecutorSupplier;
    private final Consumer<Closeable> closeTaskHandler;
    private final RequestContextFactory requestContextFactory;
    private final ThreadSetupAction threadSetupAction;
    private final String rootPath;
    private List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers;

    public RuntimeDeploymentManager(DeploymentInfo info, Supplier<Executor> executorSupplier, Supplier<Executor> virtualExecutorSupplier, Consumer<Closeable> closeTaskHandler, RequestContextFactory requestContextFactory, ThreadSetupAction threadSetupAction, String rootPath) {
        this.info = info;
        this.executorSupplier = executorSupplier;
        this.virtualExecutorSupplier = virtualExecutorSupplier;
        this.closeTaskHandler = closeTaskHandler;
        this.requestContextFactory = requestContextFactory;
        this.threadSetupAction = threadSetupAction;
        this.rootPath = rootPath;
    }

    public Deployment deploy() {
        ResourceInterceptors interceptors = this.info.getInterceptors();
        ServerSerialisers serialisers = this.info.getSerialisers();
        Features features = this.info.getFeatures();
        ExceptionMapping exceptionMapping = this.info.getExceptionMapping();
        List<ResourceClass> resourceClasses = this.info.getResourceClasses();
        List<ResourceClass> locatableResourceClasses = this.info.getLocatableResourceClasses();
        ParamConverterProviders paramConverterProviders = this.info.getParamConverterProviders();
        Supplier<Application> applicationSupplier = this.info.getApplicationSupplier();
        String applicationPath = this.info.getApplicationPath();
        DynamicEntityWriter dynamicEntityWriter = new DynamicEntityWriter(serialisers);
        RuntimeExceptionMapper exceptionMapper = new RuntimeExceptionMapper(exceptionMapping, Thread.currentThread().getContextClassLoader());
        ConfigurationImpl configurationImpl = this.configureFeatures(features, interceptors, exceptionMapper);
        RuntimeInterceptorDeployment interceptorDeployment = new RuntimeInterceptorDeployment(this.info, configurationImpl, this.closeTaskHandler);
        ResourceLocatorHandler resourceLocatorHandler = new ResourceLocatorHandler(new Function<Class<?>, BeanFactory.BeanInstance<?>>(){

            @Override
            public BeanFactory.BeanInstance<?> apply(Class<?> aClass) {
                return RuntimeDeploymentManager.this.info.getFactoryCreator().apply(aClass).createInstance();
            }
        });
        ArrayList runtimeConfigurableServerRestHandlers = new ArrayList();
        RuntimeResourceDeployment runtimeResourceDeployment = new RuntimeResourceDeployment(this.info, this.executorSupplier, this.virtualExecutorSupplier, interceptorDeployment, dynamicEntityWriter, resourceLocatorHandler, this.requestContextFactory.isDefaultBlocking());
        ArrayList<ResourceClass> possibleSubResource = new ArrayList<ResourceClass>(locatableResourceClasses);
        possibleSubResource.addAll(resourceClasses);
        for (int i = 0; i < possibleSubResource.size(); ++i) {
            ResourceClass clazz = (ResourceClass)possibleSubResource.get(i);
            HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> templates = new HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>();
            URITemplate classPathTemplate = clazz.getPath() == null ? null : new URITemplate(clazz.getPath(), true);
            for (int j = 0; j < clazz.getMethods().size(); ++j) {
                ResourceMethod method = (ResourceMethod)clazz.getMethods().get(j);
                RuntimeResource runtimeResource = runtimeResourceDeployment.buildResourceMethod(clazz, (ServerResourceMethod)method, true, classPathTemplate, this.info);
                this.addRuntimeConfigurableHandlers(runtimeResource, runtimeConfigurableServerRestHandlers);
                RuntimeMappingDeployment.buildMethodMapper(templates, method, runtimeResource);
            }
            Map<String, RequestMapper<RuntimeResource>> mappersByMethod = new RuntimeMappingDeployment(templates).buildClassMapper();
            resourceLocatorHandler.addResource(DeploymentUtils.loadClass((String)clazz.getClassName()), mappersByMethod);
        }
        TreeMap<URITemplate, Map> mappers = new TreeMap<URITemplate, Map>();
        for (int i = 0; i < resourceClasses.size(); ++i) {
            ResourceClass clazz = resourceClasses.get(i);
            URITemplate classTemplate = new URITemplate(clazz.getPath(), true);
            HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> perClassMappers = (HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>)mappers.get(classTemplate);
            if (perClassMappers == null) {
                perClassMappers = new HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>();
                mappers.put(classTemplate, perClassMappers);
            }
            for (int j = 0; j < clazz.getMethods().size(); ++j) {
                ResourceMethod method = (ResourceMethod)clazz.getMethods().get(j);
                RuntimeResource runtimeResource = runtimeResourceDeployment.buildResourceMethod(clazz, (ServerResourceMethod)method, false, classTemplate, this.info);
                this.addRuntimeConfigurableHandlers(runtimeResource, runtimeConfigurableServerRestHandlers);
                RuntimeMappingDeployment.buildMethodMapper(perClassMappers, method, runtimeResource);
            }
        }
        this.classMappers = new ArrayList<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>>(mappers.size());
        mappers.forEach(this::forEachMapperEntry);
        ArrayList<ServerRestHandler> abortHandlingChain = new ArrayList<ServerRestHandler>(3);
        if (interceptorDeployment.getGlobalInterceptorHandler() != null) {
            abortHandlingChain.add(interceptorDeployment.getGlobalInterceptorHandler());
        }
        abortHandlingChain.add(new ExceptionHandler());
        abortHandlingChain.add(ResponseHandler.NO_CUSTOMIZER_INSTANCE);
        if (!interceptors.getContainerResponseFilters().getGlobalResourceInterceptors().isEmpty()) {
            abortHandlingChain.addAll(interceptorDeployment.getGlobalResponseInterceptorHandlers());
        }
        abortHandlingChain.add(new ResponseWriterHandler(dynamicEntityWriter));
        Object prefix = this.rootPath;
        prefix = prefix != null ? this.sanitizePathPrefix((String)prefix) : "";
        if (applicationPath != null && !applicationPath.isEmpty()) {
            prefix = (String)prefix + this.sanitizePathPrefix(applicationPath);
        }
        ArrayList<ServerRestHandler> preMatchHandlers = new ArrayList<ServerRestHandler>();
        for (int i = 0; i < this.info.getGlobalHandlerCustomizers().size(); ++i) {
            preMatchHandlers.addAll(this.info.getGlobalHandlerCustomizers().get(i).handlers(HandlerChainCustomizer.Phase.BEFORE_PRE_MATCH, null, null));
        }
        if (!interceptors.getContainerRequestFilters().getPreMatchInterceptors().isEmpty()) {
            preMatchHandlers = new ArrayList(interceptorDeployment.getPreMatchContainerRequestFilters().size());
            for (Map.Entry<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> entry : interceptorDeployment.getPreMatchContainerRequestFilters().entrySet()) {
                preMatchHandlers.add(new ResourceRequestFilterHandler(entry.getValue(), true, entry.getKey().isNonBlockingRequired(), entry.getKey().isReadBody()));
            }
        }
        for (int i = 0; i < this.info.getGlobalHandlerCustomizers().size(); ++i) {
            preMatchHandlers.addAll(this.info.getGlobalHandlerCustomizers().get(i).handlers(HandlerChainCustomizer.Phase.AFTER_PRE_MATCH, null, null));
        }
        return new Deployment(exceptionMapping, this.info.getCtxResolvers(), serialisers, abortHandlingChain.toArray(EMPTY_REST_HANDLER_ARRAY), dynamicEntityWriter, (String)prefix, paramConverterProviders, configurationImpl, applicationSupplier, this.threadSetupAction, this.requestContextFactory, preMatchHandlers, this.classMappers, runtimeConfigurableServerRestHandlers, exceptionMapper, this.info.isResumeOn404(), this.info.getResteasyReactiveConfig());
    }

    private void forEachMapperEntry(URITemplate path, Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> classTemplates) {
        int classTemplateNameCount = path.countPathParamNames();
        RuntimeMappingDeployment runtimeMappingDeployment = new RuntimeMappingDeployment(classTemplates);
        ClassRoutingHandler classRoutingHandler = new ClassRoutingHandler(runtimeMappingDeployment.buildClassMapper(), classTemplateNameCount, this.info.isResumeOn404());
        this.classMappers.add(new RequestMapper.RequestPath<RestInitialHandler.InitialMatch>(true, path, new RestInitialHandler.InitialMatch(new ServerRestHandler[]{classRoutingHandler}, runtimeMappingDeployment.getMaxMethodTemplateNameCount() + classTemplateNameCount)));
    }

    private void addRuntimeConfigurableHandlers(RuntimeResource runtimeResource, List<GenericRuntimeConfigurableServerRestHandler<?>> runtimeConfigurableServerRestHandlers) {
        for (ServerRestHandler serverRestHandler : runtimeResource.getHandlerChain()) {
            if (!(serverRestHandler instanceof GenericRuntimeConfigurableServerRestHandler)) continue;
            runtimeConfigurableServerRestHandlers.add((GenericRuntimeConfigurableServerRestHandler)serverRestHandler);
        }
    }

    private ConfigurationImpl configureFeatures(Features features, ResourceInterceptors interceptors, RuntimeExceptionMapper exceptionMapping) {
        ConfigurationImpl configuration = new ConfigurationImpl(RuntimeType.SERVER);
        if (features.getResourceFeatures().isEmpty()) {
            return configuration;
        }
        FeatureContextImpl featureContext = new FeatureContextImpl(interceptors, exceptionMapping, configuration, this.info.getFactoryCreator());
        List<ResourceFeature> resourceFeatures = features.getResourceFeatures();
        for (ResourceFeature resourceFeature : resourceFeatures) {
            Feature feature = (Feature)resourceFeature.getFactory().createInstance().getInstance();
            boolean enabled = feature.configure((FeatureContext)featureContext);
            if (!enabled) continue;
            configuration.addEnabledFeature(feature);
        }
        if (featureContext.isFiltersNeedSorting()) {
            interceptors.sort();
        }
        return configuration;
    }

    private String sanitizePathPrefix(String prefix) {
        if (((String)(prefix = ((String)prefix).trim())).equals("/")) {
            prefix = "";
        }
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        if (((String)prefix).endsWith("/")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        return prefix;
    }
}

