/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class MediaTypeMapper
implements ServerRestHandler {
    private static final MediaType[] DEFAULT_MEDIA_TYPES = new MediaType[]{MediaType.WILDCARD_TYPE};
    private static final List<MediaType> DEFAULT_MEDIA_TYPES_LIST = List.of(DEFAULT_MEDIA_TYPES);
    final Map<MediaType, Holder> resourcesByConsumes = new HashMap<MediaType, Holder>();
    final List<MediaType> consumesTypes = new ArrayList<MediaType>();

    public MediaTypeMapper(List<RuntimeResource> runtimeResources) {
        for (RuntimeResource runtimeResource : runtimeResources) {
            List<MediaType> consumesMediaTypes = this.getConsumesMediaTypes(runtimeResource);
            for (MediaType consumedMediaType : consumesMediaTypes) {
                if (this.resourcesByConsumes.containsKey(consumedMediaType)) continue;
                this.consumesTypes.add(consumedMediaType);
                this.resourcesByConsumes.put(consumedMediaType, new Holder());
            }
            for (MediaType producesMT : this.getProducesMediaTypes(runtimeResource)) {
                for (MediaType consumedMediaType : consumesMediaTypes) {
                    this.resourcesByConsumes.get(consumedMediaType).setResource(runtimeResource, producesMT);
                }
            }
        }
        for (Holder holder : this.resourcesByConsumes.values()) {
            holder.setupServerMediaType();
        }
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        RuntimeResource selectedResource;
        MediaType consumes = MediaTypeHelper.getBestMatch(this.contentTypeFromRequest(requestContext), this.consumesTypes);
        Holder selectedHolder = this.resourcesByConsumes.get(consumes);
        if (selectedHolder == null) {
            selectedHolder = this.resourcesByConsumes.get(MediaType.WILDCARD_TYPE);
        }
        if (selectedHolder == null) {
            throw new NotSupportedException("The content-type header value did not match the value in @Consumes");
        }
        if (selectedHolder.mtWithoutParamsToResource.size() == 1) {
            selectedResource = selectedHolder.mtWithoutParamsToResource.values().iterator().next();
        } else {
            MediaType produces = this.selectMediaType(requestContext, selectedHolder);
            requestContext.setResponseContentType(produces);
            MediaType key = produces;
            if (!key.getParameters().isEmpty()) {
                key = new MediaType(key.getType(), key.getSubtype());
            }
            if ((selectedResource = selectedHolder.mtWithoutParamsToResource.get(key)) == null) {
                selectedResource = selectedHolder.mtWithoutParamsToResource.get(MediaType.WILDCARD_TYPE);
            }
        }
        if (selectedResource == null) {
            throw new WebApplicationException(Response.status((int)416).build());
        }
        requestContext.restart(selectedResource);
    }

    private List<MediaType> contentTypeFromRequest(ResteasyReactiveRequestContext requestContext) {
        List<String> contentTypeList = requestContext.getHttpHeaders().getRequestHeader("Content-Type");
        if (contentTypeList.isEmpty()) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(contentTypeList.size());
        for (String s : contentTypeList) {
            result.add(MediaTypeHelper.valueOf((String)s));
        }
        return result;
    }

    public MediaType selectMediaType(ResteasyReactiveRequestContext requestContext, Holder holder) {
        MediaType selected = null;
        List<String> accepts = requestContext.getHttpHeaders().getRequestHeader("Accept");
        for (String accept : accepts) {
            Map.Entry entry = holder.serverMediaType.negotiateProduces(accept, null);
            if (entry.getValue() == null) continue;
            selected = (MediaType)entry.getValue();
            break;
        }
        if (selected == null) {
            selected = holder.mtsWithParams.get(0);
        }
        if (selected.equals((Object)MediaType.WILDCARD_TYPE)) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return selected;
    }

    private MediaType[] getProducesMediaTypes(RuntimeResource runtimeResource) {
        return runtimeResource.getProduces() == null ? DEFAULT_MEDIA_TYPES : runtimeResource.getProduces().getSortedOriginalMediaTypes();
    }

    private List<MediaType> getConsumesMediaTypes(RuntimeResource runtimeResource) {
        return runtimeResource.getConsumes().isEmpty() ? DEFAULT_MEDIA_TYPES_LIST : runtimeResource.getConsumes();
    }

    private static final class Holder {
        private final Map<MediaType, RuntimeResource> mtWithoutParamsToResource = new HashMap<MediaType, RuntimeResource>();
        private final List<MediaType> mtsWithParams = new ArrayList<MediaType>();
        private ServerMediaType serverMediaType;

        private Holder() {
        }

        public void setResource(RuntimeResource runtimeResource, MediaType mediaType) {
            MediaType withoutParams = mediaType;
            MediaType withParas = mediaType;
            if (!mediaType.getParameters().isEmpty()) {
                withoutParams = new MediaType(mediaType.getType(), mediaType.getSubtype());
            }
            this.mtWithoutParamsToResource.put(withoutParams, runtimeResource);
            this.mtsWithParams.add(withParas);
        }

        public void setupServerMediaType() {
            MediaTypeHelper.sortByQSWeight(this.mtsWithParams);
            this.serverMediaType = new ServerMediaType(this.mtsWithParams, StandardCharsets.UTF_8.name(), true);
        }
    }
}

