/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.handlers.ClientErrorHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientRequestFilterRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseCompleteRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseFilterRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSendRequestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSetResponseEntityRestHandler;
import org.jboss.resteasy.reactive.client.handlers.PreResponseFilterHandler;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

class HandlerChain {
    private static final ClientRestHandler[] EMPTY_REST_HANDLERS = new ClientRestHandler[0];
    private final ClientRestHandler clientSendHandler;
    private final ClientRestHandler clientSetResponseEntityRestHandler;
    private final ClientRestHandler clientResponseCompleteRestHandler;
    private final ClientRestHandler clientErrorHandler;
    private ClientRestHandler preClientSendHandler = null;

    public HandlerChain(boolean followRedirects, LoggingScope loggingScope, Map<Class<?>, MultipartResponseData> multipartData, ClientLogger clientLogger) {
        this.clientSendHandler = new ClientSendRequestHandler(followRedirects, loggingScope, clientLogger, multipartData);
        this.clientSetResponseEntityRestHandler = new ClientSetResponseEntityRestHandler();
        this.clientResponseCompleteRestHandler = new ClientResponseCompleteRestHandler();
        this.clientErrorHandler = new ClientErrorHandler(loggingScope);
    }

    HandlerChain setPreClientSendHandler(ClientRestHandler preClientSendHandler) {
        this.preClientSendHandler = preClientSendHandler;
        return this;
    }

    ClientRestHandler[] createHandlerChain(ConfigurationImpl configuration) {
        int i;
        List requestFilters = configuration.getRequestFilters();
        List responseFilters = configuration.getResponseFilters();
        if (requestFilters.isEmpty() && responseFilters.isEmpty()) {
            return new ClientRestHandler[]{this.clientSendHandler, this.clientSetResponseEntityRestHandler, this.clientResponseCompleteRestHandler};
        }
        ArrayList<ClientRestHandler> result = new ArrayList<ClientRestHandler>((this.preClientSendHandler != null ? 4 : 3) + requestFilters.size() + responseFilters.size());
        for (i = 0; i < requestFilters.size(); ++i) {
            result.add(new ClientRequestFilterRestHandler((ClientRequestFilter)requestFilters.get(i)));
        }
        if (this.preClientSendHandler != null) {
            result.add(this.preClientSendHandler);
        }
        result.add(this.clientSendHandler);
        result.add(this.clientSetResponseEntityRestHandler);
        result.add(new PreResponseFilterHandler());
        for (i = 0; i < responseFilters.size(); ++i) {
            result.add(new ClientResponseFilterRestHandler((ClientResponseFilter)responseFilters.get(i)));
        }
        result.add(this.clientResponseCompleteRestHandler);
        return result.toArray(EMPTY_REST_HANDLERS);
    }

    ClientRestHandler[] createAbortHandlerChain(ConfigurationImpl configuration) {
        List responseFilters = configuration.getResponseFilters();
        if (responseFilters.isEmpty()) {
            return this.createAbortHandlerChainWithoutResponseFilters();
        }
        ArrayList<ClientRestHandler> result = new ArrayList<ClientRestHandler>(1 + responseFilters.size());
        for (int i = 0; i < responseFilters.size(); ++i) {
            result.add(new ClientResponseFilterRestHandler((ClientResponseFilter)responseFilters.get(i)));
        }
        result.add(this.clientErrorHandler);
        return result.toArray(EMPTY_REST_HANDLERS);
    }

    ClientRestHandler[] createAbortHandlerChainWithoutResponseFilters() {
        return new ClientRestHandler[]{this.clientErrorHandler};
    }
}

