/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.InboundSseEvent;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class InboundSseEventImpl
implements InboundSseEvent {
    private String id;
    private String name;
    private String comment;
    private String data;
    private MediaType mediaType;
    private long reconnectDelay = -1L;
    private Serialisers serialisers;
    private ConfigurationImpl configuration;

    public InboundSseEventImpl(ConfigurationImpl configuration, Serialisers serialisers) {
        this.configuration = configuration;
        this.serialisers = serialisers;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public InboundSseEventImpl setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public InboundSseEventImpl setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public InboundSseEventImpl setName(String name) {
        this.name = name;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public InboundSseEventImpl setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelay != -1L;
    }

    public InboundSseEventImpl setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        return this;
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    public String readData() {
        return this.data;
    }

    public InboundSseEventImpl setData(String data) {
        this.data = data;
        return this;
    }

    public <T> T readData(Class<T> type) {
        return this.readData(type, this.mediaType);
    }

    public <T> T readData(GenericType<T> type) {
        return this.readData(type, this.mediaType);
    }

    public <T> T readData(Class<T> messageType, MediaType mediaType) {
        return this.readData(new GenericType(messageType), mediaType);
    }

    public <T> T readData(GenericType<T> type, MediaType mediaType) {
        ByteArrayInputStream in = new ByteArrayInputStream(this.data.getBytes(StandardCharsets.UTF_8));
        try {
            return (T)ClientSerialisers.invokeClientReader(null, type.getRawType(), type.getType(), mediaType, null, null, Serialisers.EMPTY_MULTI_MAP, this.serialisers, in, Serialisers.NO_READER_INTERCEPTOR, this.configuration);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return "InboundSseEvent[data: " + this.data + ", name: " + this.name + ", id: " + this.id + ", comment: " + this.comment + ", mediaType: " + this.mediaType + ", reconnectDelay: " + this.reconnectDelay + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.mediaType, this.comment, this.data, this.id, this.name);
        result = 31 * result + (int)(this.reconnectDelay ^ this.reconnectDelay >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundSseEventImpl)) {
            return false;
        }
        InboundSseEventImpl other = (InboundSseEventImpl)obj;
        return Objects.equals(this.getComment(), other.getComment()) && Objects.equals(this.getMediaType(), other.getMediaType()) && Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getName(), other.getName()) && this.getReconnectDelay() == other.getReconnectDelay() && Objects.equals(this.readData(), other.readData());
    }
}

