/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import java.util.Objects;
import javax.ws.rs.core.Response;

public class StatusTypeImpl
implements Response.StatusType {
    public static final String DEFAULT_REASON_PHRASE = "Unknown code";
    private final String reasonPhrase;
    private final int status;

    public StatusTypeImpl(int status, String reasonPhrase) {
        this.status = status;
        this.reasonPhrase = reasonPhrase != null ? reasonPhrase : StatusTypeImpl.getDefaultReasonPhrase(status);
    }

    private static String getDefaultReasonPhrase(int providedStatus) {
        for (Response.Status defaultStatus : Response.Status.values()) {
            if (providedStatus != defaultStatus.getStatusCode()) continue;
            return defaultStatus.getReasonPhrase() != null ? defaultStatus.getReasonPhrase() : DEFAULT_REASON_PHRASE;
        }
        return DEFAULT_REASON_PHRASE;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Response.Status.Family getFamily() {
        return Response.Status.Family.familyOf((int)this.status);
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Response.StatusType)) {
            return false;
        }
        return this.status == ((Response.StatusType)other).getStatusCode() && this.reasonPhrase.equals(((Response.StatusType)other).getReasonPhrase());
    }

    public int hashCode() {
        return Objects.hashCode(this.status) + 37 * this.reasonPhrase.hashCode();
    }

    public static StatusTypeImpl valueOf(Response.StatusType statusType) {
        if (statusType instanceof StatusTypeImpl) {
            return (StatusTypeImpl)statusType;
        }
        return new StatusTypeImpl(statusType.getStatusCode(), statusType.getReasonPhrase());
    }
}

