/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.AbstractRestResponseBuilder;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public abstract class AbstractResponseBuilder
extends Response.ResponseBuilder {
    protected int status = -1;
    protected String reasonPhrase;
    protected Object entity;
    protected MultivaluedTreeMap<String, Object> metadata = new CaseInsensitiveMap<Object>();
    protected Annotation[] entityAnnotations;

    public static SimpleDateFormat getDateFormatRFC822() {
        SimpleDateFormat dateFormatRFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormatRFC822.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormatRFC822;
    }

    public static String createVaryHeader(List<Variant> variants) {
        boolean accept = false;
        boolean acceptLanguage = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        Object vary = null;
        if (accept) {
            vary = "Accept";
        }
        if (acceptLanguage) {
            vary = vary == null ? "Accept-Language" : (String)vary + ", Accept-Language";
        }
        if (acceptEncoding) {
            vary = vary == null ? "Accept-Encoding" : (String)vary + ", Accept-Encoding";
        }
        return vary;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public ResponseImpl build() {
        return this.populateResponse(new ResponseImpl());
    }

    public ResponseImpl build(boolean copyHeaders) {
        return this.populateResponse(new ResponseImpl(), copyHeaders);
    }

    public <T extends ResponseImpl> T populateResponse(T response) {
        return this.populateResponse(response, true);
    }

    public <T extends ResponseImpl> T populateResponse(T response, boolean copyHeaders) {
        response.entity = this.entity;
        response.status = this.entity == null && this.status == -1 ? 204 : (this.status == -1 ? 200 : this.status);
        response.reasonPhrase = this.reasonPhrase;
        if (copyHeaders) {
            response.headers = new CaseInsensitiveMap<Object>();
            response.headers.putAll((Map<String, List<Object>>)((Object)this.metadata));
        } else {
            response.headers = this.metadata;
        }
        response.entityAnnotations = this.entityAnnotations;
        return response;
    }

    public void setAllHeaders(MultivaluedMap<String, String> values) {
        for (Map.Entry i : values.entrySet()) {
            for (String v : (List)i.getValue()) {
                this.metadata.add((String)i.getKey(), v);
            }
        }
    }

    protected abstract AbstractResponseBuilder doClone();

    public AbstractResponseBuilder clone() {
        AbstractResponseBuilder responseBuilder = this.doClone();
        responseBuilder.status = this.status;
        responseBuilder.reasonPhrase = this.reasonPhrase;
        responseBuilder.entity = this.entity;
        responseBuilder.metadata = new CaseInsensitiveMap<Object>();
        responseBuilder.metadata.putAll((Map<String, List<Object>>)((Object)this.metadata));
        return responseBuilder;
    }

    public Response.ResponseBuilder status(int status, String reasonPhrase) {
        this.status = status;
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public Response.ResponseBuilder status(int status) {
        return this.status(status, AbstractRestResponseBuilder.defaultReasonPhrases.get(status));
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        this.entity = entity;
        this.entityAnnotations = annotations;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", type);
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", type);
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.type((String)null);
            this.language((String)null);
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", variant.getEncoding());
        } else {
            this.metadata.remove("Content-Encoding");
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        if (variants == null) {
            this.metadata.remove("Vary");
            return this;
        }
        String vary = AbstractResponseBuilder.createVaryHeader(variants);
        this.metadata.putSingle("Vary", vary);
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", language);
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        this.metadata.putSingle("ETag", tag);
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        return this.tag(new EntityTag(tag));
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        if (lastModified == null) {
            this.metadata.remove("Last-Modified");
            return this;
        }
        this.metadata.putSingle("Last-Modified", lastModified);
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        if (cacheControl == null) {
            this.metadata.remove("Cache-Control");
            return this;
        }
        this.metadata.putSingle("Cache-Control", cacheControl);
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        if (value == null) {
            this.metadata.remove(name);
            return this;
        }
        this.metadata.add(name, value);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies == null) {
            this.metadata.remove("Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            this.metadata.add("Set-Cookie", cookie);
        }
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", language);
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        if (expires == null) {
            this.metadata.remove("Expires");
            return this;
        }
        this.metadata.putSingle("Expires", AbstractResponseBuilder.getDateFormatRFC822().format(expires));
        return this;
    }

    public Response.ResponseBuilder allow(String ... methods) {
        if (methods == null) {
            return this.allow((Set<String>)null);
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(methods));
        return this.allow(set);
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        HeaderUtil.setAllow(this.metadata, methods);
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        if (encoding == null) {
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.metadata.putSingle("Content-Encoding", encoding);
        return this;
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        return this.variants(Arrays.asList(variants));
    }

    public Response.ResponseBuilder links(Link ... links) {
        if (links == null) {
            this.metadata.remove("Link");
            return this;
        }
        for (Link link : links) {
            this.metadata.add("Link", link);
        }
        return this;
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        Link link = Link.fromUri((URI)uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", link);
        return this;
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        Link link = Link.fromUri((String)uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", link);
        return this;
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        this.metadata.clear();
        if (headers == null) {
            return this;
        }
        this.metadata.putAll((Map<String, List<Object>>)headers);
        return this;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }
}

