/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.model;

import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.core.LazyUnmanagedBeanFactory;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResourceClass {
    private String className;
    private String path;
    private final List<ResourceMethod> methods = new ArrayList<ResourceMethod>();
    private BeanFactory<Object> factory;
    private boolean perRequestResource;
    private boolean isFormParamRequired;
    private Set<String> pathParameters = new HashSet<String>();
    private Map<String, String> classLevelExceptionMappers = new HashMap<String, String>();

    public boolean isSubResource() {
        return this.path == null;
    }

    public String getClassName() {
        return this.className;
    }

    public ResourceClass setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public BeanFactory<Object> getFactory() {
        return this.factory;
    }

    public ResourceClass setFactory(BeanFactory<Object> factory) {
        this.factory = factory;
        return this;
    }

    public ResourceClass setPath(String path) {
        this.path = path;
        if (path != null) {
            this.pathParameters.clear();
            URLUtils.parsePathParameters(path, this.pathParameters);
        }
        return this;
    }

    public List<ResourceMethod> getMethods() {
        return this.methods;
    }

    public boolean isPerRequestResource() {
        return this.perRequestResource;
    }

    public void setPerRequestResource(boolean perRequestResource) {
        this.perRequestResource = perRequestResource;
    }

    public boolean isFormParamRequired() {
        return this.isFormParamRequired;
    }

    public ResourceClass setFormParamRequired(boolean isFormParamRequired) {
        this.isFormParamRequired = isFormParamRequired;
        return this;
    }

    public Set<String> getPathParameters() {
        return this.pathParameters;
    }

    public ResourceClass setPathParameters(Set<String> pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public Map<String, String> getClassLevelExceptionMappers() {
        return this.classLevelExceptionMappers;
    }

    public void setClassLevelExceptionMappers(Map<String, String> classLevelExceptionMappers) {
        this.classLevelExceptionMappers = classLevelExceptionMappers;
    }

    public Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> resourceExceptionMapper() {
        if (this.classLevelExceptionMappers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> result = new HashMap<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>>(this.classLevelExceptionMappers.size());
        for (final Map.Entry<String, String> entry : this.classLevelExceptionMappers.entrySet()) {
            ResourceExceptionMapper mapper = new ResourceExceptionMapper();
            mapper.setFactory(new LazyUnmanagedBeanFactory(new Supplier<ExceptionMapper<?>>(){

                @Override
                public ExceptionMapper<?> get() {
                    try {
                        return (ExceptionMapper)ResourceClass.loadClass((String)entry.getValue()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
            result.put(ResourceClass.loadClass(entry.getKey()), mapper);
        }
        return result;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

