/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.functions.Supplier;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapScheduler<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final int bufferSize;
    final ErrorMode delayErrors;
    final Scheduler scheduler;

    public ObservableConcatMapScheduler(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, ErrorMode delayErrors, Scheduler scheduler) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.bufferSize = Math.max(8, bufferSize);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super U> observer) {
        if (this.delayErrors == ErrorMode.IMMEDIATE) {
            SerializedObserver<? super U> serial = new SerializedObserver<U>(observer);
            this.source.subscribe(new ConcatMapObserver<T, U>(serial, this.mapper, this.bufferSize, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new ConcatMapDelayErrorObserver<T, U>(observer, this.mapper, this.bufferSize, this.delayErrors == ErrorMode.END, this.scheduler.createWorker()));
        }
    }

    static final class ConcatMapDelayErrorObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -6951100001833242599L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final AtomicThrowable error;
        final DelayErrorInnerObserver<R> observer;
        final boolean tillTheEnd;
        final Scheduler.Worker worker;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;
        int sourceMode;

        ConcatMapDelayErrorObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean tillTheEnd, Scheduler.Worker worker) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.tillTheEnd = tillTheEnd;
            this.error = new AtomicThrowable();
            this.observer = new DelayErrorInnerObserver<R>(actual, this);
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m = qd.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.observer.dispose();
            this.worker.dispose();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public void run() {
            Observer<R> actual = this.downstream;
            SimpleQueue<T> queue = this.queue;
            AtomicThrowable error = this.error;
            while (true) {
                if (!this.active) {
                    boolean empty;
                    T v;
                    Throwable ex;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    if (!this.tillTheEnd && (ex = (Throwable)error.get()) != null) {
                        queue.clear();
                        this.cancelled = true;
                        actual.onError(error.terminate());
                        this.worker.dispose();
                        return;
                    }
                    boolean d = this.done;
                    try {
                        v = queue.poll();
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        this.cancelled = true;
                        this.upstream.dispose();
                        error.addThrowable(ex2);
                        actual.onError(error.terminate());
                        this.worker.dispose();
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        this.cancelled = true;
                        Throwable ex3 = error.terminate();
                        if (ex3 != null) {
                            actual.onError(ex3);
                        } else {
                            actual.onComplete();
                        }
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        ObservableSource<R> o;
                        try {
                            o = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.cancelled = true;
                            this.upstream.dispose();
                            queue.clear();
                            error.addThrowable(ex4);
                            actual.onError(error.terminate());
                            this.worker.dispose();
                            return;
                        }
                        if (o instanceof Supplier) {
                            Object w;
                            try {
                                w = ((Supplier)((Object)o)).get();
                            }
                            catch (Throwable ex5) {
                                Exceptions.throwIfFatal(ex5);
                                error.addThrowable(ex5);
                                continue;
                            }
                            if (w == null || this.cancelled) continue;
                            actual.onNext(w);
                            continue;
                        }
                        this.active = true;
                        o.subscribe(this.observer);
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }

        static final class DelayErrorInnerObserver<R>
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = 2620149119579502636L;
            final Observer<? super R> downstream;
            final ConcatMapDelayErrorObserver<?, R> parent;

            DelayErrorInnerObserver(Observer<? super R> actual, ConcatMapDelayErrorObserver<?, R> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onNext(R value) {
                this.downstream.onNext(value);
            }

            @Override
            public void onError(Throwable e) {
                ConcatMapDelayErrorObserver<?, R> p = this.parent;
                if (p.error.addThrowable(e)) {
                    if (!p.tillTheEnd) {
                        p.upstream.dispose();
                    }
                    p.active = false;
                    p.drain();
                } else {
                    RxJavaPlugins.onError(e);
                }
            }

            @Override
            public void onComplete() {
                ConcatMapDelayErrorObserver<?, R> p = this.parent;
                p.active = false;
                p.drain();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }

    static final class ConcatMapObserver<T, U>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 8828587559905699186L;
        final Observer<? super U> downstream;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final InnerObserver<U> inner;
        final int bufferSize;
        final Scheduler.Worker worker;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean active;
        volatile boolean disposed;
        volatile boolean done;
        int fusionMode;

        ConcatMapObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, Scheduler.Worker worker) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.inner = new InnerObserver<U>(actual, this);
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m = qd.requestFusion(3);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0) {
                this.queue.offer(t);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.inner.dispose();
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public void run() {
            do {
                ObservableSource<U> o;
                boolean empty;
                T t;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    t = this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex);
                    this.worker.dispose();
                    return;
                }
                boolean bl = empty = t == null;
                if (d && empty) {
                    this.disposed = true;
                    this.downstream.onComplete();
                    this.worker.dispose();
                    return;
                }
                if (empty) continue;
                try {
                    o = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null ObservableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex);
                    this.worker.dispose();
                    return;
                }
                this.active = true;
                o.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class InnerObserver<U>
        extends AtomicReference<Disposable>
        implements Observer<U> {
            private static final long serialVersionUID = -7449079488798789337L;
            final Observer<? super U> downstream;
            final ConcatMapObserver<?, ?> parent;

            InnerObserver(Observer<? super U> actual, ConcatMapObserver<?, ?> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onNext(U t) {
                this.downstream.onNext(t);
            }

            @Override
            public void onError(Throwable t) {
                this.parent.dispose();
                this.downstream.onError(t);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

