/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableOnErrorNext<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;

    public ObservableOnErrorNext(ObservableSource<T> source, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier) {
        super(source);
        this.nextSupplier = nextSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        OnErrorNextObserver<? super T> parent = new OnErrorNextObserver<T>(t, this.nextSupplier);
        t.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
        final SequentialDisposable arbiter;
        boolean once;
        boolean done;

        OnErrorNextObserver(Observer<? super T> actual, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier) {
            this.downstream = actual;
            this.nextSupplier = nextSupplier;
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.arbiter.replace(d);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            ObservableSource<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.downstream.onError(t);
                return;
            }
            this.once = true;
            try {
                p = this.nextSupplier.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                return;
            }
            if (p == null) {
                NullPointerException npe = new NullPointerException("Observable is null");
                npe.initCause(t);
                this.downstream.onError(npe);
                return;
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.downstream.onComplete();
        }
    }
}

