/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapSingle<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public ObservableConcatMapSingle(Observable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        if (!ScalarXMapZHelper.tryAsSingle(this.source, this.mapper, observer)) {
            this.source.subscribe(new ConcatMapSingleMainObserver<T, R>(observer, this.mapper, this.prefetch, this.errorMode));
        }
    }

    static final class ConcatMapSingleMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -9140123220065488293L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final AtomicThrowable errors;
        final ConcatMapSingleObserver<R> inner;
        final SimplePlainQueue<T> queue;
        final ErrorMode errorMode;
        Disposable upstream;
        volatile boolean done;
        volatile boolean cancelled;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapSingleMainObserver(Observer<? super R> downstream, Function<? super T, ? extends SingleSource<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapSingleObserver(this);
            this.queue = new SpscLinkedArrayQueue(prefetch);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.inner.dispose();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.inner.dispose();
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
                this.item = null;
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.state = 0;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            SimplePlainQueue<T> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                } else {
                    int s = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s == 0) {
                        boolean empty;
                        boolean d = this.done;
                        T v = queue.poll();
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty) {
                            SingleSource<R> ss;
                            try {
                                ss = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null SingleSource");
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.upstream.dispose();
                                queue.clear();
                                errors.addThrowable(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ss.subscribe(this.inner);
                        }
                    } else if (s == 2) {
                        R w = this.item;
                        this.item = null;
                        downstream.onNext(w);
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapSingleObserver<R>
        extends AtomicReference<Disposable>
        implements SingleObserver<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapSingleMainObserver<?, R> parent;

            ConcatMapSingleObserver(ConcatMapSingleMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onSuccess(R t) {
                this.parent.innerSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

