/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableTakeLastTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public ObservableTakeLastTimed(ObservableSource<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new TakeLastTimedObserver<T>(t, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5677354903406201275L;
        final Observer<? super T> downstream;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Disposable upstream;
        volatile boolean cancelled;
        Throwable error;

        TakeLastTimedObserver(Observer<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            long ts;
            SpscLinkedArrayQueue<Object> q = this.queue;
            long now = this.scheduler.now(this.unit);
            long time = this.time;
            long c = this.count;
            boolean unbounded = c == Long.MAX_VALUE;
            q.offer(now, t);
            while (!q.isEmpty() && ((ts = ((Long)q.peek()).longValue()) <= now - time || !unbounded && (long)(q.size() >> 1) > c)) {
                q.poll();
                q.poll();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                if (this.compareAndSet(false, true)) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (!this.compareAndSet(false, true)) {
                return;
            }
            Observer<Object> a = this.downstream;
            SpscLinkedArrayQueue<Object> q = this.queue;
            boolean delayError = this.delayError;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                if (!delayError && (ex = this.error) != null) {
                    q.clear();
                    a.onError(ex);
                    return;
                }
                Object ts = q.poll();
                boolean bl = empty = ts == null;
                if (empty) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        a.onError(ex2);
                    } else {
                        a.onComplete();
                    }
                    return;
                }
                Object o = q.poll();
                if ((Long)ts < this.scheduler.now(this.unit) - this.time) continue;
                a.onNext(o);
            }
        }
    }
}

