/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableCollect<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Supplier<? extends U> initialSupplier;
    final BiConsumer<? super U, ? super T> collector;

    public ObservableCollect(ObservableSource<T> source, Supplier<? extends U> initialSupplier, BiConsumer<? super U, ? super T> collector) {
        super(source);
        this.initialSupplier = initialSupplier;
        this.collector = collector;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        U u;
        try {
            u = ObjectHelper.requireNonNull(this.initialSupplier.get(), "The initialSupplier returned a null value");
        }
        catch (Throwable e) {
            EmptyDisposable.error(e, t);
            return;
        }
        this.source.subscribe(new CollectObserver<T, U>(t, u, this.collector));
    }

    static final class CollectObserver<T, U>
    implements Observer<T>,
    Disposable {
        final Observer<? super U> downstream;
        final BiConsumer<? super U, ? super T> collector;
        final U u;
        Disposable upstream;
        boolean done;

        CollectObserver(Observer<? super U> actual, U u, BiConsumer<? super U, ? super T> collector) {
            this.downstream = actual;
            this.collector = collector;
            this.u = u;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                this.collector.accept(this.u, t);
            }
            catch (Throwable e) {
                this.upstream.dispose();
                this.onError(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onNext(this.u);
            this.downstream.onComplete();
        }
    }
}

