/*
 * Decompiled with CFR 0.152.
 */
package io.reformanda.semper.maven.dependencyversion;

import io.reformanda.semper.maven.dependencyversion.CreatePropertyAddPredicate;
import io.reformanda.semper.maven.dependencyversion.PropertySet;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-version", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class DependencyVersionMojo
extends AbstractMojo {
    @Parameter(alias="project", property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private PropertySet[] propertySets;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties properties;
        if (this.propertySets == null) {
            this.propertySets = new PropertySet[]{new PropertySet()};
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("propertySets: " + Arrays.toString(this.propertySets)));
        }
        if ((properties = this.project.getProperties()) == null) {
            throw new MojoExecutionException("Could not get properties for project, cannot set artifact version properties.");
        }
        for (PropertySet propertySet : this.propertySets) {
            Predicate<String> shouldAddPropertyForDependency = new CreatePropertyAddPredicate().apply(propertySet);
            boolean transitive = Optional.ofNullable(propertySet.getTransitive()).orElse(true);
            Set artifacts = transitive ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                String dependencyConflictId = artifact.getDependencyConflictId();
                if (!shouldAddPropertyForDependency.test(dependencyConflictId)) continue;
                String key = String.format("%s.%s", dependencyConflictId, Optional.ofNullable(propertySet.getSuffix()).orElse("version"));
                String version = artifact.getBaseVersion();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Setting property for %s with key=%s, version=%s", dependencyConflictId, key, version));
                }
                properties.setProperty(key, version);
            }
        }
    }
}

