/*
 * Decompiled with CFR 0.152.
 */
package io.repaint.maven.tiles;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.repaint.maven.tiles.GavUtil;
import io.repaint.maven.tiles.NotDefaultModelCache;
import io.repaint.maven.tiles.TileModel;
import io.repaint.maven.tiles.isolators.AetherIsolator;
import io.repaint.maven.tiles.isolators.BaseMavenIsolator;
import io.repaint.maven.tiles.isolators.Maven30Isolator;
import io.repaint.maven.tiles.isolators.MavenVersionIsolator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingHelper;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=AbstractMavenLifecycleParticipant.class, hint="TilesMavenLifecycleParticipant")
public class TilesMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements GroovyObject {
    protected static final String TILE_EXTENSION = "pom";
    public static final Object TILEPLUGIN_GROUP;
    public static final Object TILEPLUGIN_ARTIFACT;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactResolver resolver;
    @Requirement
    private ModelBuilder modelBuilder;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private ProjectBuildingHelper projectBuildingHelper;
    protected MavenVersionIsolator mavenVersionIsolate;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactRepository localRepository;
    private NotDefaultModelCache modelCache;
    private MavenSession mavenSession;
    private Map<String, ArtifactModel> processedTiles;
    private List<String> tileDiscoveryOrder;
    private Map<String, Artifact> unprocessedTiles;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1416214329415;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$apache$maven$project$DefaultModelBuildingListener;
    private static /* synthetic */ Class $class$org$apache$maven$model$building$ModelCacheTag;

    public TilesMavenLifecycleParticipant() {
        MetaClass metaClass;
        Map map;
        List list;
        Map map2;
        this.processedTiles = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.tileDiscoveryOrder = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.unprocessedTiles = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected void resetTiles() {
        List list;
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.processedTiles = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)map, LinkedHashMap.class);
        this.tileDiscoveryOrder = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.unprocessedTiles = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)map2, LinkedHashMap.class);
    }

    protected Artifact getArtifactFromCoordinates(String groupId, String artifactId, String version) {
        return new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "compile", "tile", "tile-pom", (ArtifactHandler)new DefaultArtifactHandler(TILE_EXTENSION));
    }

    protected Artifact resolveTile(Artifact tileArtifact) throws MavenExecutionException {
        try {
            this.mavenVersionIsolate.resolveVersionRange(tileArtifact);
            this.resolver.resolve(tileArtifact, this.remoteRepositories, this.localRepository);
            String string = System.getProperty("performRelease");
            Boolean bl = string != null ? Boolean.valueOf(StringGroovyMethods.asBoolean((CharSequence)string)) : null;
            if ((bl == null ? false : bl) && tileArtifact.getVersion().endsWith("-SNAPSHOT")) {
                throw (Throwable)new MavenExecutionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GavUtil.artifactGav(tileArtifact)}, new String[]{"Tile ", " is a SNAPSHOT and we are releasing."})), tileArtifact.getFile());
            }
        }
        catch (ArtifactResolutionException e) {
            throw (Throwable)new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw (Throwable)new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        return tileArtifact;
    }

    protected Artifact turnPropertyIntoUnprocessedTile(String artifactGav, File pomFile) throws MavenExecutionException {
        Object[] gav = (String[])ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.tokenize((String)artifactGav, (String)":"), String[].class);
        if (DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)gav, Object[].class))) != 3) {
            throw (Throwable)new MavenExecutionException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{artifactGav}, new String[]{"", " does not have the form group:artifact:version-range"})), pomFile);
        }
        String groupId = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])gav, (int)0));
        String artifactId = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])gav, (int)1));
        String version = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])gav, (int)2));
        return this.getArtifactFromCoordinates(groupId, artifactId, version);
    }

    protected TileModel loadModel(Artifact artifact) throws MavenExecutionException {
        TileModel modelLoader = new TileModel(artifact.getFile(), artifact);
        this.logger.debug(String.format("Loaded Maven Tile %s", GavUtil.artifactGav(artifact)));
        TileModel tileModel = modelLoader;
        try {
            return tileModel;
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new MavenExecutionException(String.format("Error loading %s", GavUtil.artifactGav(artifact)), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw (Throwable)new MavenExecutionException(String.format("Error building %s", GavUtil.artifactGav(artifact)), (Throwable)e);
        }
        catch (SAXParseException sax) {
            throw (Throwable)new MavenExecutionException(String.format("Error building %s", GavUtil.artifactGav(artifact)), (Throwable)sax);
        }
        catch (IOException e) {
            throw (Throwable)new MavenExecutionException(String.format("Error parsing %s", GavUtil.artifactGav(artifact)), (Throwable)e);
        }
    }

    protected MavenVersionIsolator discoverMavenVersion(MavenSession mavenSession) {
        BaseMavenIsolator isolator = null;
        try {
            AetherIsolator aetherIsolator;
            isolator = aetherIsolator = new AetherIsolator(mavenSession);
        }
        catch (MavenExecutionException mee) {
            Maven30Isolator maven30Isolator = new Maven30Isolator(mavenSession);
            isolator = maven30Isolator;
        }
        return isolator;
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        NotDefaultModelCache notDefaultModelCache;
        MavenVersionIsolator mavenVersionIsolator;
        ArtifactRepository artifactRepository;
        List list;
        MavenSession mavenSession2;
        this.mavenSession = mavenSession2 = mavenSession;
        this.remoteRepositories = list = mavenSession.getRequest().getRemoteRepositories();
        this.localRepository = artifactRepository = mavenSession.getRequest().getLocalRepository();
        this.mavenVersionIsolate = mavenVersionIsolator = this.discoverMavenVersion(mavenSession);
        this.modelCache = notDefaultModelCache = new NotDefaultModelCache(mavenSession);
        MavenProject topLevelProject = mavenSession.getTopLevelProject();
        List subModules = topLevelProject.getModules();
        if (subModules != null && subModules.size() > 0) {
            MavenProject subModule = null;
            Iterator iterator = mavenSession.getProjects().iterator();
            while (iterator.hasNext()) {
                subModule = (MavenProject)ScriptBytecodeAdapter.castToType(iterator.next(), MavenProject.class);
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)subModule, (Object)topLevelProject)) continue;
                this.resetTiles();
                this.orchestrateMerge(subModule);
            }
        } else {
            this.orchestrateMerge(topLevelProject);
        }
    }

    protected void orchestrateMerge(MavenProject project) throws MavenExecutionException {
        this.parseConfiguration(project.getModel(), project.getFile(), true);
        this.loadAllDiscoveredTiles();
        if (DefaultTypeTransformation.booleanUnbox(this.processedTiles)) {
            this.thunkModelBuilder(project);
        }
    }

    protected void thunkModelBuilder(MavenProject project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = TilesMavenLifecycleParticipant.$getCallSiteArray();
        Reference tiles = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call(this.processedTiles), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _thunkModelBuilder_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _thunkModelBuilder_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _thunkModelBuilder_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _thunkModelBuilder_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _thunkModelBuilder_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _thunkModelBuilder_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "tileModel";
                return new CallSiteArray(_thunkModelBuilder_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _thunkModelBuilder_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), List.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((List)tiles.get()))) {
            return;
        }
        ModelSource mainArtifactModelSource = (ModelSource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].callGetProperty((Object)((MavenProject)project2.get()))), ModelSource.class);
        Reference request = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[4].callConstructor(DefaultModelBuildingRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"modelSource", mainArtifactModelSource, "pomFile", callSiteArray[5].callGetProperty((Object)((MavenProject)project2.get())), "modelResolver", callSiteArray[6].callCurrent((GroovyObject)this), "modelCache", this.modelCache, "systemProperties", callSiteArray[7].call(System.class), "userProperties", callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)this.mavenSession)), "profiles", callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty((Object)this.mavenSession))), "activeProfileIds", callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty((Object)this.mavenSession))), "inactiveProfileIds", callSiteArray[16].callGetProperty(callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty((Object)this.mavenSession))), "modelBuildingListener", callSiteArray[19].callConstructor((Object)TilesMavenLifecycleParticipant.$get$$class$org$apache$maven$project$DefaultModelBuildingListener(), (Object)((MavenProject)project2.get()), (Object)this.projectBuildingHelper, callSiteArray[20].callGetProperty(callSiteArray[21].callGetProperty((Object)this.mavenSession))), "locationTracking", true, "twoPhaseBuilding", true, "processPlugins", true}));
            request.set((Object)((ModelBuildingRequest)ScriptBytecodeAdapter.castToType((Object)object, ModelBuildingRequest.class)));
        } else {
            Object object = callSiteArray[22].callConstructor(DefaultModelBuildingRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"modelSource", mainArtifactModelSource, "pomFile", callSiteArray[23].callGetProperty((Object)((MavenProject)project2.get())), "modelResolver", this.createModelResolver(), "modelCache", this.modelCache, "systemProperties", callSiteArray[24].call(System.class), "userProperties", callSiteArray[25].callGetProperty(callSiteArray[26].callGetProperty((Object)this.mavenSession)), "profiles", callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty((Object)this.mavenSession))), "activeProfileIds", callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty((Object)this.mavenSession))), "inactiveProfileIds", callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(callSiteArray[35].callGetProperty((Object)this.mavenSession))), "modelBuildingListener", callSiteArray[36].callConstructor((Object)TilesMavenLifecycleParticipant.$get$$class$org$apache$maven$project$DefaultModelBuildingListener(), (Object)((MavenProject)project2.get()), (Object)this.projectBuildingHelper, callSiteArray[37].callGetProperty(callSiteArray[38].callGetProperty((Object)this.mavenSession))), "locationTracking", true, "twoPhaseBuilding", true, "processPlugins", true}));
            request.set((Object)((ModelBuildingRequest)ScriptBytecodeAdapter.castToType((Object)object, ModelBuildingRequest.class)));
        }
        ModelProcessor delegateModelProcessor = new ModelProcessor(this, project2, tiles, request){
            public /* synthetic */ Reference request;
            public /* synthetic */ Reference tiles;
            public /* synthetic */ Reference project;
            public /* synthetic */ TilesMavenLifecycleParticipant this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                TilesMavenLifecycleParticipant tilesMavenLifecycleParticipant;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = tilesMavenLifecycleParticipant = p0;
                this.request = reference3 = p3;
                this.tiles = reference2 = p2;
                this.project = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public File locatePom(File projectDirectory) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)projectDirectory), File.class);
            }

            public Model read(File input, Map<String, ?> options) throws IOException, ModelParseException {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (Model)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)input, options), Model.class);
            }

            public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (Model)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)input, options), Model.class);
            }

            public Model read(InputStream input, Map<String, ?> options) throws IOException, ModelParseException {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Model model = (Model)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)input, options), Model.class);
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty((Object)model), (Object)callSiteArray[9].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].callGetProperty((Object)model), (Object)callSiteArray[11].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetProperty((Object)model), (Object)callSiteArray[13].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[14].callGetProperty((Object)model), (Object)callSiteArray[15].callGetProperty(this.project.get()))) {
                        callSiteArray[16].callCurrent((GroovyObject)this, this.tiles.get(), (Object)model, this.request.get());
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[17].callGetProperty((Object)model), (Object)callSiteArray[18].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty((Object)model), (Object)callSiteArray[20].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[21].callGetProperty((Object)model), (Object)callSiteArray[22].callGetProperty(this.project.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[23].callGetProperty((Object)model), (Object)callSiteArray[24].callGetProperty(this.project.get()))) {
                    callSiteArray[25].callCurrent((GroovyObject)this, this.tiles.get(), (Object)model, this.request.get());
                }
                return model;
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$2(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$2(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                1.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "locatePom";
                stringArray[1] = "modelProcessor";
                stringArray[2] = "read";
                stringArray[3] = "modelProcessor";
                stringArray[4] = "read";
                stringArray[5] = "modelProcessor";
                stringArray[6] = "read";
                stringArray[7] = "modelProcessor";
                stringArray[8] = "artifactId";
                stringArray[9] = "artifactId";
                stringArray[10] = "groupId";
                stringArray[11] = "groupId";
                stringArray[12] = "version";
                stringArray[13] = "version";
                stringArray[14] = "packaging";
                stringArray[15] = "packaging";
                stringArray[16] = "injectTilesIntoParentStructure";
                stringArray[17] = "artifactId";
                stringArray[18] = "artifactId";
                stringArray[19] = "groupId";
                stringArray[20] = "groupId";
                stringArray[21] = "version";
                stringArray[22] = "version";
                stringArray[23] = "packaging";
                stringArray[24] = "packaging";
                stringArray[25] = "injectTilesIntoParentStructure";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[26];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        callSiteArray[39].call((Object)((DefaultModelBuilder)ScriptBytecodeAdapter.castToType((Object)this.modelBuilder, DefaultModelBuilder.class)), (Object)delegateModelProcessor);
        ModelBuildingResult interimBuild = (ModelBuildingResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call((Object)this.modelBuilder, (Object)((ModelBuildingRequest)request.get())), ModelBuildingResult.class);
        ModelBuildingResult finalModel = (ModelBuildingResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call((Object)this.modelBuilder, (Object)((ModelBuildingRequest)request.get()), (Object)interimBuild), ModelBuildingResult.class);
        callSiteArray[42].callCurrent((GroovyObject)this, callSiteArray[43].callGetProperty((Object)((MavenProject)project2.get())), callSiteArray[44].callGetProperty((Object)finalModel));
    }

    public ModelSource createModelSource(File pomFile) {
        Reference pomFile2 = new Reference((Object)pomFile);
        return new ModelSource(this, pomFile2){
            public /* synthetic */ Reference pomFile;
            private InputStream stream;
            public /* synthetic */ TilesMavenLifecycleParticipant this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                TilesMavenLifecycleParticipant tilesMavenLifecycleParticipant;
                this.this$0 = tilesMavenLifecycleParticipant = p0;
                this.pomFile = reference = p1;
                BufferedInputStream bufferedInputStream = ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)this.pomFile.get(), File.class)));
                this.stream = bufferedInputStream;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public InputStream getInputStream() throws IOException {
                return this.stream;
            }

            public String getLocation() {
                return ((File)this.pomFile.get()).getAbsolutePath();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                2.__$swapInit();
            }

            public InputStream getStream() {
                return this.stream;
            }

            public void setStream(InputStream inputStream) {
                this.stream = inputStream;
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
    }

    protected ModelResolver createModelResolver() {
        return new ModelResolver(this){
            public /* synthetic */ TilesMavenLifecycleParticipant this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                TilesMavenLifecycleParticipant tilesMavenLifecycleParticipant;
                this.this$0 = tilesMavenLifecycleParticipant = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
                DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "compile", TilesMavenLifecycleParticipant.TILE_EXTENSION, null, (ArtifactHandler)new DefaultArtifactHandler(TilesMavenLifecycleParticipant.TILE_EXTENSION));
                ((MavenVersionIsolator)this.getProperty("mavenVersionIsolate")).resolveVersionRange((Artifact)artifact);
                this.this$0.getResolver().resolve((Artifact)artifact, this.this$0.getRemoteRepositories(), this.this$0.getLocalRepository());
                return this.this$0.createModelSource(artifact.getFile());
            }

            public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
                return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }

            public void addRepository(Repository repository) throws InvalidRepositoryException {
            }

            public void addRepository(Repository repository, boolean wat) throws InvalidRepositoryException {
            }

            public void resetRepositories() {
            }

            public ModelResolver newCopy() {
                return (ModelResolver)ScriptBytecodeAdapter.castToType(null, ModelResolver.class);
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                3.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
    }

    protected void putModelInCache(Model model, ModelBuildingRequest request, File pomFile) {
        CallSite[] callSiteArray = TilesMavenLifecycleParticipant.$getCallSiteArray();
        callSiteArray[45].call((Object)this.modelBuilder, ArrayUtil.createArray((Object)callSiteArray[46].callGetProperty((Object)request), (Object)callSiteArray[47].callGetProperty((Object)model), (Object)callSiteArray[48].callGetProperty((Object)model), (Object)callSiteArray[49].callGetProperty((Object)model), (Object)callSiteArray[50].callGetProperty((Object)TilesMavenLifecycleParticipant.$get$$class$org$apache$maven$model$building$ModelCacheTag()), (Object)callSiteArray[51].call((Object)this.mavenVersionIsolate, (Object)model, (Object)pomFile)));
    }

    /*
     * WARNING - void declaration
     */
    public void injectTilesIntoParentStructure(List<TileModel> tiles, Model pomModel, ModelBuildingRequest request) {
        void var3_3;
        Reference pomModel2 = new Reference((Object)pomModel);
        Reference request2 = new Reference((Object)var3_3);
        Parent originalParent = ((Model)pomModel2.get()).getParent();
        Reference lastPom = new Reference((Object)((Model)pomModel2.get()));
        Reference lastPomFile = new Reference((Object)((ModelBuildingRequest)request2.get()).getPomFile());
        if (DefaultTypeTransformation.booleanUnbox(tiles)) {
            this.logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{tiles.size()}, new String[]{"--- tiles-maven-plugin: Injecting ", " tiles as intermediary parent artifact's..."})));
            this.logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GavUtil.modelGav((Model)pomModel2.get()), GavUtil.modelGav(((TileModel)DefaultGroovyMethods.first(tiles)).getModel())}, new String[]{"Mixed '", "' with tile '", "' as it's new parent."})));
        }
        DefaultGroovyMethods.each(tiles, (Closure)new GeneratedClosure((Object)this, (Object)this, lastPom, lastPomFile, request2, pomModel2){
            private /* synthetic */ Reference lastPom;
            private /* synthetic */ Reference lastPomFile;
            private /* synthetic */ Reference request;
            private /* synthetic */ Reference pomModel;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.lastPom = reference4 = lastPom;
                this.lastPomFile = reference3 = lastPomFile;
                this.request = reference2 = request;
                this.pomModel = reference = pomModel;
            }

            public Object doCall(TileModel tileModel) {
                Model model = tileModel.getModel();
                Parent parent = new Parent();
                parent.setGroupId(model.getGroupId());
                parent.setVersion(model.getVersion());
                parent.setArtifactId(model.getArtifactId());
                Parent modelParent = parent;
                ((Model)this.lastPom.get()).setParent(modelParent);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.pomModel.get(), (Object)this.lastPom.get())) {
                    InvokerHelper.invokeMethodSafe((Object)this.getThisObject(), (String)"putModelInCache", (Object)new Object[]{this.lastPom.get(), this.request.get(), this.lastPomFile.get()});
                    ((Logger)this.getProperty("logger")).info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GavUtil.modelGav((Model)ScriptBytecodeAdapter.castToType((Object)this.lastPom.get(), Model.class)), GavUtil.parentGav(modelParent)}, new String[]{"Mixed '", "' with tile '", "' as it's new parent."})));
                }
                Model model2 = model;
                this.lastPom.set((Object)model2);
                File file = tileModel.getTilePom();
                this.lastPomFile.set((Object)file);
                return file;
            }

            public Object call(TileModel tileModel) {
                return this.doCall(tileModel);
            }

            public Model getLastPom() {
                return (Model)ScriptBytecodeAdapter.castToType((Object)this.lastPom.get(), Model.class);
            }

            public File getLastPomFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.lastPomFile.get(), File.class);
            }

            public ModelBuildingRequest getRequest() {
                return (ModelBuildingRequest)ScriptBytecodeAdapter.castToType((Object)this.request.get(), ModelBuildingRequest.class);
            }

            public Model getPomModel() {
                return (Model)ScriptBytecodeAdapter.castToType((Object)this.pomModel.get(), Model.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _injectTilesIntoParentStructure_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _injectTilesIntoParentStructure_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_injectTilesIntoParentStructure_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _injectTilesIntoParentStructure_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        ((Model)lastPom.get()).setParent(originalParent);
        this.logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GavUtil.modelGav((Model)lastPom.get()), GavUtil.parentGav(originalParent)}, new String[]{"Mixed '", "' with original parent '", "' as it's  new top level parent."})));
        this.logger.info("");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Model)pomModel2.get()), (Object)((Model)lastPom.get()))) {
            this.putModelInCache((Model)lastPom.get(), (ModelBuildingRequest)request2.get(), (File)lastPomFile.get());
        }
    }

    protected void copyModel(Model projectModel, Model newModel) {
        projectModel.setBuild(newModel.getBuild());
        projectModel.setDependencyManagement(newModel.getDependencyManagement());
        projectModel.setDependencies(newModel.getDependencies());
        projectModel.setPluginRepositories(newModel.getPluginRepositories());
        projectModel.setLicenses(newModel.getLicenses());
        projectModel.setScm(newModel.getScm());
        projectModel.setDistributionManagement(newModel.getDistributionManagement());
        projectModel.setDevelopers(newModel.getDevelopers());
        projectModel.setContributors(newModel.getContributors());
        projectModel.setOrganization(newModel.getOrganization());
        projectModel.setMailingLists(newModel.getMailingLists());
        projectModel.setIssueManagement(newModel.getIssueManagement());
        projectModel.setCiManagement(newModel.getCiManagement());
        projectModel.setProfiles(newModel.getProfiles());
        projectModel.setPrerequisites(newModel.getPrerequisites());
        projectModel.setProperties(newModel.getProperties());
    }

    protected void loadAllDiscoveredTiles() throws MavenExecutionException {
        while (this.unprocessedTiles.size() > 0) {
            String unresolvedTile = ShortTypeHandling.castToString((Object)this.unprocessedTiles.keySet().iterator().next());
            Artifact resolvedTile = this.resolveTile((Artifact)ScriptBytecodeAdapter.castToType((Object)this.unprocessedTiles.remove(unresolvedTile), Artifact.class));
            TileModel tileModel = this.loadModel(resolvedTile);
            if (!DefaultTypeTransformation.booleanUnbox((Object)tileModel)) continue;
            this.processedTiles.put(GavUtil.artifactName(resolvedTile), new ArtifactModel(this, resolvedTile, tileModel));
            this.parseForExtendedSyntax(tileModel, resolvedTile.getFile());
        }
        this.ensureAllTilesDiscoveredAreAccountedFor();
    }

    public void ensureAllTilesDiscoveredAreAccountedFor() {
        Reference missingTiles = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        DefaultGroovyMethods.each(this.tileDiscoveryOrder, (Closure)new GeneratedClosure((Object)this, (Object)this, missingTiles){
            private /* synthetic */ Reference missingTiles;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.missingTiles = reference = missingTiles;
            }

            public Object doCall(String tile) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.getProperty("processedTiles"), Map.class)), (Object)tile))) {
                    return ((List)this.missingTiles.get()).add(tile);
                }
                return null;
            }

            public Object call(String tile) {
                return this.doCall(tile);
            }

            public List getMissingTiles() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.missingTiles.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _ensureAllTilesDiscoveredAreAccountedFor_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _ensureAllTilesDiscoveredAreAccountedFor_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_ensureAllTilesDiscoveredAreAccountedFor_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _ensureAllTilesDiscoveredAreAccountedFor_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.tileDiscoveryOrder.removeAll((List)missingTiles.get());
    }

    /*
     * WARNING - void declaration
     */
    protected void parseConfiguration(Model model, File pomFile, boolean projectModel) {
        void var2_2;
        Reference model2 = new Reference((Object)model);
        Reference pomFile2 = new Reference((Object)var2_2);
        Model model3 = (Model)model2.get();
        Build build = model3 != null ? model3.getBuild() : null;
        List list = build != null ? build.getPlugins() : null;
        Object object = list != null ? DefaultGroovyMethods.find((Collection)list, (Closure)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Plugin plugin) {
                return ScriptBytecodeAdapter.compareEqual((Object)plugin.getGroupId(), (Object)TILEPLUGIN_GROUP) && ScriptBytecodeAdapter.compareEqual((Object)plugin.getArtifactId(), (Object)TILEPLUGIN_ARTIFACT);
            }

            public Object call(Plugin plugin) {
                return this.doCall(plugin);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseConfiguration_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _parseConfiguration_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_parseConfiguration_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseConfiguration_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
        Xpp3Dom configuration = (Xpp3Dom)ScriptBytecodeAdapter.asType((Object)(object != null ? ((ConfigurationContainer)object).getConfiguration() : null), Xpp3Dom.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)configuration)) {
            Xpp3Dom xpp3Dom = configuration.getChild("tiles");
            Xpp3Dom[] xpp3DomArray = xpp3Dom != null ? xpp3Dom.getChildren() : null;
            Object object2 = xpp3DomArray != null ? DefaultGroovyMethods.each((Object)xpp3DomArray, (Closure)new GeneratedClosure((Object)this, (Object)this, model2, pomFile2){
                private /* synthetic */ Reference model;
                private /* synthetic */ Reference pomFile;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    this.model = reference2 = model;
                    this.pomFile = reference = pomFile;
                }

                public Object doCall(Xpp3Dom tile) {
                    return InvokerHelper.invokeMethodSafe((Object)this.getThisObject(), (String)"processConfigurationTile", (Object)new Object[]{this.model.get(), tile.getValue(), this.pomFile.get()});
                }

                public Object call(Xpp3Dom tile) {
                    return this.doCall(tile);
                }

                public Model getModel() {
                    return (Model)ScriptBytecodeAdapter.castToType((Object)this.model.get(), Model.class);
                }

                public File getPomFile() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.pomFile.get(), File.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parseConfiguration_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _parseConfiguration_closure5.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_parseConfiguration_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _parseConfiguration_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }) : null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parseForExtendedSyntax(TileModel model, File pomFile) {
        void var2_2;
        Reference model2 = new Reference((Object)model);
        Reference pomFile2 = new Reference((Object)var2_2);
        DefaultGroovyMethods.each(((TileModel)model2.get()).getTiles(), (Closure)new GeneratedClosure((Object)this, (Object)this, model2, pomFile2){
            private /* synthetic */ Reference model;
            private /* synthetic */ Reference pomFile;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                this.model = reference2 = model;
                this.pomFile = reference = pomFile;
            }

            public Object doCall(String tileGav) {
                return InvokerHelper.invokeMethodSafe((Object)this.getThisObject(), (String)"processConfigurationTile", (Object)new Object[]{((TileModel)this.model.get()).getModel(), tileGav, this.pomFile.get()});
            }

            public Object call(String tileGav) {
                return this.doCall(tileGav);
            }

            public TileModel getModel() {
                return (TileModel)ScriptBytecodeAdapter.castToType((Object)this.model.get(), TileModel.class);
            }

            public File getPomFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.pomFile.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseForExtendedSyntax_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _parseForExtendedSyntax_closure6.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_parseForExtendedSyntax_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseForExtendedSyntax_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.parseConfiguration(((TileModel)model2.get()).getModel(), (File)pomFile2.get(), false);
    }

    protected void processConfigurationTile(Model model, String tileDependencyName, File pomFile) {
        Artifact unprocessedTile = this.turnPropertyIntoUnprocessedTile(tileDependencyName, pomFile);
        String depName = GavUtil.artifactName(unprocessedTile);
        if (!this.processedTiles.containsKey(depName)) {
            if (this.unprocessedTiles.containsKey(depName)) {
                this.logger.warn(String.format("tiles-maven-plugin in project %s requested for same tile dependency %s", GavUtil.modelGav(model), GavUtil.artifactGav(unprocessedTile)));
            } else {
                this.logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GavUtil.artifactGav(unprocessedTile)}, new String[]{"Adding tile ", ""})));
                this.unprocessedTiles.put(depName, unprocessedTile);
                this.tileDiscoveryOrder.add(depName);
            }
        } else {
            this.logger.warn(String.format("tiles-maven-plugin in project %s requested for same tile dependency %s", GavUtil.modelGav(model), GavUtil.artifactGav(unprocessedTile)));
        }
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TilesMavenLifecycleParticipant.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, TilesMavenLifecycleParticipant.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(TilesMavenLifecycleParticipant.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Logger pfaccess$0(TilesMavenLifecycleParticipant $that) {
        return $that.getLogger();
    }

    public static /* synthetic */ ArtifactResolver pfaccess$1(TilesMavenLifecycleParticipant $that) {
        return $that.getResolver();
    }

    public static /* synthetic */ List<ArtifactRepository> pfaccess$2(TilesMavenLifecycleParticipant $that) {
        return $that.getRemoteRepositories();
    }

    public static /* synthetic */ ArtifactRepository pfaccess$3(TilesMavenLifecycleParticipant $that) {
        return $that.getLocalRepository();
    }

    public static /* synthetic */ Map<String, ArtifactModel> pfaccess$4(TilesMavenLifecycleParticipant $that) {
        return $that.getProcessedTiles();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != TilesMavenLifecycleParticipant.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        TilesMavenLifecycleParticipant.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1416214329415 = l;
        Long l2 = 1416214329415L;
        __timeStamp = l2;
        String string = "tiles-maven-plugin";
        TILEPLUGIN_ARTIFACT = string;
        String string2 = "io.repaint.maven";
        TILEPLUGIN_GROUP = string2;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver artifactResolver) {
        this.resolver = artifactResolver;
    }

    public ModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public void setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    public ModelProcessor getModelProcessor() {
        return this.modelProcessor;
    }

    public void setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
    }

    public ProjectBuildingHelper getProjectBuildingHelper() {
        return this.projectBuildingHelper;
    }

    public void setProjectBuildingHelper(ProjectBuildingHelper projectBuildingHelper) {
        this.projectBuildingHelper = projectBuildingHelper;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<ArtifactRepository> list) {
        this.remoteRepositories = list;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository artifactRepository) {
        this.localRepository = artifactRepository;
    }

    public NotDefaultModelCache getModelCache() {
        return this.modelCache;
    }

    public void setModelCache(NotDefaultModelCache notDefaultModelCache) {
        this.modelCache = notDefaultModelCache;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public Map<String, ArtifactModel> getProcessedTiles() {
        return this.processedTiles;
    }

    public void setProcessedTiles(Map<String, ArtifactModel> map) {
        this.processedTiles = map;
    }

    public List<String> getTileDiscoveryOrder() {
        return this.tileDiscoveryOrder;
    }

    public void setTileDiscoveryOrder(List<String> list) {
        this.tileDiscoveryOrder = list;
    }

    public Map<String, Artifact> getUnprocessedTiles() {
        return this.unprocessedTiles;
    }

    public void setUnprocessedTiles(Map<String, Artifact> map) {
        this.unprocessedTiles = map;
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$2$afterProjectsRead(MavenSession mavenSession) {
        super.afterProjectsRead(mavenSession);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$2$afterSessionEnd(MavenSession mavenSession) {
        super.afterSessionEnd(mavenSession);
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ void super$2$afterSessionStart(MavenSession mavenSession) {
        super.afterSessionStart(mavenSession);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "collect";
        stringArray[1] = "values";
        stringArray[2] = "createModelSource";
        stringArray[3] = "file";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "file";
        stringArray[6] = "createModelResolver";
        stringArray[7] = "getProperties";
        stringArray[8] = "userProperties";
        stringArray[9] = "request";
        stringArray[10] = "profiles";
        stringArray[11] = "projectBuildingRequest";
        stringArray[12] = "request";
        stringArray[13] = "activeProfileIds";
        stringArray[14] = "projectBuildingRequest";
        stringArray[15] = "request";
        stringArray[16] = "inactiveProfileIds";
        stringArray[17] = "projectBuildingRequest";
        stringArray[18] = "request";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "projectBuildingRequest";
        stringArray[21] = "request";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "file";
        stringArray[24] = "getProperties";
        stringArray[25] = "userProperties";
        stringArray[26] = "request";
        stringArray[27] = "profiles";
        stringArray[28] = "projectBuildingRequest";
        stringArray[29] = "request";
        stringArray[30] = "activeProfileIds";
        stringArray[31] = "projectBuildingRequest";
        stringArray[32] = "request";
        stringArray[33] = "inactiveProfileIds";
        stringArray[34] = "projectBuildingRequest";
        stringArray[35] = "request";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "projectBuildingRequest";
        stringArray[38] = "request";
        stringArray[39] = "setModelProcessor";
        stringArray[40] = "build";
        stringArray[41] = "build";
        stringArray[42] = "copyModel";
        stringArray[43] = "model";
        stringArray[44] = "effectiveModel";
        stringArray[45] = "putCache";
        stringArray[46] = "modelCache";
        stringArray[47] = "groupId";
        stringArray[48] = "artifactId";
        stringArray[49] = "version";
        stringArray[50] = "RAW";
        stringArray[51] = "createModelData";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[52];
        TilesMavenLifecycleParticipant.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(TilesMavenLifecycleParticipant.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = TilesMavenLifecycleParticipant.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$apache$maven$project$DefaultModelBuildingListener() {
        Class clazz = $class$org$apache$maven$project$DefaultModelBuildingListener;
        if (clazz == null) {
            clazz = $class$org$apache$maven$project$DefaultModelBuildingListener = TilesMavenLifecycleParticipant.class$("org.apache.maven.project.DefaultModelBuildingListener");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$apache$maven$model$building$ModelCacheTag() {
        Class clazz = $class$org$apache$maven$model$building$ModelCacheTag;
        if (clazz == null) {
            clazz = $class$org$apache$maven$model$building$ModelCacheTag = TilesMavenLifecycleParticipant.class$("org.apache.maven.model.building.ModelCacheTag");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ArtifactModel
    implements GroovyObject {
        public Artifact artifact;
        public TileModel tileModel;
        public /* synthetic */ TilesMavenLifecycleParticipant this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ArtifactModel(TilesMavenLifecycleParticipant $p$, Artifact artifact, TileModel tileModel) {
            TileModel tileModel2;
            Artifact artifact2;
            MetaClass metaClass;
            TilesMavenLifecycleParticipant tilesMavenLifecycleParticipant;
            this.this$0 = tilesMavenLifecycleParticipant = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.artifact = artifact2 = artifact;
            this.tileModel = tileModel2 = tileModel;
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ArtifactModel.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ArtifactModel.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(ArtifactModel.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$2(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$2(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$2(name);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ArtifactModel.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            ArtifactModel.__$swapInit();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ArtifactModel.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ArtifactModel.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

