/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.common.common.exception;

import java.util.Locale;

public class ResourceNotFoundException
extends Exception {
    private String resourceName;
    private ResourceType resourceType;

    public ResourceNotFoundException(String message, ResourceType resourceType, String resourceName) {
        super(message);
        this.resourceType = resourceType;
        this.resourceName = resourceName;
    }

    public ResourceNotFoundException(String message, ResourceType resourceType, String resourceName, Throwable cause) {
        super(message, cause);
        this.resourceType = resourceType;
        this.resourceName = resourceName;
    }

    public ResourceNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceTypeString() {
        return this.resourceType.toString().toLowerCase(Locale.ENGLISH).replace("_", " ");
    }

    public static enum ResourceType {
        SIDDHI_APP_NAME,
        STREAM_NAME,
        CSV_FILE,
        DATABASE,
        RANDOM_SIMULATION,
        DATABASE_SIMULATION,
        SIMULATION;

    }
}

