/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.common.common.utils.config;

import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.distribution.common.common.utils.config.ClusterConfig;
import io.siddhi.distribution.common.common.utils.config.Extension;
import io.siddhi.distribution.common.common.utils.config.ExtensionChildConfiguration;
import io.siddhi.distribution.common.common.utils.config.FileConfigReader;
import io.siddhi.distribution.common.common.utils.config.Reference;
import io.siddhi.distribution.common.common.utils.config.ReferenceChildConfiguration;
import io.siddhi.distribution.common.common.utils.config.RootConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;

public class FileConfigManager
implements ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigManager.class);
    private ConfigProvider configProvider;

    public FileConfigManager(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public ConfigReader generateConfigReader(String namespace, String name) {
        if (this.configProvider != null) {
            try {
                RootConfiguration rootConfiguration = (RootConfiguration)this.configProvider.getConfigurationObject(RootConfiguration.class);
                if (null != rootConfiguration && null != rootConfiguration.getExtensions()) {
                    for (Extension extension : rootConfiguration.getExtensions()) {
                        ExtensionChildConfiguration childConfiguration = extension.getExtension();
                        if (null == childConfiguration || null == childConfiguration.getName() || !childConfiguration.getName().equals(name) || null == childConfiguration.getNamespace() || !childConfiguration.getNamespace().equals(namespace) || null == childConfiguration.getProperties()) continue;
                        return new FileConfigReader(childConfiguration.getProperties());
                    }
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("Could not initiate the siddhi configuration object, " + e.getMessage(), (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Could not find a matching configuration for name: " + name + "and namespace: " + namespace + "!");
        }
        return new FileConfigReader(new HashMap<String, String>());
    }

    public Map<String, String> extractSystemConfigs(String name) {
        if (this.configProvider != null) {
            try {
                RootConfiguration rootConfiguration = (RootConfiguration)this.configProvider.getConfigurationObject(RootConfiguration.class);
                if (null != rootConfiguration && null != rootConfiguration.getRefs()) {
                    for (Reference ref : rootConfiguration.getRefs()) {
                        ReferenceChildConfiguration childConfiguration = ref.getReference();
                        if (null == childConfiguration || null == childConfiguration.getName() || !childConfiguration.getName().equals(name)) continue;
                        HashMap<String, String> referenceConfigs = new HashMap<String, String>();
                        referenceConfigs.put("type", childConfiguration.getType());
                        if (childConfiguration.getProperties() != null) {
                            referenceConfigs.putAll(childConfiguration.getProperties());
                        }
                        return referenceConfigs;
                    }
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("Could not initiate the siddhi configuration object, " + e.getMessage(), (Throwable)e);
            }
        }
        return new HashMap<String, String>();
    }

    public String extractProperty(String name) {
        String property = null;
        if (this.configProvider != null) {
            try {
                RootConfiguration rootConfiguration = (RootConfiguration)this.configProvider.getConfigurationObject(RootConfiguration.class);
                if (null != rootConfiguration && null != rootConfiguration.getProperties()) {
                    property = rootConfiguration.getProperties().get(name);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("Could not initiate the siddhi configuration object, " + e.getMessage(), (Throwable)e);
            }
            if (property == null && "shardId".equalsIgnoreCase(name)) {
                try {
                    ClusterConfig clusterConfig = (ClusterConfig)this.configProvider.getConfigurationObject(ClusterConfig.class);
                    if (clusterConfig != null && clusterConfig.getGroupId() != null && clusterConfig.isEnabled()) {
                        return clusterConfig.getGroupId();
                    }
                }
                catch (ConfigurationException e) {
                    LOGGER.error("Could not initiate the cluster.config configuration object, " + e.getMessage(), (Throwable)e);
                }
                try {
                    CarbonConfiguration carbonConfiguration = (CarbonConfiguration)this.configProvider.getConfigurationObject(CarbonConfiguration.class);
                    if (carbonConfiguration != null && carbonConfiguration.getId() != null) {
                        return carbonConfiguration.getId();
                    }
                }
                catch (ConfigurationException e) {
                    LOGGER.error("Could not initiate the wso2.carbon configuration object, " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Could not find a matching configuration for property name: " + name + "");
        }
        return property;
    }
}

