/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.api;

import io.siddhi.distribution.core.api.NotFoundException;
import io.siddhi.distribution.core.api.SiddhiAppsApiService;
import io.siddhi.distribution.core.factories.SiddhiAppsApiServiceFactory;
import io.siddhi.distribution.core.model.InlineResponse200;
import io.siddhi.distribution.core.model.InlineResponse400;
import io.siddhi.distribution.core.model.SiddhiAppMetrics;
import io.siddhi.distribution.core.model.StatsEnable;
import io.siddhi.distribution.msf4j.interceptor.common.common.AuthenticationInterceptor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;

@Path(value="/siddhi-apps")
@RequestInterceptor(value={AuthenticationInterceptor.class})
@Api(description="The siddhi-apps API")
@Component(name="siddhi-core-services", service={Microservice.class}, immediate=true)
public class SiddhiAppsApi
implements Microservice {
    private final SiddhiAppsApiService delegate = SiddhiAppsApiServiceFactory.getSiddhiAppsApi();

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Saves the Siddhi Application", notes="Saves the Siddhi Application. Request **siddhiApp** explains the Siddhi Query. ", response=InlineResponse400.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=201, message="The Siddhi Application is successfully validated and saved.", response=InlineResponse400.class), @ApiResponse(code=400, message="A validation error occured.", response=InlineResponse400.class), @ApiResponse(code=409, message="A Siddhi Application with the given name already exists.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsPost(@Context Request request, @ApiParam(value="Siddhi Application", required=true) String body) throws NotFoundException {
        return this.delegate.siddhiAppsPost(body, request);
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates the Siddhi Application.", notes="Updates the Siddhi Application. Request **siddhiApp** explains the Siddhi Query. ", response=InlineResponse400.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Application is successfully validated and updated.", response=InlineResponse400.class), @ApiResponse(code=201, message="The Siddhi Application is successfully validated and saved.", response=InlineResponse400.class), @ApiResponse(code=400, message="A validation error occured.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsPut(@Context Request request, @ApiParam(value="Siddhi Application", required=true) String body) throws NotFoundException {
        return this.delegate.siddhiAppsPut(body, request);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists Siddhi Applications", notes="Provides the name list of Siddhi Applications that exist.", response=InlineResponse200.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Applications are successfully retrieved.", response=InlineResponse200.class)})
    public Response siddhiAppsGet(@Context Request request, @ApiParam(value="Retrieves only active/inactive Siddhi Applications as specified.", required=false) @QueryParam(value="isActive") String isActive) throws NotFoundException {
        return this.delegate.siddhiAppsGet(isActive, request);
    }

    @DELETE
    @Path(value="/{appName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes the Siddhi Application.", notes="Removes the currently deployed Siddhi Application with the name specified. Path param of **appName** determines name of the Siddhi application. ", response=InlineResponse400.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Application is successfully deleted.", response=InlineResponse400.class), @ApiResponse(code=400, message="The Siddhi Application name provided is invalid.", response=InlineResponse400.class), @ApiResponse(code=404, message="The Siddhi Application is not found.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsAppNameDelete(@Context Request request, @ApiParam(value="The name of the Siddhi Application", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameDelete(appName, request);
    }

    @GET
    @Path(value="/{appName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves the specified Siddhi Application.", notes="Retrieves the Siddhi Application with the specified name.", response=InlineResponse200.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Application is successfully retrieved.", response=InlineResponse200.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=InlineResponse200.class)})
    public Response siddhiAppsAppNameGet(@Context Request request, @ApiParam(value="The name of the Siddhi Application", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameGet(appName, request);
    }

    @GET
    @Path(value="/{appName}/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Fetches the status of the Siddhi Application.", notes="Fetches the status of the Siddhi Application.", response=InlineResponse200.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The state of the Siddhi Application is successfully retrieved.", response=InlineResponse200.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=InlineResponse200.class)})
    public Response siddhiAppsAppNameStatusGet(@Context Request request, @ApiParam(value="The name of the Siddhi Application.", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameStatusGet(appName, request);
    }

    @POST
    @Path(value="/{appName}/backup")
    @Produces(value={"application/json"})
    @ApiOperation(value="Backs up the current state of a Siddhi Application.", notes="Backs up the current state of the specified Siddhi Application. ", response=InlineResponse400.class, tags={"State"})
    @ApiResponses(value={@ApiResponse(code=200, message="The state of the Siddhi Application is successfully persisted.", response=InlineResponse400.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsAppNameSnapshotPost(@Context Request request, @ApiParam(value="The name of the Siddhi Application.", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameBackupPost(appName, request);
    }

    @POST
    @Path(value="/{appName}/restore")
    @Produces(value={"application/json"})
    @ApiOperation(value="Restores the state of a Siddhi Application.", notes="Restores the state of the specified Siddhi Application.", response=InlineResponse400.class, tags={"State"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Application is successfully restored.", response=InlineResponse400.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsAppNameRestorePost(@Context Request request, @ApiParam(value="The name of the Siddhi Application.", required=true) @PathParam(value="appName") String appName, @ApiParam(value="The revision number of the backup.", required=false) @QueryParam(value="revision") String revision) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameRestorePost(appName, revision, request);
    }

    @DELETE
    @Path(value="/{appName}/revisions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes all revisions of the periodic state of a Siddhi Application.", notes="Deletes all revisions of the periodic state of the specified Siddhi Application.", response=InlineResponse400.class, tags={"State"})
    @ApiResponses(value={@ApiResponse(code=200, message="All revisions of the periodic state of the siddhi application are deleted succussfully.", response=InlineResponse400.class), @ApiResponse(code=404, message="The Siddhi Application is not found.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsAppNameRevisionsDelete(@Context Request request, @ApiParam(value="The name of the Siddhi Application.", required=true) @PathParam(value="appName") String appName, @ApiParam(value="Whether the redeployment enable or not", required=false) @QueryParam(value="enabledRedeployment") String enabledRedeployment) throws NotFoundException {
        return this.delegate.siddhiAppsAppNameRevisionsDelete(appName, enabledRedeployment, request);
    }

    @DELETE
    @Path(value="/revisions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes all revisions of the periodic state of all Siddhi Applications.", notes="Deletes all revisions of the periodic state of all Siddhi Applications. ", response=InlineResponse400.class, tags={"State"})
    @ApiResponses(value={@ApiResponse(code=200, message="All revisions of the periodic state of all the siddhi applicationa are deleted succussfully.", response=InlineResponse400.class), @ApiResponse(code=500, message="An unexpected error occured.", response=InlineResponse400.class)})
    public Response siddhiAppsRevisionsDelete(@Context Request request, @ApiParam(value="Whether the redeployment enable or not", required=false) @QueryParam(value="enabledRedeployment") String enabledRedeployment) throws NotFoundException {
        return this.delegate.siddhiAppsRevisionsDelete(enabledRedeployment, request);
    }

    @GET
    @Path(value="/{appName}/elements")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves the  elements of the specified Siddhi Application.", notes="Retrieves the elements with the specified name.", response=InlineResponse200.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Application is successfully retrieved.", response=InlineResponse200.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=InlineResponse200.class)})
    public Response siddhiAppsElementsGet(@Context Request request, @ApiParam(value="The name of the Siddhi Application", required=true) @PathParam(value="appName") String appName) throws NotFoundException {
        return this.delegate.siddhiAppsElementsGet(appName, request);
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Fetches the statistics details of the Siddhi Applications.", notes="Fetches the status of the Siddhi Application. ", response=SiddhiAppMetrics.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Siddhi Applications  statistics data are successfully retrieved.", response=SiddhiAppMetrics.class)})
    public Response siddhiAppsStatisticsGet(@Context Request request, @ApiParam(value="Retrieves only active/inactive Siddhi Applications as specified.", required=false) @QueryParam(value="isActive") String isActive) throws NotFoundException {
        return this.delegate.siddhiAppsStatisticsGet(isActive, request);
    }

    @PUT
    @Path(value="/{appName}/statistics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Dissable the statistics of siddhi application.", notes="Dissable the statistics of siddhi application. ", response=void.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="Siddhi Application sucessfully updated.", response=void.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=void.class)})
    public Response siddhiAppMetricsEnable(@Context Request request, @ApiParam(value="The name of the Siddhi Application.", required=true) @PathParam(value="appName") String appName, @ApiParam(value="statsEnable", required=true) StatsEnable statsEnable) throws NotFoundException {
        return this.delegate.siddhiAppStatsEnable(appName, statsEnable.getStatsEnable(), request);
    }

    @PUT
    @Path(value="/statistics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Dissable the statistics of siddhi application.", notes="Dissable the statistics of siddhi application. ", response=void.class, tags={"Artifact"})
    @ApiResponses(value={@ApiResponse(code=200, message="Siddhi Application sucessfully updated.", response=void.class), @ApiResponse(code=404, message="The Siddhi Application specified is not found.", response=void.class)})
    public Response siddhiAllAppMetricsEnable(@Context Request request, @ApiParam(value="statsEnable", required=true) StatsEnable statsEnable) throws NotFoundException {
        return this.delegate.siddhiAppsStatsEnable(statsEnable.getStatsEnable(), request);
    }
}

