/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.impl;

import io.siddhi.distribution.core.api.ApiResponseMessageWithCode;
import io.siddhi.distribution.core.api.NotFoundException;
import io.siddhi.distribution.core.api.RunTimeApiService;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.analytics.permissions.bean.Permission;
import org.wso2.msf4j.Request;

@Component(service={RunTimeApiService.class}, immediate=true)
public class RunTimeApiServiceImpl
extends RunTimeApiService {
    private static final String PERMISSION_APP_NAME = "SAPP";
    private static final String MANAGE_SIDDHI_APP_PERMISSION_STRING = "siddhiApp.manage";
    private static final String VIEW_SIDDHI_APP_PERMISSION_STRING = "siddhiApp.view";

    private static String getUserName(Request request) {
        Object username = request.getProperty("username");
        return username != null ? username.toString() : null;
    }

    @Override
    public Response getRunTime(Request request) throws NotFoundException {
        if (RunTimeApiServiceImpl.getUserName(request) != null && !StreamProcessorDataHolder.getPermissionProvider().hasPermission(RunTimeApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, VIEW_SIDDHI_APP_PERMISSION_STRING)) && !StreamProcessorDataHolder.getPermissionProvider().hasPermission(RunTimeApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to get the system details.").build();
        }
        if (System.getProperty("wso2.runtime") != null) {
            return Response.ok().entity((Object)System.getProperty("wso2.runtime")).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ApiResponseMessageWithCode(800102, "wso2.runtime is not found")).build();
    }
}

