/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.impl;

import com.google.gson.Gson;
import io.siddhi.distribution.core.api.ApiResponseMessage;
import io.siddhi.distribution.core.api.ApiResponseMessageWithCode;
import io.siddhi.distribution.core.api.NotFoundException;
import io.siddhi.distribution.core.api.SiddhiAppsApiService;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.internal.beans.SiddhiAppElements;
import io.siddhi.distribution.core.internal.exception.SiddhiAppConfigurationException;
import io.siddhi.distribution.core.internal.exception.SiddhiAppDeploymentException;
import io.siddhi.distribution.core.model.SiddhiAppContent;
import io.siddhi.distribution.core.model.SiddhiAppMetrics;
import io.siddhi.distribution.core.model.SiddhiAppRevision;
import io.siddhi.distribution.core.model.SiddhiAppStatus;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.permissions.PermissionProvider;
import org.wso2.carbon.analytics.permissions.bean.Permission;
import org.wso2.msf4j.Request;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.stream.input.source.Source;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.util.snapshot.PersistenceReference;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiAppsApiServiceImpl
extends SiddhiAppsApiService {
    private static final Logger log = LoggerFactory.getLogger(SiddhiAppsApiServiceImpl.class);
    private static final String PERMISSION_APP_NAME = "SAPP";
    private static final String MANAGE_SIDDHI_APP_PERMISSION_STRING = "siddhiApp.manage";
    private static final String VIEW_SIDDHI_APP_PERMISSION_STRING = "siddhiApp.view";

    private static String getUserName(Request request) {
        Object username = request.getProperty("username");
        return username != null ? username.toString() : null;
    }

    public Response siddhiAppsPost(String body) throws NotFoundException {
        Response.Status status;
        String jsonString;
        try {
            String siddhiAppName = StreamProcessorDataHolder.getStreamProcessorService().validateAndSave(body, false);
            if (siddhiAppName != null) {
                URI location = URI.create("siddhi-apps/" + siddhiAppName);
                String jsonString2 = new Gson().toJson((Object)new ApiResponseMessage("success", "Siddhi App saved succesfully and will be deployed in next deployment cycle"));
                return Response.created((URI)location).entity((Object)jsonString2).build();
            }
            jsonString = new Gson().toJson((Object)new ApiResponseMessage("conflict", "There is a Siddhi App already exists with same name"));
            status = Response.Status.CONFLICT;
        }
        catch (SiddhiAppDeploymentException e) {
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        catch (SiddhiAppConfigurationException e) {
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800101, e.getMessage()));
            status = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsPut(String body) throws NotFoundException {
        Response.Status status;
        String jsonString;
        block4: {
            jsonString = new Gson().toString();
            status = Response.Status.OK;
            try {
                boolean isAlreadyExists = StreamProcessorDataHolder.getStreamProcessorService().isExists(body);
                String siddhiAppName = StreamProcessorDataHolder.getStreamProcessorService().validateAndSave(body, true);
                if (siddhiAppName == null) break block4;
                if (isAlreadyExists) {
                    jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "Siddhi App updated succesfully and will be deployed in next deployment cycle"));
                    break block4;
                }
                URI location = URI.create("siddhi-apps/" + siddhiAppName);
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "Siddhi App saved succesfully and will be deployed in next deployment cycle"));
                return Response.created((URI)location).entity((Object)jsonString).build();
            }
            catch (SiddhiAppDeploymentException e) {
                jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            catch (SiddhiAppConfigurationException e) {
                jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800101, e.getMessage()));
                status = Response.Status.BAD_REQUEST;
            }
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsGet(String isActive) throws NotFoundException {
        ArrayList<String> artifactList = new ArrayList<String>();
        Map<String, SiddhiAppData> siddhiAppFileMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        if (isActive != null && !isActive.trim().isEmpty()) {
            boolean isActiveValue = Boolean.parseBoolean(isActive);
            for (Map.Entry<String, SiddhiAppData> siddhiAppFileEntry : siddhiAppFileMap.entrySet()) {
                if (isActiveValue != siddhiAppFileEntry.getValue().isActive()) continue;
                artifactList.add(siddhiAppFileEntry.getKey());
            }
        } else {
            for (Map.Entry<String, SiddhiAppData> siddhiAppFileEntry : siddhiAppFileMap.entrySet()) {
                artifactList.add(siddhiAppFileEntry.getKey());
            }
        }
        return Response.ok().entity(artifactList).build();
    }

    public Response siddhiAppsAppNameDelete(String appFileName) throws NotFoundException {
        String jsonString;
        Response.Status status = Response.Status.OK;
        try {
            if (StreamProcessorDataHolder.getStreamProcessorService().delete(appFileName)) {
                return Response.status((Response.Status)status).build();
            }
            jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appFileName));
            status = Response.Status.NOT_FOUND;
        }
        catch (SiddhiAppConfigurationException e) {
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800101, e.getMessage()));
            status = Response.Status.BAD_REQUEST;
        }
        catch (SiddhiAppDeploymentException e) {
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsAppNameGet(String appName) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        if (siddhiAppMap.containsKey(appName)) {
            SiddhiAppData siddhiAppData = siddhiAppMap.get(appName);
            SiddhiAppContent siddhiAppContent = new SiddhiAppContent();
            siddhiAppContent.setcontent(siddhiAppData.getSiddhiApp());
            return Response.ok().entity((Object)siddhiAppContent).build();
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appName));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonString).build();
    }

    public Response siddhiAppsAppNameStatusGet(String appFileName) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        if (siddhiAppMap.containsKey(appFileName)) {
            SiddhiAppData siddhiAppData = siddhiAppMap.get(appFileName);
            SiddhiAppStatus siddhiAppStatus = new SiddhiAppStatus();
            siddhiAppStatus.setStatus(siddhiAppData.isActive() ? "active" : "inactive");
            return Response.ok().entity((Object)siddhiAppStatus).build();
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appFileName));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonString).build();
    }

    public Response siddhiAppsAppNameBackupPost(String appName) throws NotFoundException {
        String jsonString;
        Response.Status status = Response.Status.OK;
        try {
            SiddhiAppRuntime siddhiAppRuntime = StreamProcessorDataHolder.getSiddhiManager().getSiddhiAppRuntime(appName);
            if (siddhiAppRuntime != null) {
                PersistenceReference persistenceReference = siddhiAppRuntime.persist();
                SiddhiAppRevision siddhiAppRevision = new SiddhiAppRevision();
                siddhiAppRevision.setrevision(persistenceReference.getRevision());
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)siddhiAppRevision).build();
            }
            jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appName));
            status = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            log.error("Exception occurred when backup the state for Siddhi App : " + appName, (Throwable)e);
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsAppNameRestorePost(String appName, String revision) throws NotFoundException {
        String jsonString;
        Response.Status status = Response.Status.OK;
        try {
            SiddhiAppRuntime siddhiAppRuntime = StreamProcessorDataHolder.getSiddhiManager().getSiddhiAppRuntime(appName);
            if (siddhiAppRuntime != null) {
                if (revision == null) {
                    siddhiAppRuntime.restoreLastRevision();
                    jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "State restored to last revision for Siddhi App :" + appName));
                } else {
                    siddhiAppRuntime.restoreRevision(revision);
                    jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "State restored to revision " + revision + " for Siddhi App :" + appName));
                }
            } else {
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appName));
                status = Response.Status.NOT_FOUND;
            }
        }
        catch (Exception e) {
            log.error("Exception occurred when restoring the state for Siddhi App : " + appName, (Throwable)e);
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsAppNamePersistenceDelete(String appName, String enabledRedeployment) throws NotFoundException {
        String jsonString;
        Response.Status status = Response.Status.OK;
        try {
            SiddhiAppRuntime siddhiAppRuntime = StreamProcessorDataHolder.getSiddhiManager().getSiddhiAppRuntime(appName);
            if (siddhiAppRuntime != null) {
                Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
                SiddhiAppData siddhiAppContent = siddhiAppMap.get(appName);
                if (enabledRedeployment == null || "true".equals(enabledRedeployment)) {
                    StreamProcessorDataHolder.getStreamProcessorService().undeploySiddhiApp(appName);
                }
                siddhiAppRuntime.clearAllRevisions();
                if (enabledRedeployment == null || "true".equals(enabledRedeployment)) {
                    StreamProcessorDataHolder.getStreamProcessorService().deploySiddhiApp(siddhiAppContent.getSiddhiApp(), appName);
                    jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "All revisions of the state persistence are deleted for Siddhi App :" + appName));
                } else {
                    jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "All revisions of the state persistence are deleted for Siddhi App :" + appName + " with redeployment."));
                }
            } else {
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appName));
                status = Response.Status.NOT_FOUND;
            }
        }
        catch (Throwable e) {
            log.error("Exception occurred when deleting the persistance store : " + appName, e);
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsRevisionsDelete(String enabledRedeployment) throws NotFoundException {
        String jsonString;
        Response.Status status = Response.Status.OK;
        try {
            Map<String, SiddhiAppData> siddhiApps = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
            HashMap<String, SiddhiAppData> storedSiddhiApps = new HashMap<String, SiddhiAppData>(siddhiApps);
            if (enabledRedeployment == null || "true".equals(enabledRedeployment)) {
                for (Map.Entry<String, SiddhiAppData> entry : siddhiApps.entrySet()) {
                    if (entry.getValue() == null) continue;
                    StreamProcessorDataHolder.getStreamProcessorService().undeploySiddhiApp(entry.getKey());
                }
            }
            for (Map.Entry<String, SiddhiAppData> entry : storedSiddhiApps.entrySet()) {
                if (entry.getValue() == null || entry.getValue().getSiddhiAppRuntime() == null) continue;
                entry.getValue().getSiddhiAppRuntime().clearAllRevisions();
            }
            if (enabledRedeployment == null || "true".equals(enabledRedeployment)) {
                for (Map.Entry<String, SiddhiAppData> entry : storedSiddhiApps.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().getSiddhiAppRuntime() == null) continue;
                    StreamProcessorDataHolder.getStreamProcessorService().deploySiddhiApp(entry.getValue().getSiddhiApp(), entry.getKey());
                }
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "All revisions of the state persistence is deleted for Siddhi Apps with redeployment"));
            } else {
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "All revisions of the state persistence is deleted for Siddhi Apps"));
            }
        }
        catch (Throwable e) {
            log.error("Exception occurred when deleting the persistance store :", e);
            jsonString = new Gson().toJson((Object)new ApiResponseMessageWithCode(800102, e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)jsonString).build();
    }

    public Response siddhiAppsStatisticsGet(String isActive) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppFileMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        ArrayList<SiddhiAppMetrics> siddhiAppMetricsList = new ArrayList<SiddhiAppMetrics>();
        if (!siddhiAppFileMap.isEmpty()) {
            if (isActive != null && !isActive.trim().isEmpty()) {
                boolean isActiveValue = Boolean.parseBoolean(isActive);
                for (Map.Entry<String, SiddhiAppData> siddhiAppFileEntry : siddhiAppFileMap.entrySet()) {
                    SiddhiAppData siddiAppData = siddhiAppFileEntry.getValue();
                    isActiveValue = siddiAppData.isActive();
                    if (!isActiveValue) continue;
                    long age = System.currentTimeMillis() - siddiAppData.getDeploymentTime();
                    SiddhiAppMetrics appMetrics = new SiddhiAppMetrics();
                    appMetrics.setAge(age);
                    appMetrics.appName(siddhiAppFileEntry.getKey());
                    appMetrics.isStatEnabled(siddiAppData.getSiddhiAppRuntime().isStatsEnabled());
                    appMetrics.status(siddiAppData.isActive() ? "active" : "inactive");
                    siddhiAppMetricsList.add(appMetrics);
                }
            } else {
                for (Map.Entry<String, SiddhiAppData> siddhiAppFileEntry : siddhiAppFileMap.entrySet()) {
                    SiddhiAppData siddiAppData = siddhiAppFileEntry.getValue();
                    SiddhiAppMetrics appMetrics = new SiddhiAppMetrics();
                    if (siddiAppData.isActive()) {
                        long age = System.currentTimeMillis() - siddiAppData.getDeploymentTime();
                        appMetrics.setAge(age);
                    } else {
                        appMetrics.setAge(0L);
                    }
                    appMetrics.appName(siddhiAppFileEntry.getKey());
                    if (siddiAppData.isActive()) {
                        appMetrics.isStatEnabled(siddiAppData.getSiddhiAppRuntime().isStatsEnabled());
                    } else {
                        appMetrics.isStatEnabled(false);
                    }
                    appMetrics.status(siddiAppData.isActive() ? "active" : "inactive");
                    siddhiAppMetricsList.add(appMetrics);
                }
            }
            return Response.ok().entity(siddhiAppMetricsList).build();
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There are no any Siddhi App exist."));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonString).build();
    }

    public Response siddhiAppStatsEnable(String appFileName, boolean statsEnabled) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        SiddhiAppData siddiAppData = siddhiAppMap.get(appFileName);
        if (siddiAppData != null) {
            String jsonString;
            if (statsEnabled && siddiAppData.getSiddhiAppRuntime().isStatsEnabled()) {
                log.info("Stats has already annabled for siddhi app :" + appFileName);
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "Stats has already annabled for siddhi app :" + appFileName));
            } else if (!statsEnabled && !siddiAppData.getSiddhiAppRuntime().isStatsEnabled()) {
                log.info("Stats has already disabled for siddhi app :" + appFileName);
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "Stats has already disabled for siddhi app :" + appFileName));
            } else {
                siddiAppData.getSiddhiAppRuntime().enableStats(statsEnabled);
                jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "Sucessfully updated Aiddhi App : " + appFileName));
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonString).build();
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appFileName));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonString).build();
    }

    public Response siddhiAppsStatsEnable(boolean statsEnabled) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        for (Map.Entry<String, SiddhiAppData> siddhiAppEntry : siddhiAppMap.entrySet()) {
            SiddhiAppData siddiAppData = siddhiAppEntry.getValue();
            if ((!statsEnabled || siddiAppData.getSiddhiAppRuntime().isStatsEnabled()) && (statsEnabled || !siddiAppData.getSiddhiAppRuntime().isStatsEnabled())) continue;
            siddiAppData.getSiddhiAppRuntime().enableStats(statsEnabled);
            if (!log.isDebugEnabled()) continue;
            log.debug("Stats has been sucessfull updated for siddhi app :" + siddhiAppEntry.getKey());
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("success", "All siddhi apps Sucessfully updated."));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonString).build();
    }

    public Response siddhiAppElementsGet(String appName) throws NotFoundException {
        Map<String, SiddhiAppData> siddhiAppDataMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        if (siddhiAppDataMap.containsKey(appName)) {
            String siddhiAppString = siddhiAppDataMap.get(appName).getSiddhiApp();
            SiddhiApp siddhiApp = SiddhiCompiler.parse((String)String.valueOf(siddhiAppString));
            SiddhiAppRuntime siddhiAppRuntime = new SiddhiManager().createSiddhiAppRuntime(siddhiApp);
            ArrayList<SiddhiAppElements> listOfSiddhiAppElements = new ArrayList<SiddhiAppElements>();
            for (int i = 0; i < siddhiApp.getExecutionElementList().size(); ++i) {
                ExecutionElement executionElement = (ExecutionElement)siddhiApp.getExecutionElementList().get(i);
                if (executionElement instanceof Query) {
                    this.loadQueryExecutionElements(siddhiApp, siddhiAppRuntime, executionElement, siddhiAppString, listOfSiddhiAppElements);
                    continue;
                }
                if (!(executionElement instanceof Partition)) continue;
                this.loadPartitionExecutionElements(siddhiApp, siddhiAppRuntime, executionElement, siddhiAppString, listOfSiddhiAppElements);
            }
            this.loadAggregarionData(siddhiApp, siddhiAppRuntime, listOfSiddhiAppElements, siddhiAppString);
            this.loadSources(siddhiApp, siddhiAppRuntime, listOfSiddhiAppElements, siddhiAppString);
            this.loadSinks(siddhiApp, siddhiAppRuntime, listOfSiddhiAppElements, siddhiAppString);
            return Response.ok().entity(listOfSiddhiAppElements).build();
        }
        String jsonString = new Gson().toJson((Object)new ApiResponseMessage("not-found", "There is no Siddhi App exist with provided name : " + appName));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonString).build();
    }

    private void loadQueryExecutionElements(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, ExecutionElement executionElement, String siddhiAppString, List<SiddhiAppElements> listOfSiddhiAppElements) {
        for (String inputStreamId : ((Query)executionElement).getInputStream().getUniqueStreamIds()) {
            SiddhiAppElements siddhiAppElements = new SiddhiAppElements();
            siddhiAppElements.setInputStreamId(inputStreamId);
            this.loadInputData(siddhiApp, siddhiAppRuntime, inputStreamId, siddhiAppString, siddhiAppElements);
            String outPutStreamId = ((Query)executionElement).getOutputStream().getId();
            siddhiAppElements.setOutputStreamId(outPutStreamId);
            this.loadOutputData(siddhiApp, siddhiAppRuntime, outPutStreamId, siddhiAppString, siddhiAppElements);
            this.loadFunctionData(siddhiApp, ((Query)executionElement).getSelector().getSelectionList(), siddhiAppElements, siddhiAppString);
            this.loadQueryName(executionElement.getAnnotations(), siddhiAppElements);
            Query query = (Query)executionElement;
            siddhiAppElements.setQuery(this.getDefinition((SiddhiElement)query, siddhiAppString));
            listOfSiddhiAppElements.add(siddhiAppElements);
        }
    }

    private void loadPartitionExecutionElements(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, ExecutionElement executionElement, String siddhiAppString, List<SiddhiAppElements> listOfSiddhiAppElements) {
        List partitionStream = ((Partition)executionElement).getQueryList();
        for (Query query : partitionStream) {
            for (String inputStreamId : query.getInputStream().getUniqueStreamIds()) {
                SiddhiAppElements siddhiAppElements = new SiddhiAppElements();
                siddhiAppElements.setInputStreamId(inputStreamId);
                siddhiAppElements.setOutputStreamId(query.getOutputStream().getId());
                siddhiAppElements.setPartitionQuery(this.getDefinition((SiddhiElement)query, siddhiAppString));
                this.loadQueryName(executionElement.getAnnotations(), siddhiAppElements);
                this.loadInputData(siddhiApp, siddhiAppRuntime, inputStreamId, siddhiAppString, siddhiAppElements);
                String outputStreamId = query.getOutputStream().getId();
                this.loadOutputData(siddhiApp, siddhiAppRuntime, outputStreamId, siddhiAppString, siddhiAppElements);
                this.loadFunctionData(siddhiApp, query.getSelector().getSelectionList(), siddhiAppElements, siddhiAppString);
                for (PartitionType partitionType : ((Partition)executionElement).getPartitionTypeMap().values()) {
                    String partitionTypeDefinition;
                    if (partitionType instanceof ValuePartitionType) {
                        siddhiAppElements.setPartitionType("Value Partition");
                        partitionTypeDefinition = this.getDefinition((SiddhiElement)partitionType, siddhiAppString);
                        siddhiAppElements.setPartitionTypeQuery(partitionTypeDefinition);
                        continue;
                    }
                    if (partitionType instanceof RangePartitionType) {
                        siddhiAppElements.setPartitionType("Range Partition");
                        partitionTypeDefinition = this.getDefinition((SiddhiElement)partitionType, siddhiAppString);
                        siddhiAppElements.setPartitionTypeQuery(partitionTypeDefinition);
                        continue;
                    }
                    throw new IllegalArgumentException("An unidentified instance of the PartitionType Class was found");
                }
                Partition partitionQuery = (Partition)executionElement;
                siddhiAppElements.setQuery(this.getDefinition((SiddhiElement)partitionQuery, siddhiAppString));
                listOfSiddhiAppElements.add(siddhiAppElements);
            }
        }
    }

    private void loadInputData(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, String inputStream, String appData, SiddhiAppElements siddhiAppElements) {
        Map streamDefinitionMap = siddhiAppRuntime.getStreamDefinitionMap();
        Map tableDefinitionMap = siddhiAppRuntime.getTableDefinitionMap();
        Map triggerDefinitionMap = siddhiApp.getTriggerDefinitionMap();
        Map windowDefinitionMap = siddhiAppRuntime.getWindowDefinitionMap();
        Map aggregationDefinitionMap = siddhiApp.getAggregationDefinitionMap();
        for (Map.Entry entry : streamDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(inputStream)) continue;
            siddhiAppElements.setInputStreamSiddhiApp(String.valueOf(entry.getValue()));
            siddhiAppElements.setInputStreamType("Stream");
            break;
        }
        for (Map.Entry entry : tableDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(inputStream)) continue;
            siddhiAppElements.setInputStreamSiddhiApp(String.valueOf(entry.getValue()));
            siddhiAppElements.setInputStreamType("Table");
            break;
        }
        for (Map.Entry entry : triggerDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(inputStream)) continue;
            siddhiAppElements.setInputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setInputStreamType("Trigger");
            break;
        }
        for (Map.Entry entry : windowDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(inputStream)) continue;
            siddhiAppElements.setInputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setInputStreamType("Window");
            break;
        }
        for (Map.Entry entry : aggregationDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(inputStream)) continue;
            siddhiAppElements.setInputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setInputStreamType("Aggregation");
            break;
        }
    }

    private void loadOutputData(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, String outputStream, String appData, SiddhiAppElements siddhiAppElements) {
        Map streamDefinitionMap = siddhiAppRuntime.getStreamDefinitionMap();
        Map tableDefinitionMap = siddhiAppRuntime.getTableDefinitionMap();
        Map triggerDefinitionMap = siddhiApp.getTriggerDefinitionMap();
        Map windowDefinitionMap = siddhiAppRuntime.getWindowDefinitionMap();
        Map aggregationDefinitionMap = siddhiApp.getAggregationDefinitionMap();
        for (Map.Entry entry : streamDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(outputStream)) continue;
            siddhiAppElements.setOutputStreamSiddhiApp(String.valueOf(entry.getValue()));
            siddhiAppElements.setOutputStreamType("Stream");
            break;
        }
        for (Map.Entry entry : tableDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(outputStream)) continue;
            siddhiAppElements.setOutputStreamSiddhiApp(String.valueOf(entry.getValue()));
            siddhiAppElements.setOutputStreamType("Table");
            break;
        }
        for (Map.Entry entry : triggerDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(outputStream)) continue;
            siddhiAppElements.setOutputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setOutputStreamType("Trigger");
            break;
        }
        for (Map.Entry entry : windowDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(outputStream)) continue;
            siddhiAppElements.setOutputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setOutputStreamType("Window");
            break;
        }
        for (Map.Entry entry : aggregationDefinitionMap.entrySet()) {
            if (!((String)entry.getKey()).equals(outputStream)) continue;
            siddhiAppElements.setOutputStreamSiddhiApp(this.getDefinition((SiddhiElement)entry.getValue(), appData));
            siddhiAppElements.setOutputStreamType("Aggregation");
            break;
        }
    }

    private void loadFunctionData(SiddhiApp siddhiApp, List<OutputAttribute> functionList, SiddhiAppElements siddhiAppElements, String appData) {
        block0: for (FunctionDefinition functionDefinition : siddhiApp.getFunctionDefinitionMap().values()) {
            for (OutputAttribute app : functionList) {
                if (!(app.getExpression() instanceof AttributeFunction) || !functionDefinition.getId().equals(((AttributeFunction)app.getExpression()).getName())) continue;
                String functionDefinitionStr = this.getDefinition((SiddhiElement)functionDefinition, appData);
                siddhiAppElements.setFunction(functionDefinition.getId());
                siddhiAppElements.setFunctionQuery(functionDefinitionStr);
                continue block0;
            }
        }
    }

    private void loadAggregarionData(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, List<SiddhiAppElements> streams, String appData) {
        for (AggregationDefinition aggregationDefinition : siddhiApp.getAggregationDefinitionMap().values()) {
            SiddhiAppElements siddhiAppElements = new SiddhiAppElements();
            siddhiAppElements.setInputStreamId(aggregationDefinition.getBasicSingleInputStream().getStreamId());
            siddhiAppElements.setOutputStreamId(aggregationDefinition.getId());
            this.loadInputData(siddhiApp, siddhiAppRuntime, aggregationDefinition.getBasicSingleInputStream().getStreamId(), appData, siddhiAppElements);
            String aggregationDefinitionStr = this.getDefinition((SiddhiElement)aggregationDefinition, appData);
            siddhiAppElements.setOutputStreamSiddhiApp(aggregationDefinitionStr);
            siddhiAppElements.setOutputStreamType("Aggregation");
            streams.add(siddhiAppElements);
        }
    }

    private void loadQueryName(List<Annotation> queryAnnotations, SiddhiAppElements siddhiAppElements) {
        for (Annotation annotation : queryAnnotations) {
            for (Element element : annotation.getElements()) {
                siddhiAppElements.setQueryName(element.getValue());
            }
        }
        if (siddhiAppElements.getQueryName() == null) {
            siddhiAppElements.setQueryName("query");
        }
    }

    private String getDefinition(SiddhiElement siddhiElement, String siddhiAppString) {
        int[] startIndex = siddhiElement.getQueryContextStartIndex();
        int[] endIndex = siddhiElement.getQueryContextEndIndex();
        int startLinePosition = this.ordinalIndexOf(startIndex[0], siddhiAppString);
        int endLinePosition = this.ordinalIndexOf(endIndex[0], siddhiAppString);
        return siddhiAppString.substring(startLinePosition + startIndex[1], endLinePosition + endIndex[1]).replaceAll("'", "\"");
    }

    private int ordinalIndexOf(int lineNumber, String siddhiAppString) {
        int position = 0;
        while (lineNumber >= 0 && --lineNumber > 0) {
            position = siddhiAppString.indexOf(10, position) + 1;
        }
        return position;
    }

    private void loadSources(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, List<SiddhiAppElements> listOfSiddhiAppElements, String siddhiAppString) {
        for (List sources : siddhiAppRuntime.getSources()) {
            for (Source source : sources) {
                for (Annotation annotation : source.getStreamDefinition().getAnnotations()) {
                    for (Element element : annotation.getElements()) {
                        if (!Objects.equals(element.getValue(), source.getType())) continue;
                        SiddhiAppElements siddhiAppElements = new SiddhiAppElements();
                        siddhiAppElements.setOutputStreamId(source.getStreamDefinition().getId());
                        siddhiAppElements.setInputStreamId(source.getType());
                        siddhiAppElements.setInputStreamType("Source");
                        this.loadOutputData(siddhiApp, siddhiAppRuntime, source.getStreamDefinition().getId(), siddhiAppString, siddhiAppElements);
                        siddhiAppElements.setInputStreamSiddhiApp(this.getDefinition((SiddhiElement)annotation, siddhiAppString));
                        listOfSiddhiAppElements.add(siddhiAppElements);
                    }
                }
            }
        }
    }

    private void loadSinks(SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime, List<SiddhiAppElements> listOfSiddhiAppElements, String siddhiAppString) {
        for (List sinks : siddhiAppRuntime.getSinks()) {
            for (Sink sink : sinks) {
                for (Annotation annotation : sink.getStreamDefinition().getAnnotations()) {
                    for (Element element : annotation.getElements()) {
                        if (!Objects.equals(element.getValue(), sink.getType())) continue;
                        SiddhiAppElements siddhiAppElements = new SiddhiAppElements();
                        siddhiAppElements.setInputStreamId(sink.getStreamDefinition().getId());
                        this.loadInputData(siddhiApp, siddhiAppRuntime, sink.getStreamDefinition().getId(), siddhiAppString, siddhiAppElements);
                        siddhiAppElements.setOutputStreamId(sink.getType());
                        siddhiAppElements.setOutputStreamType("Sink");
                        siddhiAppElements.setOutputStreamSiddhiApp(this.getDefinition((SiddhiElement)annotation, siddhiAppString));
                        listOfSiddhiAppElements.add(siddhiAppElements);
                    }
                }
            }
        }
    }

    @Override
    public Response siddhiAppsPost(String body, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to add Siddhi Apps").build();
        }
        return this.siddhiAppsPost(body);
    }

    @Override
    public Response siddhiAppsPut(String body, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to update Siddhi Apps").build();
        }
        return this.siddhiAppsPut(body);
    }

    @Override
    public Response siddhiAppsGet(String isActive, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, VIEW_SIDDHI_APP_PERMISSION_STRING)) && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to list Siddhi Apps").build();
        }
        return this.siddhiAppsGet(isActive);
    }

    @Override
    public Response siddhiAppsAppNameDelete(String appFileName, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to delete Siddhi Apps").build();
        }
        return this.siddhiAppsAppNameDelete(appFileName);
    }

    @Override
    public Response siddhiAppsAppNameGet(String appName, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, VIEW_SIDDHI_APP_PERMISSION_STRING)) && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to get Siddhi App" + appName)).build();
        }
        return this.siddhiAppsAppNameGet(appName);
    }

    @Override
    public Response siddhiAppsAppNameStatusGet(String appFileName, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, VIEW_SIDDHI_APP_PERMISSION_STRING)) && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to get status of the Siddhi App " + appFileName)).build();
        }
        return this.siddhiAppsAppNameStatusGet(appFileName);
    }

    @Override
    public Response siddhiAppsAppNameBackupPost(String appName, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to backup current state of the Siddhi App" + appName)).build();
        }
        return this.siddhiAppsAppNameBackupPost(appName);
    }

    @Override
    public Response siddhiAppsAppNameRestorePost(String appName, String revision, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to restore the Siddhi App" + appName)).build();
        }
        return this.siddhiAppsAppNameRestorePost(appName, revision);
    }

    @Override
    public Response siddhiAppsAppNameRevisionsDelete(String appName, String enabledRedeployment, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to delete the persistence store of Siddhi App " + appName)).build();
        }
        return this.siddhiAppsAppNamePersistenceDelete(appName, enabledRedeployment);
    }

    @Override
    public Response siddhiAppsRevisionsDelete(String enabledRedeployment, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to delete the persistence store of all Siddhi Apps").build();
        }
        return this.siddhiAppsRevisionsDelete(enabledRedeployment);
    }

    @Override
    public Response siddhiAppsStatisticsGet(String isActive, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, VIEW_SIDDHI_APP_PERMISSION_STRING)) && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to get the stats of Siddhi Apps").build();
        }
        return this.siddhiAppsStatisticsGet(isActive);
    }

    @Override
    public Response siddhiAppStatsEnable(String appFileName, boolean statsEnabled, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to enable/disable stats for Siddhi App" + appFileName)).build();
        }
        return this.siddhiAppStatsEnable(appFileName, statsEnabled);
    }

    @Override
    public Response siddhiAppsStatsEnable(boolean statsEnabled, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to enable/disable stats for all Siddhi App").build();
        }
        return this.siddhiAppsStatsEnable(statsEnabled);
    }

    @Override
    public Response siddhiAppsElementsGet(String appName, Request request) throws NotFoundException {
        if (SiddhiAppsApiServiceImpl.getUserName(request) != null && !this.getPermissionProvider().hasPermission(SiddhiAppsApiServiceImpl.getUserName(request), new Permission(PERMISSION_APP_NAME, MANAGE_SIDDHI_APP_PERMISSION_STRING))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to enable/disable stats for all Siddhi App").build();
        }
        return this.siddhiAppElementsGet(appName);
    }

    private PermissionProvider getPermissionProvider() {
        return StreamProcessorDataHolder.getPermissionProvider();
    }
}

