/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal;

import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.common.common.exception.ResourceNotFoundException;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class CarbonEventStreamService
implements EventStreamService {
    private static Logger log = LoggerFactory.getLogger(CarbonEventStreamService.class);

    public List<String> getStreamNames(String sidhhiAppName) {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        SiddhiAppRuntime siddhiAppRuntime = siddhiAppMap.get(sidhhiAppName).getSiddhiAppRuntime();
        if (siddhiAppRuntime != null) {
            if (siddhiAppRuntime.getStreamDefinitionMap().size() != 0) {
                return new ArrayList<String>(siddhiAppRuntime.getStreamDefinitionMap().keySet());
            }
        } else {
            log.error("Siddhi App with name : " + sidhhiAppName + " is not available");
        }
        return null;
    }

    public List<Attribute> getStreamAttributes(String siddhiAppName, String streamName) throws ResourceNotFoundException {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        SiddhiAppRuntime siddhiAppRuntime = siddhiAppMap.get(siddhiAppName).getSiddhiAppRuntime();
        if (siddhiAppRuntime != null) {
            if (siddhiAppRuntime.getStreamDefinitionMap().containsKey(streamName)) {
                return ((StreamDefinition)siddhiAppRuntime.getStreamDefinitionMap().get(streamName)).getAttributeList();
            }
            throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not contain stream '" + streamName + "'.", ResourceNotFoundException.ResourceType.STREAM_NAME, streamName);
        }
        throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not exist.", ResourceNotFoundException.ResourceType.SIDDHI_APP_NAME, siddhiAppName);
    }

    public void pushEvent(String siddhiAppName, String streamName, Event event) {
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        Map<String, InputHandler> inputHandlerMap = siddhiAppMap.get(siddhiAppName).getInputHandlerMap();
        if (inputHandlerMap != null) {
            InputHandler inputHandler = inputHandlerMap.get(streamName);
            try {
                inputHandler.send(event);
            }
            catch (InterruptedException e) {
                log.error("Error when pushing events to Siddhi engine ", (Throwable)e);
            }
        }
    }
}

