/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal;

import io.siddhi.distribution.common.common.SiddhiAppRuntimeService;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.SiddhiAppRuntime;

public class CarbonSiddhiAppRuntimeService
implements SiddhiAppRuntimeService {
    private static final Logger log = LoggerFactory.getLogger((String)CarbonSiddhiAppRuntimeService.class.getName());

    public Map<String, SiddhiAppRuntime> getActiveSiddhiAppRuntimes() {
        Map<String, SiddhiAppData> siddhiApps = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        HashMap<String, SiddhiAppRuntime> siddhiAppRuntimes = new HashMap<String, SiddhiAppRuntime>();
        for (Map.Entry<String, SiddhiAppData> entry : siddhiApps.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().isActive()) continue;
            siddhiAppRuntimes.put(entry.getKey(), entry.getValue().getSiddhiAppRuntime());
        }
        return siddhiAppRuntimes;
    }

    public void enableSiddhiAppStatistics(boolean statsEnabled) {
        Map<String, SiddhiAppRuntime> siddhiAppRuntimes = this.getActiveSiddhiAppRuntimes();
        for (Map.Entry<String, SiddhiAppRuntime> siddhiRuntimeEntry : siddhiAppRuntimes.entrySet()) {
            if ((!statsEnabled || siddhiRuntimeEntry.getValue().isStatsEnabled()) && (statsEnabled || !siddhiRuntimeEntry.getValue().isStatsEnabled())) continue;
            siddhiRuntimeEntry.getValue().enableStats(statsEnabled);
            if (!log.isDebugEnabled()) continue;
            log.debug("Stats has been sucessfull updated for siddhi app :" + siddhiRuntimeEntry.getKey());
        }
    }
}

