/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal;

import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.common.common.SiddhiAppRuntimeService;
import io.siddhi.distribution.common.common.utils.config.FileConfigManager;
import io.siddhi.distribution.core.DeploymentMode;
import io.siddhi.distribution.core.NodeInfo;
import io.siddhi.distribution.core.internal.CarbonEventStreamService;
import io.siddhi.distribution.core.internal.CarbonSiddhiAppRuntimeService;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.internal.StreamProcessorDeployer;
import io.siddhi.distribution.core.internal.StreamProcessorService;
import io.siddhi.distribution.core.internal.util.SiddhiAppProcessorConstants;
import io.siddhi.distribution.core.persistence.PersistenceManager;
import io.siddhi.distribution.core.persistence.beans.PersistenceConfigurations;
import io.siddhi.distribution.core.persistence.exception.PersistenceStoreConfigurationException;
import io.siddhi.distribution.metrics.core.SiddhiMetricsFactory;
import io.siddhi.distribution.metrics.core.internal.service.MetricsServiceComponent;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.permissions.PermissionManager;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.databridge.commons.ServerEventListener;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.util.SiddhiComponentActivator;
import org.wso2.siddhi.core.util.config.ConfigManager;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.statistics.StatisticsTrackerFactory;

@Component(name="siddhi-io-distribution-core-service", immediate=true)
public class ServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(ServiceComponent.class);
    private ServiceRegistration streamServiceRegistration;
    private ServiceRegistration siddhiAppRuntimeServiceRegistration;
    private ScheduledFuture<?> scheduledFuture = null;
    private ScheduledExecutorService scheduledExecutorService = null;
    private boolean serviceComponentActivated;

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        log.debug("Service Component is activated");
        String runningFileName = System.getProperty("file");
        ConfigProvider configProvider = StreamProcessorDataHolder.getInstance().getConfigProvider();
        StreamProcessorDataHolder.setStreamProcessorService(new StreamProcessorService());
        SiddhiManager siddhiManager = new SiddhiManager();
        FileConfigManager fileConfigManager = new FileConfigManager(configProvider);
        siddhiManager.setConfigManager((ConfigManager)fileConfigManager);
        PersistenceConfigurations persistenceConfigurations = (PersistenceConfigurations)configProvider.getConfigurationObject(PersistenceConfigurations.class);
        if (persistenceConfigurations != null && persistenceConfigurations.isEnabled()) {
            String persistenceStoreClassName = persistenceConfigurations.getPersistenceStore();
            try {
                if (Class.forName(persistenceStoreClassName).newInstance() instanceof PersistenceStore) {
                    PersistenceStore persistenceStore = (PersistenceStore)Class.forName(persistenceStoreClassName).newInstance();
                    persistenceStore.setProperties((Map)configProvider.getConfigurationObject("state.persistence"));
                    siddhiManager.setPersistenceStore(persistenceStore);
                } else if (Class.forName(persistenceStoreClassName).newInstance() instanceof IncrementalPersistenceStore) {
                    IncrementalPersistenceStore incrementalPersistenceStore = (IncrementalPersistenceStore)Class.forName(persistenceStoreClassName).newInstance();
                    incrementalPersistenceStore.setProperties((Map)configProvider.getConfigurationObject("state.persistence"));
                    siddhiManager.setIncrementalPersistenceStore(incrementalPersistenceStore);
                } else {
                    throw new PersistenceStoreConfigurationException("Persistence Store class with name " + persistenceStoreClassName + " is invalid. The given class has to implement either org.wso2.siddhi.core.util.persistence.PersistenceStore or org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore.");
                }
                if (log.isDebugEnabled()) {
                    log.debug(persistenceStoreClassName + " chosen as persistence store");
                }
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceStoreConfigurationException("Persistence Store class with name " + persistenceStoreClassName + " is invalid. ", e);
            }
            int persistenceInterval = persistenceConfigurations.getIntervalInMin();
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            if (persistenceInterval > 0) {
                this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(new PersistenceManager(), persistenceInterval, persistenceInterval, TimeUnit.MINUTES);
            }
            StreamProcessorDataHolder.setIsPersistenceEnabled(true);
            log.info("Periodic state persistence started with an interval of " + String.valueOf(persistenceInterval) + " using " + persistenceStoreClassName);
        } else if (log.isDebugEnabled()) {
            log.debug("Periodic persistence is disabled");
        }
        StatisticsConfiguration statisticsConfiguration = new StatisticsConfiguration((StatisticsTrackerFactory)new SiddhiMetricsFactory());
        siddhiManager.setStatisticsConfiguration(statisticsConfiguration);
        StreamProcessorDataHolder.setSiddhiManager(siddhiManager);
        if (runningFileName != null) {
            StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.RUN_FILE);
            if (runningFileName.trim().equals("")) {
                log.error("Error: Can't get target file to run. System property {} is not set.", (Object)"file");
                StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.ERROR);
                return;
            }
            File runningFile = new File(runningFileName);
            if (!runningFile.exists()) {
                log.error("Error: File " + runningFile.getName() + " not found in the given location.");
                StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.ERROR);
                return;
            }
            try {
                StreamProcessorDeployer.deploySiddhiQLFile(runningFile);
            }
            catch (Exception e) {
                StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.ERROR);
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
        } else {
            StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.SERVER);
        }
        if (log.isDebugEnabled()) {
            log.debug("Runtime mode is set to : " + (Object)((Object)StreamProcessorDataHolder.getInstance().getRuntimeMode()));
        }
        this.streamServiceRegistration = bundleContext.registerService(EventStreamService.class.getName(), (Object)new CarbonEventStreamService(), null);
        this.siddhiAppRuntimeServiceRegistration = bundleContext.registerService(SiddhiAppRuntimeService.class.getCanonicalName(), (Object)new CarbonSiddhiAppRuntimeService(), null);
        NodeInfo nodeInfo = new NodeInfo(DeploymentMode.SINGLE_NODE, ((CarbonConfiguration)configProvider.getConfigurationObject(CarbonConfiguration.class)).getId());
        bundleContext.registerService(NodeInfo.class.getName(), (Object)nodeInfo, null);
        StreamProcessorDataHolder.setNodeInfo(nodeInfo);
        StreamProcessorDataHolder.getInstance().setBundleContext(bundleContext);
        this.serviceComponentActivated = true;
    }

    @Deactivate
    protected void stop() throws Exception {
        log.debug("Service Component is deactivated");
        Map<String, SiddhiAppData> siddhiAppMap = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppMap();
        for (SiddhiAppData siddhiAppData : siddhiAppMap.values()) {
            if (siddhiAppData.getSiddhiAppRuntime() == null) continue;
            siddhiAppData.getSiddhiAppRuntime().shutdown();
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        this.streamServiceRegistration.unregister();
        this.siddhiAppRuntimeServiceRegistration.unregister();
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonRuntime")
    protected void setCarbonRuntime(CarbonRuntime carbonRuntime) {
        StreamProcessorDataHolder.getInstance().setCarbonRuntime(carbonRuntime);
    }

    protected void unsetCarbonRuntime(CarbonRuntime carbonRuntime) {
        StreamProcessorDataHolder.getInstance().setCarbonRuntime(null);
    }

    @Reference(name="siddhi.component.activator.service", service=SiddhiComponentActivator.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSiddhiComponentActivator")
    protected void setSiddhiComponentActivator(SiddhiComponentActivator siddhiComponentActivator) {
    }

    protected void unsetSiddhiComponentActivator(SiddhiComponentActivator siddhiComponentActivator) {
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        StreamProcessorDataHolder.getInstance().setConfigProvider(configProvider);
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        StreamProcessorDataHolder.getInstance().setConfigProvider(null);
    }

    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceListener")
    protected void registerDataSourceListener(DataSourceService dataSourceService) {
        StreamProcessorDataHolder.setDataSourceService(dataSourceService);
    }

    protected void unregisterDataSourceListener(DataSourceService dataSourceService) {
        StreamProcessorDataHolder.setDataSourceService(null);
    }

    @Reference(name="MetricsServiceComponent", service=MetricsServiceComponent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterMetricsManager")
    protected void registerMetricsManager(MetricsServiceComponent serviceComponent) {
    }

    protected void unregisterMetricsManager(MetricsServiceComponent serviceComponent) {
    }

    @Reference(name="permission-manager", service=PermissionManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetPermissionManager")
    protected void setPermissionManager(PermissionManager permissionManager) {
        StreamProcessorDataHolder.setPermissionProvider(permissionManager.getProvider());
    }

    protected void unsetPermissionManager(PermissionManager permissionManager) {
        StreamProcessorDataHolder.setPermissionProvider(null);
    }

    @Reference(name="org.wso2.carbon.databridge.commons.ServerEventListener", service=ServerEventListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterServerListener")
    protected void registerServerListener(ServerEventListener serverEventListener) {
        StreamProcessorDataHolder.setServerListener(serverEventListener);
        serverEventListener.start();
    }

    protected void unregisterServerListener(ServerEventListener serverEventListener) {
        StreamProcessorDataHolder.removeServerListener(serverEventListener);
    }
}

