/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal;

import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.common.common.SimulationDependencyListener;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.internal.exception.SiddhiAppAlreadyExistException;
import io.siddhi.distribution.core.internal.exception.SiddhiAppDeploymentException;
import io.siddhi.distribution.core.internal.util.SiddhiAppProcessorConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.ArtifactType;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.exception.CarbonDeploymentException;
import org.wso2.msf4j.MicroservicesServer;

@Component(name="stream-processor-deployer", immediate=true, service={Deployer.class})
public class StreamProcessorDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(StreamProcessorDeployer.class);
    private static ServerType serverType = ServerType.SP;
    private static boolean isAnalyticsEnabledOnSP = false;
    private static boolean apimAnalyticsEnabledOnSP = false;
    private static boolean eiAnalyticsEnabledOnSP = false;
    private ArtifactType artifactType = new ArtifactType((Object)"siddhi");
    private SimulationDependencyListener simulationDependencyListener;
    private URL directoryLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploySiddhiQLFile(File file) throws Exception {
        block17: {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                String siddhiAppFileName = file.getName();
                if (siddhiAppFileName.endsWith(".siddhi")) {
                    String siddhiAppFileNameWithoutExtension = StreamProcessorDeployer.getFileNameWithoutExtenson(siddhiAppFileName);
                    SiddhiAppType siddhiAppType = StreamProcessorDeployer.getArtifactType(siddhiAppFileNameWithoutExtension);
                    if (!StreamProcessorDeployer.isDeploymentAllowed(siddhiAppType)) {
                        return;
                    }
                    String siddhiApp = StreamProcessorDeployer.getStringFromInputStream(inputStream);
                    try {
                        String siddhiAppName = StreamProcessorDataHolder.getStreamProcessorService().getSiddhiAppName(siddhiApp);
                        if (siddhiAppFileNameWithoutExtension.equals(siddhiAppName)) {
                            StreamProcessorDataHolder.getStreamProcessorService().deploySiddhiApp(siddhiApp, siddhiAppName);
                            break block17;
                        }
                        throw new SiddhiAppDeploymentException("Siddhi App file name needs be identical with the name defined in the Siddhi App content");
                    }
                    catch (SiddhiAppAlreadyExistException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        SiddhiAppData siddhiAppData = new SiddhiAppData(siddhiApp, false);
                        StreamProcessorDataHolder.getStreamProcessorService().addSiddhiAppFile(siddhiAppFileNameWithoutExtension, siddhiAppData);
                        throw new SiddhiAppDeploymentException(e);
                    }
                }
                log.error("Error: File extension of file name " + siddhiAppFileName + " is not supported. Siddhi App only supports '" + ".siddhi" + "' .");
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        StreamProcessorDataHolder.getInstance().setRuntimeMode(SiddhiAppProcessorConstants.RuntimeMode.ERROR);
                        throw new SiddhiAppDeploymentException("Error when closing the Siddhi QL file stream", e);
                    }
                }
            }
        }
    }

    private static String getStringFromInputStream(InputStream is) throws SiddhiAppDeploymentException {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = br.readLine()) != null) {
                sb.append(System.getProperty("line.separator")).append(line);
            }
        }
        catch (IOException e) {
            throw new SiddhiAppDeploymentException("Exception when reading the Siddhi QL file", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new SiddhiAppDeploymentException("Exception when closing the Siddhi QL file stream", e);
                }
            }
        }
        return sb.toString();
    }

    private static String getFileNameWithoutExtenson(String fileName) {
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    private static SiddhiAppType getArtifactType(String fileName) {
        if ((fileName = fileName.toUpperCase()).startsWith("APIM_")) {
            return SiddhiAppType.APIM;
        }
        if (fileName.startsWith("EI_")) {
            return SiddhiAppType.EI;
        }
        if (fileName.startsWith("IS_")) {
            return SiddhiAppType.IS;
        }
        return SiddhiAppType.OTHER;
    }

    private static boolean isDeploymentAllowed(SiddhiAppType siddhiAppType) {
        switch (serverType) {
            case SP: {
                switch (siddhiAppType) {
                    case OTHER: {
                        return true;
                    }
                    case APIM: {
                        if (!apimAnalyticsEnabledOnSP) break;
                        return true;
                    }
                    case IS: {
                        if (!isAnalyticsEnabledOnSP) break;
                        return true;
                    }
                    case EI: {
                        if (!eiAnalyticsEnabledOnSP) break;
                        return true;
                    }
                }
                break;
            }
            case APIM: {
                if (!siddhiAppType.name().equals(SiddhiAppType.APIM.name())) break;
                return true;
            }
            case IS: {
                if (!siddhiAppType.name().equals(SiddhiAppType.IS.name())) break;
                return true;
            }
            case EI: {
                if (!siddhiAppType.name().equals(SiddhiAppType.EI.name())) break;
                return true;
            }
        }
        return false;
    }

    private void setServerType() {
        block21: {
            ConfigProvider configProvider = StreamProcessorDataHolder.getInstance().getConfigProvider();
            if (configProvider != null) {
                try {
                    String type = (String)((Map)configProvider.getConfigurationObject("wso2.carbon")).get("type");
                    if (type == null) break block21;
                    switch (type) {
                        case "wso2-sp": {
                            serverType = ServerType.SP;
                            break;
                        }
                        case "wso2-apim-analytics": {
                            serverType = ServerType.APIM;
                            break;
                        }
                        case "wso2-is-analytics": {
                            serverType = ServerType.IS;
                            break;
                        }
                        case "wso2-ei-analytics": {
                            serverType = ServerType.EI;
                            break;
                        }
                        default: {
                            serverType = ServerType.SP;
                        }
                    }
                    try {
                        LinkedHashMap analyticsSolutionsMap;
                        if (serverType.name().equals(ServerType.SP.name()) && (analyticsSolutionsMap = (LinkedHashMap)configProvider.getConfigurationObject("analytics.solutions")) != null) {
                            Object directoryPathObject = analyticsSolutionsMap.get("IS-analytics.enabled");
                            if (directoryPathObject != null) {
                                isAnalyticsEnabledOnSP = Boolean.parseBoolean(directoryPathObject.toString());
                            }
                            if ((directoryPathObject = analyticsSolutionsMap.get("APIM-analytics.enabled")) != null) {
                                apimAnalyticsEnabledOnSP = Boolean.parseBoolean(directoryPathObject.toString());
                            }
                            if ((directoryPathObject = analyticsSolutionsMap.get("EI-analytics.enabled")) != null) {
                                eiAnalyticsEnabledOnSP = Boolean.parseBoolean(directoryPathObject.toString());
                            }
                        }
                    }
                    catch (ConfigurationException e) {
                        log.error("Failed to read analytics.solutions'property from the deployment.yaml file. None of the analytics solutions will be deployed. ", (Throwable)e);
                    }
                }
                catch (ConfigurationException e) {
                    log.error("Failed to read the wso2.carbon server type'property from the deployment.yaml file. Default value " + serverType.name() + " will be set.", (Throwable)e);
                }
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
    }

    public void init() {
        try {
            this.directoryLocation = new URL("file:siddhi-files");
            this.setServerType();
            log.debug("Stream Processor Deployer initiated.");
        }
        catch (MalformedURLException e) {
            log.error("Error while initializing directoryLocationsiddhi-files", (Throwable)e);
        }
    }

    public Object deploy(Artifact artifact) throws CarbonDeploymentException {
        if (StreamProcessorDataHolder.getInstance().getRuntimeMode().equals((Object)SiddhiAppProcessorConstants.RuntimeMode.SERVER)) {
            try {
                StreamProcessorDeployer.deploySiddhiQLFile(artifact.getFile());
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        this.broadcastDeploy();
        return artifact.getFile().getName();
    }

    public void undeploy(Object key) throws CarbonDeploymentException {
        if (StreamProcessorDataHolder.getInstance().getRuntimeMode().equals((Object)SiddhiAppProcessorConstants.RuntimeMode.SERVER)) {
            StreamProcessorDataHolder.getStreamProcessorService().undeploySiddhiApp(StreamProcessorDeployer.getFileNameWithoutExtenson((String)key));
        }
        this.broadcastDelete();
    }

    public Object update(Artifact artifact) throws CarbonDeploymentException {
        if (StreamProcessorDataHolder.getInstance().getRuntimeMode().equals((Object)SiddhiAppProcessorConstants.RuntimeMode.SERVER)) {
            StreamProcessorDataHolder.getStreamProcessorService().undeploySiddhiApp(StreamProcessorDeployer.getFileNameWithoutExtenson(artifact.getName()));
            try {
                StreamProcessorDeployer.deploySiddhiQLFile(artifact.getFile());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.broadcastUpdate();
        return artifact.getName();
    }

    public URL getLocation() {
        return this.directoryLocation;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    private void broadcastDeploy() {
        if (this.simulationDependencyListener != null) {
            this.simulationDependencyListener.onDeploy();
        }
    }

    private void broadcastUpdate() {
        if (this.simulationDependencyListener != null) {
            this.simulationDependencyListener.onUpdate();
        }
    }

    private void broadcastDelete() {
        if (this.simulationDependencyListener != null) {
            this.simulationDependencyListener.onDelete();
        }
    }

    @Reference(name="io.siddhi.distribution.common.common.EventStreamService", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetGreeterService")
    protected void setGreeterService(EventStreamService eventStreamService) {
    }

    protected void unsetGreeterService(EventStreamService eventStreamService) {
    }

    @Reference(name="io.siddhi.distribution.common.common.SimulationDependencyListener", service=SimulationDependencyListener.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsubscribeFromListener")
    protected void subscribeToListener(SimulationDependencyListener simulationDependencyListener) {
        this.simulationDependencyListener = simulationDependencyListener;
    }

    protected void unsubscribeFromListener(SimulationDependencyListener simulationDependencyListener) {
        this.simulationDependencyListener = null;
    }

    @Reference(service=MicroservicesServer.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMicroservicesServer")
    protected void setMicroservicesServer(MicroservicesServer microservicesServer) {
        if (log.isDebugEnabled()) {
            log.debug("@(bind) MicroservicesServer ");
        }
    }

    protected void unsetMicroservicesServer(MicroservicesServer microservicesServer) {
        if (log.isDebugEnabled()) {
            log.debug(" @(unbind) MicroservicesServer ");
        }
    }

    public static enum ServerType {
        EI,
        IS,
        APIM,
        SP;

    }

    public static enum SiddhiAppType {
        EI,
        IS,
        APIM,
        OTHER;

    }
}

