/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal;

import io.siddhi.distribution.core.distribution.DistributionService;
import io.siddhi.distribution.core.internal.SiddhiAppData;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.internal.exception.SiddhiAppAlreadyExistException;
import io.siddhi.distribution.core.internal.exception.SiddhiAppConfigurationException;
import io.siddhi.distribution.core.internal.exception.SiddhiAppDeploymentException;
import io.siddhi.distribution.core.internal.util.SiddhiAppFilesystemInvoker;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class StreamProcessorService {
    private static final Logger log = LoggerFactory.getLogger(StreamProcessorService.class);
    private Map<String, SiddhiAppData> siddhiAppMap = new ConcurrentHashMap<String, SiddhiAppData>();
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private DistributionService distributionService = StreamProcessorDataHolder.getDistributionService();

    public void deploySiddhiApp(String siddhiAppContent, String siddhiAppName) throws SiddhiAppConfigurationException, SiddhiAppAlreadyExistException, ConnectionUnavailableException {
        SiddhiAppData siddhiAppData = new SiddhiAppData(siddhiAppContent);
        boolean persistenceStoreClearEnabled = Boolean.valueOf(System.getProperty("persistenceStoreClearEnabled"));
        String siddhiApp = System.getProperty("siddhiApp");
        if (this.siddhiAppMap.containsKey(siddhiAppName)) {
            throw new SiddhiAppAlreadyExistException("There is a Siddhi App with name " + siddhiAppName + " is already exist");
        }
        SiddhiManager siddhiManager = StreamProcessorDataHolder.getSiddhiManager();
        SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiAppContent);
        Set streamNames = siddhiAppRuntime.getStreamDefinitionMap().keySet();
        ConcurrentHashMap<String, InputHandler> inputHandlerMap = new ConcurrentHashMap<String, InputHandler>(streamNames.size());
        for (String streamName : streamNames) {
            inputHandlerMap.put(streamName, siddhiAppRuntime.getInputHandler(streamName));
        }
        if (StreamProcessorDataHolder.isPersistenceEnabled()) {
            log.info("Periodic State persistence enabled. Restoring last persisted state of " + siddhiAppName);
            String revision = null;
            if (persistenceStoreClearEnabled) {
                if (siddhiApp != null) {
                    if (siddhiApp.equals(siddhiAppName)) {
                        siddhiAppRuntime.clearAllRevisions();
                        log.info("Deleting all the revisions of the Periodic Persistence of Active Node for " + siddhiAppName);
                    }
                } else {
                    log.info("Deleting all the revisions of the Periodic Persistence of Active Node for " + siddhiAppName);
                    siddhiAppRuntime.clearAllRevisions();
                }
            } else {
                try {
                    revision = siddhiAppRuntime.restoreLastRevision();
                }
                catch (CannotRestoreSiddhiAppStateException e) {
                    log.error("Error in restoring Siddhi app " + siddhiAppRuntime.getName(), (Throwable)e);
                }
                if (revision != null) {
                    log.info("Siddhi App " + siddhiAppName + " restored to revision " + revision);
                }
            }
        }
        siddhiAppRuntime.start();
        log.info("Siddhi App " + siddhiAppName + " deployed successfully");
        siddhiAppData.setActive(true);
        siddhiAppData.setSiddhiAppRuntime(siddhiAppRuntime);
        siddhiAppData.setInputHandlerMap(inputHandlerMap);
        siddhiAppData.setDeploymentTime(System.currentTimeMillis());
        this.siddhiAppMap.put(siddhiAppName, siddhiAppData);
    }

    public void undeploySiddhiApp(String siddhiAppName) {
        if (this.siddhiAppMap.containsKey(siddhiAppName)) {
            SiddhiAppData siddhiAppData = this.siddhiAppMap.get(siddhiAppName);
            if (siddhiAppData != null && siddhiAppData.isActive()) {
                siddhiAppData.getSiddhiAppRuntime().shutdown();
            }
            this.siddhiAppMap.remove(siddhiAppName);
            log.info("Siddhi App File " + siddhiAppName + " undeployed successfully.");
        }
    }

    public boolean delete(String siddhiAppName) throws SiddhiAppConfigurationException, SiddhiAppDeploymentException {
        if (this.siddhiAppMap.containsKey(siddhiAppName)) {
            SiddhiAppFilesystemInvoker.delete(siddhiAppName);
            return true;
        }
        return false;
    }

    public String validateAndSave(String siddhiApp, boolean isUpdate) throws SiddhiAppConfigurationException, SiddhiAppDeploymentException {
        String siddhiAppName = "";
        try {
            SiddhiManager siddhiManager;
            SiddhiAppRuntime siddhiAppRuntime;
            siddhiAppName = this.getSiddhiAppName(siddhiApp);
            if ((isUpdate || !this.siddhiAppMap.containsKey(siddhiAppName)) && (siddhiAppRuntime = (siddhiManager = StreamProcessorDataHolder.getSiddhiManager()).createSiddhiAppRuntime(siddhiApp)) != null) {
                SiddhiAppFilesystemInvoker.save(siddhiApp, siddhiAppName);
                return siddhiAppName;
            }
        }
        catch (SiddhiAppDeploymentException e) {
            log.error("Exception occurred when saving Siddhi App : " + siddhiAppName, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error("Exception occurred when validating Siddhi App " + siddhiAppName, e);
            throw new SiddhiAppConfigurationException(e);
        }
        return null;
    }

    public String getSiddhiAppName(String siddhiApp) throws SiddhiAppConfigurationException {
        try {
            SiddhiApp parsedSiddhiApp = SiddhiCompiler.parse((String)siddhiApp);
            Element nameAnnotation = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedSiddhiApp.getAnnotations());
            if (nameAnnotation == null || nameAnnotation.getValue().isEmpty()) {
                throw new SiddhiAppConfigurationException("Siddhi App name must be provided as @App:name('name').");
            }
            return nameAnnotation.getValue();
        }
        catch (Throwable e) {
            throw new SiddhiAppConfigurationException("Exception occurred when retrieving Siddhi App Name ", e);
        }
    }

    public boolean isExists(String siddhiApp) throws SiddhiAppConfigurationException {
        return this.siddhiAppMap.containsKey(this.getSiddhiAppName(siddhiApp));
    }

    public void addSiddhiAppFile(String siddhiAppName, SiddhiAppData siddhiAppData) {
        this.siddhiAppMap.put(siddhiAppName, siddhiAppData);
    }

    public Map<String, SiddhiAppData> getSiddhiAppMap() {
        return this.siddhiAppMap;
    }
}

