/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.internal.util;

import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.internal.exception.SiddhiAppConfigurationException;
import io.siddhi.distribution.core.internal.exception.SiddhiAppDeploymentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.utils.Utils;

public class SiddhiAppFilesystemInvoker {
    private static final Log log = LogFactory.getLog(SiddhiAppFilesystemInvoker.class);
    private static String directoryPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(String siddhiApp, String siddhiAppName) throws SiddhiAppConfigurationException, SiddhiAppDeploymentException {
        SiddhiAppFilesystemInvoker.validatePath(siddhiAppName);
        String filePath = SiddhiAppFilesystemInvoker.getFilePathFromFilename(siddhiAppName);
        try {
            OutputStreamWriter writer = null;
            try {
                File file = new File(filePath);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                writer.write(siddhiApp);
                log.info((Object)("Siddhi App: " + siddhiAppName + " saved in the filesystem"));
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new SiddhiAppDeploymentException("Error while saving the Siddhi App : " + siddhiAppName, e);
        }
    }

    public static boolean delete(String siddhiAppName) throws SiddhiAppConfigurationException, SiddhiAppDeploymentException {
        try {
            SiddhiAppFilesystemInvoker.validatePath(siddhiAppName);
            String filePath = SiddhiAppFilesystemInvoker.getFilePathFromFilename(siddhiAppName);
            File file = new File(filePath);
            if (file.exists()) {
                boolean fileDeleted = file.delete();
                if (!fileDeleted) {
                    log.error((Object)("Could not delete " + siddhiAppName));
                    return false;
                }
                log.info((Object)(siddhiAppName + " is deleted from the file system"));
                return true;
            }
        }
        catch (Exception e) {
            throw new SiddhiAppDeploymentException("Error while deleting the Siddhi App : " + siddhiAppName, e);
        }
        return false;
    }

    private static void validatePath(String fileName) throws SiddhiAppConfigurationException {
        if (fileName.contains("../") || fileName.contains("..\\")) {
            throw new SiddhiAppConfigurationException("File name contains restricted path elements. : " + fileName);
        }
    }

    private static String getFilePathFromFilename(String fileName) throws SiddhiAppDeploymentException {
        ConfigProvider configProvider = StreamProcessorDataHolder.getInstance().getConfigProvider();
        if (directoryPath == null && configProvider != null) {
            try {
                Object directoryPathObject;
                LinkedHashMap wso2ArtifactDeploymentMap = (LinkedHashMap)configProvider.getConfigurationObject("wso2.artifact.deployment");
                if (wso2ArtifactDeploymentMap != null && (directoryPathObject = wso2ArtifactDeploymentMap.get("repositoryLocation")) != null) {
                    directoryPath = directoryPathObject.toString();
                }
            }
            catch (ConfigurationException e) {
                throw new SiddhiAppDeploymentException("Exception occurred when deriving the WSO2 deployment directory folder path", e);
            }
        }
        if (directoryPath == null) {
            directoryPath = Utils.getRuntimePath() + File.separator + "deployment" + File.separator + "siddhi-files";
        }
        return directoryPath + File.separator + fileName + ".siddhi";
    }
}

