/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence;

import com.zaxxer.hikari.HikariDataSource;
import io.siddhi.distribution.core.impl.utils.CompressionUtil;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.persistence.dto.RDBMSQueryConfigurationEntry;
import io.siddhi.distribution.core.persistence.exception.DatasourceConfigurationException;
import io.siddhi.distribution.core.persistence.util.DBPersistenceStoreUtils;
import io.siddhi.distribution.core.persistence.util.ExecutionInfo;
import io.siddhi.distribution.core.persistence.util.RDBMSConfiguration;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.log4j.Logger;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.siddhi.core.exception.CannotClearSiddhiAppStateException;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class DBPersistenceStore
implements PersistenceStore {
    private static final Logger log = Logger.getLogger(DBPersistenceStore.class);
    private static final String MSSQL_DATABASE_TYPE = "microsoft sql server";
    private static final String POSTGRES_DATABASE_TYPE = "postgresql";
    private ExecutionInfo executionInfo;
    private String datasourceName;
    private DataSource datasource;
    private String tableName;
    private int numberOfRevisionsToKeep;
    private String databaseType;
    private String databaseVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String siddhiAppName, String revision, byte[] snapshot) {
        PreparedStatement stmt;
        Connection con;
        block11: {
            byte[] compressedSnapshot;
            this.createTableIfNotExist();
            try {
                compressedSnapshot = CompressionUtil.compressGZIP(snapshot);
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while trying to compress the snapshot. Failed to persist revision: " + revision + " of Siddhi app: " + siddhiAppName));
                return;
            }
            con = null;
            stmt = null;
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " while saving revision " + revision), (Throwable)e);
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                return;
            }
            try {
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
                stmt.setString(1, siddhiAppName);
                stmt.setString(2, revision);
                if (this.databaseType.equals(POSTGRES_DATABASE_TYPE)) {
                    stmt.setBlob(3, new SerialBlob(compressedSnapshot));
                } else {
                    Blob blob = con.createBlob();
                    blob.setBytes(1L, compressedSnapshot);
                    stmt.setBlob(3, blob);
                }
                stmt.executeUpdate();
                con.commit();
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)("Periodic persistence of " + siddhiAppName + " persisted successfully."));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Error while saving revision" + revision + " of the siddhiApp " + siddhiAppName + " to the database with datasource name " + this.datasourceName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                    throw throwable;
                }
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
            }
        }
        DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        this.cleanOldRevisions(siddhiAppName);
    }

    public void setProperties(Map properties) {
        Map configurationMap = (Map)properties.get("config");
        Object numberOfRevisionsObject = properties.get("revisionsToKeep");
        if (numberOfRevisionsObject == null || !(numberOfRevisionsObject instanceof Integer)) {
            this.numberOfRevisionsToKeep = 3;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Number of revisions to keep is not set or invalid. Default value will be used.");
            }
        } else {
            this.numberOfRevisionsToKeep = (Integer)numberOfRevisionsObject;
        }
        if (configurationMap != null) {
            Object datasourceObject = configurationMap.get("datasource");
            Object tableObject = configurationMap.get("table");
            if (datasourceObject == null || !(datasourceObject instanceof String)) {
                this.datasourceName = "WSO2_CARBON_DB";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"datasource for database system persistence not set. Default datasource will be used.");
                }
            } else {
                this.datasourceName = String.valueOf(datasourceObject);
            }
            if (tableObject == null || !(tableObject instanceof String)) {
                this.tableName = "PERSISTENCE_TABLE";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Table name for database system persistence not set. Default table name will be used.");
                }
            } else {
                this.tableName = String.valueOf(tableObject);
            }
        } else {
            this.datasourceName = "WSO2_CARBON_DB";
            this.tableName = "PERSISTENCE_TABLE";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Database system persistence config not set. Default config values will be used.");
            }
        }
        try {
            this.datasource = (HikariDataSource)StreamProcessorDataHolder.getDataSourceService().getDataSource(this.datasourceName);
            try (Connection connection = this.datasource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                this.databaseType = metaData.getDatabaseProductName().toLowerCase();
                this.databaseVersion = metaData.getDatabaseProductVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Datasource connected to database: " + this.databaseType + " " + this.databaseVersion));
                }
            }
        }
        catch (DataSourceException e) {
            throw new DatasourceConfigurationException("Datasource " + this.datasourceName + " is not defined to use for snapshot persistence.", e);
        }
        catch (SQLException e) {
            throw new DatasourceConfigurationException("Connection cannot be established for datasource " + this.datasourceName, e);
        }
        this.initializeDatabaseExecutionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] load(String siddhiAppName, String revision) {
        PreparedStatement stmt = null;
        Connection con = null;
        byte[] blobAsBytes = null;
        byte[] decompressedSnapshot = null;
        try {
            con = this.datasource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " while loading revision " + revision), (Throwable)e);
            byte[] byArray = null;
            this.cleanupConnections(stmt, con);
            return byArray;
        }
        try {
            block21: {
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.executionInfo.getPreparedSelectStatement());
                stmt.setString(1, revision);
                stmt.setString(2, siddhiAppName);
                try (ResultSet resultSet = stmt.executeQuery();){
                    con.commit();
                    if (!resultSet.next()) break block21;
                    Blob blobSnapshot = this.databaseType.equals(MSSQL_DATABASE_TYPE) ? new SerialBlob(resultSet.getBytes("snapshot")) : resultSet.getBlob("snapshot");
                    int blobLength = (int)blobSnapshot.length();
                    blobAsBytes = blobSnapshot.getBytes(1L, blobLength);
                    try {
                        decompressedSnapshot = CompressionUtil.decompressGZIP(blobAsBytes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error occurred while trying to decompress the snapshot. Failed to load revision: " + revision + " of Siddhi app: " + siddhiAppName, e);
                    }
                }
            }
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error while retrieving revision " + revision + " of siddhiApp: " + siddhiAppName + " from the database with datasource " + this.datasourceName), (Throwable)e);
                this.cleanupConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
        return decompressedSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastRevision(String siddhiAppName) {
        this.createTableIfNotExist();
        PreparedStatement stmt = null;
        Connection con = null;
        String revision = null;
        try {
            con = this.datasource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " while trying retrieve last revision of " + siddhiAppName), (Throwable)e);
            String string = null;
            this.cleanupConnections(stmt, con);
            return string;
        }
        try {
            stmt = con.prepareStatement(this.executionInfo.getPreparedSelectLastStatement());
            stmt.setString(1, siddhiAppName);
            try (ResultSet resultSet = stmt.executeQuery();){
                if (resultSet.next()) {
                    revision = String.valueOf(resultSet.getString("revision"));
                }
            }
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error while retrieving last revision of siddhiApp: " + siddhiAppName + "from the database with datasource " + this.datasourceName), (Throwable)e);
                this.cleanupConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
        return revision;
    }

    private void initializeDatabaseExecutionInfo() {
        this.executionInfo = new ExecutionInfo();
        RDBMSQueryConfigurationEntry databaseQueryEntries = RDBMSConfiguration.getInstance().getDatabaseQueryEntries(this.databaseType, this.databaseVersion, this.tableName);
        this.executionInfo.setPreparedInsertStatement(databaseQueryEntries.getInsertTableQuery());
        this.executionInfo.setPreparedCreateTableStatement(databaseQueryEntries.getCreateTableQuery());
        this.executionInfo.setPreparedTableExistenceCheckStatement(databaseQueryEntries.getIsTableExistQuery());
        this.executionInfo.setPreparedSelectStatement(databaseQueryEntries.getSelectTableQuery());
        this.executionInfo.setPreparedSelectLastStatement(databaseQueryEntries.getSelectLastQuery());
        this.executionInfo.setPreparedSelectRevisionsStatement(databaseQueryEntries.getSelectRevisionsQuery());
        this.executionInfo.setPreparedDeleteStatement(databaseQueryEntries.getDeleteQuery());
        this.executionInfo.setPreparedDeleteOldRevisionsStatement(databaseQueryEntries.getDeleteOldRevisionsQuery());
        this.executionInfo.setPreparedCountStatement(databaseQueryEntries.getCountQuery());
        this.executionInfo.setPreparedDeleteAllRevisionsStatement(databaseQueryEntries.getDeleteAllRevisionsQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExist() {
        if (!this.executionInfo.isTableExist()) {
            Statement stmt = null;
            Connection con = null;
            try {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.createStatement();
                }
                catch (SQLException e) {
                    log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " when checking persistence table exists"), (Throwable)e);
                    this.cleanupConnections(stmt, con);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
            try (ResultSet ignored = stmt.executeQuery(this.executionInfo.getPreparedTableExistenceCheckStatement());){
                this.executionInfo.setTableExist(true);
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table " + this.tableName + " does not Exist. Table Will be created. "));
                }
                this.cleanupConnections(stmt, con);
                try {
                    con = this.datasource.getConnection();
                    stmt = con.createStatement();
                    con.setAutoCommit(false);
                    stmt.executeUpdate(this.executionInfo.getPreparedCreateTableStatement());
                    con.commit();
                    this.executionInfo.setTableExist(true);
                }
                catch (SQLException ex) {
                    log.error((Object)("Could not create table " + this.tableName + " using datasource " + this.datasourceName), (Throwable)ex);
                }
            }
            this.cleanupConnections(stmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldRevisions(String siddhiAppName) {
        PreparedStatement stmt = null;
        Connection con = null;
        int count = 0;
        try {
            con = this.datasource.getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to data source " + this.datasourceName + " to clean old revisions"), (Throwable)e);
            return;
        }
        try {
            stmt = con.prepareStatement(this.executionInfo.getPreparedCountStatement());
            stmt.setString(1, siddhiAppName);
            try (ResultSet resultSet = stmt.executeQuery();){
                int numberOfRevisionsToClean;
                if (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                if ((numberOfRevisionsToClean = count - this.numberOfRevisionsToKeep) > 0) {
                    stmt = con.prepareStatement(this.executionInfo.getPreparedDeleteStatement());
                    if (this.databaseType.equals(MSSQL_DATABASE_TYPE)) {
                        stmt.setInt(1, numberOfRevisionsToClean);
                        stmt.setString(2, siddhiAppName);
                    } else {
                        stmt.setString(1, siddhiAppName);
                        stmt.setInt(2, numberOfRevisionsToClean);
                    }
                    stmt.executeUpdate();
                    con.commit();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error in cleaning old revisions of siddhiApp: " + siddhiAppName + "from the database with datasource " + this.datasourceName), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error((Object)("Unable to close statement." + e.getMessage()), (Throwable)e);
                }
            }
            this.cleanupConnections(stmt, con);
        }
    }

    public void clearAllRevisions(String siddhiAppName) {
        Connection con;
        PreparedStatement stmt = null;
        try {
            con = this.datasource.getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to data source " + this.datasourceName + " to delete the persistence store"), (Throwable)e);
            throw new CannotClearSiddhiAppStateException("Cannot establish connection to data source " + this.datasourceName + " when deleting the revisions of the persistence store of SiddhiApp: " + siddhiAppName, (Throwable)e);
        }
        try {
            stmt = con.prepareStatement(this.executionInfo.getPreparedDeleteAllRevisionsStatement());
            stmt.setString(1, siddhiAppName);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error in deleting all the revisions of the persistence store of siddhiApp: " + siddhiAppName + " from the database with datasource " + this.datasourceName), (Throwable)e);
            throw new CannotClearSiddhiAppStateException("Error in deleting all the revisions of the persistence store of SiddhiApp: " + siddhiAppName + " from the database with datasource " + this.datasourceName, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error((Object)("Unable to close statement. " + e.getMessage()), (Throwable)e);
                }
            }
            this.cleanupConnections(stmt, con);
        }
    }

    private void cleanupConnections(Statement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)("Unable to close statement." + e.getMessage()), (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Unable to close connection." + e.getMessage()), (Throwable)e);
            }
        }
    }
}

