/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence;

import com.google.common.io.Files;
import io.siddhi.distribution.core.impl.utils.CompressionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.exception.CannotClearSiddhiAppStateException;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class FileSystemPersistenceStore
implements PersistenceStore {
    private static final Logger log = Logger.getLogger(FileSystemPersistenceStore.class);
    private int numberOfRevisionsToSave;
    private String folder;

    public void save(String siddhiAppName, String revision, byte[] snapshot) {
        byte[] compressedSnapshot;
        File file = new File(this.folder + File.separator + siddhiAppName + File.separator + revision);
        try {
            compressedSnapshot = CompressionUtil.compressGZIP(snapshot);
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while trying to compress the snapshot. Failed to persist revision: " + revision + " of Siddhi app: " + siddhiAppName));
            return;
        }
        try {
            Files.createParentDirs((File)file);
            Files.write((byte[])compressedSnapshot, (File)file);
            this.cleanOldRevisions(siddhiAppName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Periodic persistence of " + siddhiAppName + " persisted successfully."));
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot save the revision " + revision + " of SiddhiApp: " + siddhiAppName + " to the file system."), (Throwable)e);
        }
    }

    public void setProperties(Map properties) {
        Map configurationMap = (Map)properties.get("config");
        Object numberOfRevisionsObject = properties.get("revisionsToKeep");
        if (numberOfRevisionsObject == null || !(numberOfRevisionsObject instanceof Integer)) {
            this.numberOfRevisionsToSave = 3;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Number of revisions to keep is not set or invalid. Default value will be used.");
            }
        } else {
            this.numberOfRevisionsToSave = Integer.parseInt(String.valueOf(numberOfRevisionsObject));
        }
        if (configurationMap != null) {
            Object folderObject = configurationMap.get("location");
            if (folderObject == null || !(folderObject instanceof String)) {
                this.folder = "siddhi-app-persistence";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"File system persistence location not set. Default persistence location will be used.");
                }
            } else {
                this.folder = String.valueOf(folderObject);
            }
        } else {
            this.folder = "siddhi-app-persistence";
            if (log.isDebugEnabled()) {
                log.debug((Object)"File system persistence config not set. Default persistence location will be used.");
            }
        }
    }

    public byte[] load(String siddhiAppName, String revision) {
        File file = new File(this.folder + File.separator + siddhiAppName + File.separator + revision);
        try {
            byte[] decompressedSnapshot;
            byte[] bytes = Files.toByteArray((File)file);
            log.info((Object)("State loaded for " + siddhiAppName + " revision " + revision + " from the file system."));
            try {
                decompressedSnapshot = CompressionUtil.decompressGZIP(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while trying to decompress the snapshot. Failed to load revision: " + revision + " of Siddhi app: " + siddhiAppName, e);
            }
            return decompressedSnapshot;
        }
        catch (IOException e) {
            log.error((Object)("Cannot load the revision " + revision + " of SiddhiApp: " + siddhiAppName + " from file system."), (Throwable)e);
            return null;
        }
    }

    public String getLastRevision(String siddhiAppName) {
        File dir = new File(this.folder + File.separator + siddhiAppName);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        String lastRevision = null;
        for (File file : files) {
            String fileName = file.getName();
            if (lastRevision != null && fileName.compareTo(lastRevision) <= 0) continue;
            lastRevision = fileName;
        }
        return lastRevision;
    }

    public void clearAllRevisions(String siddhiAppName) {
        File targetDirectory = new File(this.folder + File.separator + siddhiAppName);
        File[] files = targetDirectory.listFiles();
        if (files == null || files.length == 0) {
            log.info((Object)("No revisions were found to delete for the Siddhi App " + siddhiAppName));
            return;
        }
        for (File file : files) {
            if (!file.exists() || file.delete()) continue;
            log.error((Object)("file is not deleted successfully : " + file.getName()));
            throw new CannotClearSiddhiAppStateException("Persistence state file is not deleted : " + file.getPath() + file.getName());
        }
    }

    private void cleanOldRevisions(String siddhiAppName) {
        File targetDirectory = new File(this.folder + File.separator + siddhiAppName);
        File[] files = targetDirectory.listFiles();
        if (files != null) {
            while (files.length > this.numberOfRevisionsToSave) {
                Boolean isDeleted;
                String firstRevision = null;
                for (File file : files) {
                    String fileName = file.getName();
                    if (firstRevision != null && fileName.compareTo(firstRevision) >= 0) continue;
                    firstRevision = fileName;
                }
                File fileToDelete = new File(targetDirectory + File.separator + firstRevision);
                if (fileToDelete.exists() && !(isDeleted = Boolean.valueOf(fileToDelete.delete())).booleanValue()) {
                    log.error((Object)("Error deleting old revision " + firstRevision));
                }
                if ((files = targetDirectory.listFiles()) != null && files.length >= 1) continue;
                break;
            }
        }
    }
}

