/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence;

import com.zaxxer.hikari.HikariDataSource;
import io.siddhi.distribution.core.impl.utils.CompressionUtil;
import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.persistence.dto.RDBMSQueryConfigurationEntry;
import io.siddhi.distribution.core.persistence.exception.DatasourceConfigurationException;
import io.siddhi.distribution.core.persistence.util.DBPersistenceStoreUtils;
import io.siddhi.distribution.core.persistence.util.ExecutionInfo;
import io.siddhi.distribution.core.persistence.util.RDBMSConfiguration;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.log4j.Logger;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.siddhi.core.exception.CannotClearSiddhiAppStateException;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import org.wso2.siddhi.core.util.persistence.util.PersistenceHelper;

public class IncrementalDBPersistenceStore
implements IncrementalPersistenceStore {
    private static final Logger log = Logger.getLogger(IncrementalDBPersistenceStore.class);
    private static final String MSSQL_DATABASE_TYPE = "microsoft sql server";
    private static final String POSTGRES_DATABASE_TYPE = "postgresql";
    private ExecutionInfo executionInfo;
    private String datasourceName;
    private DataSource datasource;
    private String databaseType;
    private String databaseVersion;
    private String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IncrementalSnapshotInfo incrementalSnapshotInfo, byte[] bytes) {
        PreparedStatement stmt;
        Connection con;
        block11: {
            byte[] compressedSnapshot;
            try {
                compressedSnapshot = CompressionUtil.compressGZIP(bytes);
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while trying to compress the snapshot. Failed to persist revision: " + incrementalSnapshotInfo.getRevision() + " of Siddhi app: " + incrementalSnapshotInfo.getSiddhiAppId()));
                return;
            }
            DBPersistenceStoreUtils.createTableIfNotExist(this.executionInfo, this.datasource, this.datasourceName, this.tableName);
            con = null;
            stmt = null;
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " while saving revision " + incrementalSnapshotInfo.getRevision()), (Throwable)e);
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                return;
            }
            try {
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
                stmt.setString(1, incrementalSnapshotInfo.getSiddhiAppId());
                stmt.setString(2, incrementalSnapshotInfo.getRevision());
                if (this.databaseType.equals(POSTGRES_DATABASE_TYPE)) {
                    stmt.setBlob(3, new SerialBlob(compressedSnapshot));
                } else {
                    Blob blob = con.createBlob();
                    blob.setBytes(1L, compressedSnapshot);
                    stmt.setBlob(3, blob);
                }
                stmt.executeUpdate();
                con.commit();
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)("Periodic persistence of " + incrementalSnapshotInfo.getSiddhiAppId() + " persisted successfully."));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Error while saving revision" + incrementalSnapshotInfo.getRevision() + " of the siddhiApp " + incrementalSnapshotInfo.getSiddhiAppId() + " to the database with datasource name " + this.datasourceName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                    throw throwable;
                }
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
            }
        }
        DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        this.cleanOldRevisions(incrementalSnapshotInfo);
    }

    public void setProperties(Map map) {
        Map configurationMap = (Map)map.get("config");
        if (configurationMap != null) {
            Object datasourceObject = configurationMap.get("datasource");
            Object tableObject = configurationMap.get("table");
            if (datasourceObject == null || !(datasourceObject instanceof String)) {
                this.datasourceName = "WSO2_CARBON_DB";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"datasource for database system persistence not set. Default datasource will be used.");
                }
            } else {
                this.datasourceName = String.valueOf(datasourceObject);
            }
            if (tableObject == null || !(tableObject instanceof String)) {
                this.tableName = "PERSISTENCE_TABLE";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Table name for database system persistence not set. Default table name will be used.");
                }
            } else {
                this.tableName = String.valueOf(tableObject);
            }
        } else {
            this.datasourceName = "WSO2_CARBON_DB";
            this.tableName = "PERSISTENCE_TABLE";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Database system persistence config not set. Default config values will be used.");
            }
        }
        try {
            this.datasource = (HikariDataSource)StreamProcessorDataHolder.getDataSourceService().getDataSource(this.datasourceName);
            try (Connection connection = this.datasource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                this.databaseType = metaData.getDatabaseProductName().toLowerCase();
                this.databaseVersion = metaData.getDatabaseProductVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Datasource connected to database: " + this.databaseType + " " + this.databaseVersion));
                }
            }
        }
        catch (DataSourceException e) {
            throw new DatasourceConfigurationException("Datasource " + this.datasourceName + " is not defined to use for snapshot persistence.", e);
        }
        catch (SQLException e) {
            throw new DatasourceConfigurationException("Connection cannot be established for datasource " + this.datasourceName, e);
        }
        this.initializeDatabaseExecutionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] load(IncrementalSnapshotInfo incrementalSnapshotInfo) {
        byte[] decompressedSnapshot;
        Connection con;
        PreparedStatement stmt;
        block21: {
            stmt = null;
            con = null;
            byte[] blobAsBytes = null;
            decompressedSnapshot = null;
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " while loading revision " + incrementalSnapshotInfo.getRevision()), (Throwable)e);
                byte[] byArray = null;
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                return byArray;
            }
            try {
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.executionInfo.getPreparedSelectStatement());
                stmt.setString(1, incrementalSnapshotInfo.getRevision());
                stmt.setString(2, incrementalSnapshotInfo.getSiddhiAppId());
                try (ResultSet resultSet = stmt.executeQuery();){
                    con.commit();
                    if (!resultSet.next()) break block21;
                    Blob blobSnapshot = this.databaseType.equals(MSSQL_DATABASE_TYPE) ? new SerialBlob(resultSet.getBytes("snapshot")) : resultSet.getBlob("snapshot");
                    int blobLength = (int)blobSnapshot.length();
                    blobAsBytes = blobSnapshot.getBytes(1L, blobLength);
                    try {
                        decompressedSnapshot = CompressionUtil.decompressGZIP(blobAsBytes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error occurred while trying to decompress the snapshot. Failed to load revision: " + incrementalSnapshotInfo.getRevision() + " of Siddhi app: " + incrementalSnapshotInfo.getSiddhiAppId(), e);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Error while retrieving revision " + incrementalSnapshotInfo.getRevision() + " of siddhiApp: " + incrementalSnapshotInfo.getSiddhiAppId() + " from the database with datasource " + this.datasourceName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                    throw throwable;
                }
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
            }
        }
        DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        return decompressedSnapshot;
    }

    public List<IncrementalSnapshotInfo> getListOfRevisionsToLoad(long restoreTime, String siddhiAppName) {
        ArrayList<IncrementalSnapshotInfo> results = new ArrayList<IncrementalSnapshotInfo>();
        List<String> revisions = this.getListOfRevisionsFromDB(siddhiAppName);
        for (String revision : revisions) {
            IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision((String)revision);
            if (snapshotInfo.getTime() > restoreTime || !siddhiAppName.equals(snapshotInfo.getSiddhiAppId()) || snapshotInfo.getElementId() == null || snapshotInfo.getQueryName() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("List of revisions to load : " + revision));
            }
            results.add(snapshotInfo);
        }
        return results;
    }

    public String getLastRevision(String siddhiAppName) {
        this.createTableIfNotExist();
        List<String> revisions = this.getListOfRevisionsFromDB(siddhiAppName);
        long restoreTime = -1L;
        IncrementalSnapshotInfo snapshotToLoad = null;
        for (String revision : revisions) {
            IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision((String)revision);
            if (snapshotInfo.getTime() <= restoreTime || !siddhiAppName.equals(snapshotInfo.getSiddhiAppId()) || snapshotInfo.getElementId() == null || snapshotInfo.getQueryName() == null) continue;
            restoreTime = snapshotInfo.getTime();
            snapshotToLoad = snapshotInfo;
        }
        if (restoreTime != -1L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Latest revision to load: " + restoreTime + "__" + siddhiAppName));
            }
            return restoreTime + "__" + siddhiAppName + "__" + snapshotToLoad.getQueryName() + "__" + snapshotToLoad.getElementId() + "__" + snapshotToLoad.getType();
        }
        return null;
    }

    public void clearAllRevisions(String siddhiAppName) {
        Connection con;
        PreparedStatement stmt = null;
        try {
            con = this.datasource.getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to data source " + this.datasourceName + " to clean all revisions"), (Throwable)e);
            throw new CannotClearSiddhiAppStateException("Cannot establish connection to data source " + this.datasourceName + " when deleting the revisions of the persistence store of SiddhiApp: " + siddhiAppName, (Throwable)e);
        }
        try {
            stmt = con.prepareStatement(this.executionInfo.getPreparedDeleteAllRevisionsStatement());
            stmt.setString(1, siddhiAppName);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error in deleting all revisions of siddhiApp: " + siddhiAppName + "from the database with datasource " + this.datasourceName), (Throwable)e);
            throw new CannotClearSiddhiAppStateException("Error in deleting all the revisions of the persistence store of SiddhiApp: " + siddhiAppName + " from the database with datasource " + this.datasourceName, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error((Object)("Unable to close statement." + e.getMessage()), (Throwable)e);
                }
            }
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListOfRevisionsFromDB(String siddhiAppName) {
        ArrayList<String> revisions = new ArrayList<String>();
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            con = this.datasource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " . Could not load the list of revisions for Siddhi app: " + siddhiAppName), (Throwable)e);
            List<String> list = null;
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
            return list;
        }
        try {
            con.setAutoCommit(false);
            stmt = con.prepareStatement(this.executionInfo.getPreparedSelectRevisionsStatement());
            stmt.setString(1, siddhiAppName);
            try (ResultSet resultSet = stmt.executeQuery();){
                con.commit();
                while (resultSet.next()) {
                    revisions.add(String.valueOf(resultSet.getString("revision")));
                }
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Could not load the list of revisions, for Siddhi app: " + siddhiAppName + ", from the database with datasource " + this.datasourceName), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                throw throwable;
            }
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        }
        DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        return revisions;
    }

    private void initializeDatabaseExecutionInfo() {
        this.executionInfo = new ExecutionInfo();
        RDBMSQueryConfigurationEntry databaseQueryEntries = RDBMSConfiguration.getInstance().getDatabaseQueryEntries(this.databaseType, this.databaseVersion, this.tableName);
        this.executionInfo.setPreparedInsertStatement(databaseQueryEntries.getInsertTableQuery());
        this.executionInfo.setPreparedCreateTableStatement(databaseQueryEntries.getCreateTableQuery());
        this.executionInfo.setPreparedTableExistenceCheckStatement(databaseQueryEntries.getIsTableExistQuery());
        this.executionInfo.setPreparedSelectStatement(databaseQueryEntries.getSelectTableQuery());
        this.executionInfo.setPreparedSelectLastStatement(databaseQueryEntries.getSelectLastQuery());
        this.executionInfo.setPreparedSelectRevisionsStatement(databaseQueryEntries.getSelectRevisionsQuery());
        this.executionInfo.setPreparedDeleteStatement(databaseQueryEntries.getDeleteQuery());
        this.executionInfo.setPreparedDeleteOldRevisionsStatement(databaseQueryEntries.getDeleteOldRevisionsQuery());
        this.executionInfo.setPreparedCountStatement(databaseQueryEntries.getCountQuery());
        this.executionInfo.setPreparedDeleteAllRevisionsStatement(databaseQueryEntries.getDeleteAllRevisionsQuery());
    }

    private void cleanOldRevisions(IncrementalSnapshotInfo incrementalSnapshotInfo) {
        String revisionsToClean;
        List<String> allRevisions;
        if (incrementalSnapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.INCREMENT && (allRevisions = this.getListOfRevisionsFromDB(incrementalSnapshotInfo.getSiddhiAppId())) != null && (revisionsToClean = this.getRevisionsToClean(incrementalSnapshotInfo, allRevisions)) != null) {
            this.cleanOldRevisionsFromDB(revisionsToClean, incrementalSnapshotInfo.getSiddhiAppId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldRevisionsFromDB(String revisionsToClean, String siddhiAppId) {
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            con = this.datasource.getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)("Cannot establish connection to data source " + this.datasourceName + " to clean old revisions"), (Throwable)e);
            return;
        }
        try {
            stmt = con.prepareStatement(this.executionInfo.getPreparedDeleteOldRevisionsStatement());
            stmt.setString(1, revisionsToClean);
            stmt.setString(2, siddhiAppId);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error in cleaning old revisions of siddhiApp: " + siddhiAppId + "from the database with datasource " + this.datasourceName), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error((Object)("Unable to close statement." + e.getMessage()), (Throwable)e);
                }
            }
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        }
    }

    private String getRevisionsToClean(IncrementalSnapshotInfo incrementalSnapshotInfo, List<String> allRevisions) {
        StringBuilder revisionsToClean = new StringBuilder();
        long baseTimeStamp = incrementalSnapshotInfo.getTime();
        for (String revision : allRevisions) {
            IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision((String)revision);
            if (snapshotInfo.getTime() >= baseTimeStamp || !incrementalSnapshotInfo.getSiddhiAppId().equals(snapshotInfo.getSiddhiAppId()) || !incrementalSnapshotInfo.getQueryName().equals(snapshotInfo.getQueryName()) || !incrementalSnapshotInfo.getElementId().equals(snapshotInfo.getElementId())) continue;
            if (incrementalSnapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE && snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC) {
                revisionsToClean.append(",").append(revision);
                continue;
            }
            if (incrementalSnapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC) continue;
            revisionsToClean.append(",").append(revision);
        }
        if (revisionsToClean.length() != 0) {
            return revisionsToClean.substring(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExist() {
        if (!this.executionInfo.isTableExist()) {
            Statement stmt = null;
            Connection con = null;
            try {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.createStatement();
                }
                catch (SQLException e) {
                    log.error((Object)("Cannot establish connection to datasource " + this.datasourceName + " when checking persistence table exists"), (Throwable)e);
                    DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                    return;
                }
            }
            catch (Throwable throwable) {
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                throw throwable;
            }
            try (ResultSet ignored = stmt.executeQuery(this.executionInfo.getPreparedTableExistenceCheckStatement());){
                this.executionInfo.setTableExist(true);
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table " + this.tableName + " does not Exist. Table Will be created. "));
                }
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                try {
                    con = this.datasource.getConnection();
                    stmt = con.createStatement();
                    con.setAutoCommit(false);
                    stmt.executeUpdate(this.executionInfo.getPreparedCreateTableStatement());
                    con.commit();
                    this.executionInfo.setTableExist(true);
                }
                catch (SQLException ex) {
                    log.error((Object)("Could not create table " + this.tableName + " using datasource " + this.datasourceName), (Throwable)ex);
                }
            }
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        }
    }
}

