/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence;

import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.util.snapshot.PersistenceReference;

public class PersistenceManager
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManager.class);

    @Override
    public void run() {
        this.persist();
    }

    private void persist() {
        ConcurrentMap siddhiAppRuntimeMap = StreamProcessorDataHolder.getSiddhiManager().getSiddhiAppRuntimeMap();
        for (SiddhiAppRuntime siddhiAppRuntime : siddhiAppRuntimeMap.values()) {
            PersistenceReference persistenceReference = siddhiAppRuntime.persist();
            if (!log.isDebugEnabled()) continue;
            log.debug("Revision " + persistenceReference.getRevision() + " of siddhi App " + siddhiAppRuntime.getName() + " persisted successfully");
        }
        if (StreamProcessorDataHolder.getNodeInfo() != null) {
            StreamProcessorDataHolder.getNodeInfo().setLastPersistedTimestamp(System.currentTimeMillis());
        }
    }
}

