/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence.query;

import io.siddhi.distribution.core.persistence.beans.PersistenceStoreConfigs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.database.query.manager.QueryProvider;
import org.wso2.carbon.database.query.manager.config.Queries;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class QueryManager {
    private Map<String, String> queries;
    private ConfigProvider deploymentConfigProvider;

    public QueryManager(String databaseType, String databaseVersion, ConfigProvider configProvider) throws QueryMappingNotAvailableException, ConfigurationException, IOException {
        this.deploymentConfigProvider = configProvider;
        this.queries = this.readConfigs(databaseType, databaseVersion);
    }

    private Map<String, String> readConfigs(String databaseType, String databaseVersion) throws ConfigurationException, QueryMappingNotAvailableException, IOException {
        try {
            PersistenceStoreConfigs deploymentConfigurations = (PersistenceStoreConfigs)this.deploymentConfigProvider.getConfigurationObject(PersistenceStoreConfigs.class);
            List<Queries> deploymentQueries = deploymentConfigurations.getQueries();
            URL url = this.getClass().getClassLoader().getResource("queries.yaml");
            if (url == null) {
                throw new ConfigurationException("Unable to load queries.yaml file.");
            }
            PersistenceStoreConfigs componentConfigurations = this.readYamlContent(url.openStream());
            List<Queries> componentQueries = componentConfigurations.getQueries();
            this.queries = QueryProvider.mergeMapping((String)databaseType, (String)databaseVersion, (List)((ArrayList)componentQueries), (List)((ArrayList)deploymentQueries));
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Unable to read queries.yaml configurations: " + e.getMessage(), (Throwable)e);
        }
        catch (QueryMappingNotAvailableException e) {
            throw new QueryMappingNotAvailableException("Unable to load queries.", (Throwable)e);
        }
        catch (IOException e) {
            throw new IOException("Unable to load content from queries.yaml file.", e);
        }
        return this.queries;
    }

    public String getQuery(String key) throws ConfigurationException {
        if (!this.queries.containsKey(key)) {
            throw new ConfigurationException("Unable to find the configuration entry for the key: " + key);
        }
        return this.queries.get(key);
    }

    private PersistenceStoreConfigs readYamlContent(InputStream yamlContent) {
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(PersistenceStoreConfigs.class, PersistenceStoreConfigs.class.getClassLoader()));
        yaml.setBeanAccess(BeanAccess.FIELD);
        return (PersistenceStoreConfigs)yaml.loadAs(yamlContent, PersistenceStoreConfigs.class);
    }
}

