/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence.util;

import io.siddhi.distribution.core.persistence.util.ExecutionInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DBPersistenceStoreUtils {
    private static final Logger log = Logger.getLogger(DBPersistenceStoreUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableIfNotExist(ExecutionInfo executionInfo, DataSource dataSource, String dataSourceName, String tableName) {
        if (!executionInfo.isTableExist()) {
            Statement stmt = null;
            Connection con = null;
            try {
                try {
                    con = dataSource.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.createStatement();
                }
                catch (SQLException e) {
                    log.error((Object)("Cannot establish connection to datasource " + dataSourceName + " when checking persistence table exists"), (Throwable)e);
                    DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                    return;
                }
            }
            catch (Throwable throwable) {
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                throw throwable;
            }
            try (ResultSet ignored = stmt.executeQuery(executionInfo.getPreparedTableExistenceCheckStatement());){
                executionInfo.setTableExist(true);
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table " + tableName + " does not Exist. Table Will be created. "));
                }
                DBPersistenceStoreUtils.cleanupConnections(stmt, con);
                try {
                    con = dataSource.getConnection();
                    stmt = con.createStatement();
                    con.setAutoCommit(false);
                    stmt.executeUpdate(executionInfo.getPreparedCreateTableStatement());
                    con.commit();
                    executionInfo.setTableExist(true);
                }
                catch (SQLException ex) {
                    log.error((Object)("Could not create table " + tableName + " using datasource " + dataSourceName), (Throwable)ex);
                }
            }
            DBPersistenceStoreUtils.cleanupConnections(stmt, con);
        }
    }

    public static void cleanupConnections(Statement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)("Unable to close statement." + e.getMessage()), (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Unable to close connection." + e.getMessage()), (Throwable)e);
            }
        }
    }
}

