/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.persistence.util;

import io.siddhi.distribution.core.internal.StreamProcessorDataHolder;
import io.siddhi.distribution.core.persistence.dto.RDBMSQueryConfigurationEntry;
import io.siddhi.distribution.core.persistence.exception.DatasourceConfigurationException;
import io.siddhi.distribution.core.persistence.query.QueryManager;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;

public class RDBMSConfiguration {
    private static final Logger log = Logger.getLogger(RDBMSConfiguration.class);
    private static RDBMSConfiguration config = new RDBMSConfiguration();

    private RDBMSConfiguration() {
    }

    public static RDBMSConfiguration getInstance() {
        return config;
    }

    public RDBMSQueryConfigurationEntry getDatabaseQueryEntries(String databaseType, String databaseVersion, String tableName) {
        RDBMSQueryConfigurationEntry databaseQueryEntries = new RDBMSQueryConfigurationEntry();
        try {
            QueryManager queryManager = new QueryManager(databaseType, databaseVersion, StreamProcessorDataHolder.getInstance().getConfigProvider());
            databaseQueryEntries.setCreateTableQuery(queryManager.getQuery("CREATE_TABLE").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setInsertTableQuery(queryManager.getQuery("INSERT_INTO_TABLE").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setIsTableExistQuery(queryManager.getQuery("IS_TABLE_EXISTS").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setSelectTableQuery(queryManager.getQuery("SELECT_SNAPSHOT").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setSelectLastQuery(queryManager.getQuery("SELECT_LAST_REVISION").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setSelectRevisionsQuery(queryManager.getQuery("SELECT_REVISIONS").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setDeleteQuery(queryManager.getQuery("DELETE_ROW_FROM_TABLE").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setDeleteOldRevisionsQuery(queryManager.getQuery("DELETE_OLD_REVISIONS").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setCountQuery(queryManager.getQuery("COUNT_NUMBER_REVISIONS").replace("{{TABLE_NAME}}", tableName));
            databaseQueryEntries.setDeleteAllRevisionsQuery(queryManager.getQuery("DELETE_ALL_REVISIONS").replace("{{TABLE_NAME}}", tableName));
        }
        catch (IOException | ConfigurationException | QueryMappingNotAvailableException e) {
            throw new DatasourceConfigurationException("Error reading queries for database: " + databaseType + " " + databaseVersion, e);
        }
        return databaseQueryEntries;
    }
}

