/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.util;

import io.siddhi.distribution.core.event.queue.EventDataMetaInfo;
import io.siddhi.distribution.core.event.queue.EventMetaInfo;
import io.siddhi.distribution.core.event.queue.QueuedEvent;
import io.siddhi.distribution.core.util.BinaryMessageConverterUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.query.api.definition.Attribute;

public class BinaryEventConverter {
    public static ByteBuffer convertToBinaryMessage(QueuedEvent[] queuedEvents) throws IOException {
        ByteBuffer messageBuffer = null;
        for (QueuedEvent queuedEvent : queuedEvents) {
            Event event = queuedEvent.getEvent();
            int allTrpSyncPropertiesByteLength = 0;
            int messageSize = 4 + BinaryMessageConverterUtil.getSize(queuedEvent.getSourceHandlerElementId());
            EventMetaInfo eventMetaInfo = BinaryEventConverter.getEventMetaInfo(event);
            String attributes = Arrays.toString(eventMetaInfo.getAttributeTypeOrder());
            messageSize += BinaryMessageConverterUtil.getSize(attributes) + BinaryMessageConverterUtil.getSize(queuedEvent.getSequenceID()) + BinaryMessageConverterUtil.getSize(queuedEvent.getSiddhiAppName()) + BinaryMessageConverterUtil.getSize(queuedEvent.getEvent().getTimestamp()) + BinaryEventConverter.getEventSize(event) + 4;
            String[] trpSyncProperties = queuedEvent.getTransportSyncProperties();
            if (trpSyncProperties != null) {
                for (String property : trpSyncProperties) {
                    allTrpSyncPropertiesByteLength += property.length();
                    messageSize += 4;
                }
                if (trpSyncProperties.length != 0) {
                    messageSize += 4 + allTrpSyncPropertiesByteLength;
                }
            }
            messageBuffer = ByteBuffer.wrap(new byte[messageSize]);
            messageBuffer.putInt(queuedEvents.length);
            messageBuffer.putLong(queuedEvent.getSequenceID());
            messageBuffer.putInt(queuedEvent.getSourceHandlerElementId().length());
            messageBuffer.put(queuedEvent.getSourceHandlerElementId().getBytes(Charset.defaultCharset()));
            messageBuffer.putInt(queuedEvent.getSiddhiAppName().length());
            messageBuffer.put(queuedEvent.getSiddhiAppName().getBytes(Charset.defaultCharset()));
            messageBuffer.putInt(allTrpSyncPropertiesByteLength);
            if (trpSyncProperties != null) {
                messageBuffer.putInt(trpSyncProperties.length);
                if (trpSyncProperties.length != 0) {
                    for (String property : trpSyncProperties) {
                        messageBuffer.putInt(property.length());
                        messageBuffer.put(property.getBytes(Charset.defaultCharset()));
                    }
                }
            }
            messageBuffer.putInt(attributes.length());
            messageBuffer.put(attributes.getBytes(Charset.defaultCharset()));
            messageBuffer.putLong(event.getTimestamp());
            if (event.getData() == null || event.getData().length == 0) continue;
            Object[] data = event.getData();
            for (int i = 0; i < data.length; ++i) {
                Object aData = data[i];
                BinaryMessageConverterUtil.assignData(aData, messageBuffer);
            }
        }
        return messageBuffer;
    }

    private static int getEventSize(Event event) {
        int eventSize = 8;
        Object[] data = event.getData();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                Object aData = data[i];
                eventSize += BinaryMessageConverterUtil.getSize(aData);
            }
        }
        return eventSize;
    }

    private static EventMetaInfo getEventMetaInfo(Event event) {
        int eventSize = 8;
        Object[] data = event.getData();
        Attribute.Type[] attributeTypeOrder = new Attribute.Type[data.length];
        for (int i = 0; i < data.length; ++i) {
            Object aData = data[i];
            EventDataMetaInfo eventDataMetaInfo = BinaryMessageConverterUtil.getEventMetaInfo(aData);
            eventSize += eventDataMetaInfo.getEventSize();
            attributeTypeOrder[i] = eventDataMetaInfo.getAttributeType();
        }
        return new EventMetaInfo(eventSize, attributeTypeOrder);
    }
}

