/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.core.util;

import io.netty.buffer.ByteBuf;
import io.siddhi.distribution.core.event.queue.EventDataMetaInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.wso2.siddhi.query.api.definition.Attribute;

public final class BinaryMessageConverterUtil {
    public static int getSize(Object data) {
        if (data instanceof String) {
            return 4 + ((String)data).length();
        }
        if (data instanceof Integer) {
            return 4;
        }
        if (data instanceof Long) {
            return 8;
        }
        if (data instanceof Float) {
            return 4;
        }
        if (data instanceof Double) {
            return 8;
        }
        if (data instanceof Boolean) {
            return 1;
        }
        return 4;
    }

    public static EventDataMetaInfo getEventMetaInfo(Object data) {
        int eventSize;
        Attribute.Type attributeType;
        if (data instanceof String) {
            attributeType = Attribute.Type.STRING;
            eventSize = 4 + ((String)data).length();
        } else if (data instanceof Integer) {
            attributeType = Attribute.Type.INT;
            eventSize = 4;
        } else if (data instanceof Long) {
            attributeType = Attribute.Type.LONG;
            eventSize = 8;
        } else if (data instanceof Float) {
            attributeType = Attribute.Type.FLOAT;
            eventSize = 4;
        } else if (data instanceof Double) {
            attributeType = Attribute.Type.DOUBLE;
            eventSize = 8;
        } else if (data instanceof Boolean) {
            attributeType = Attribute.Type.BOOL;
            eventSize = 1;
        } else {
            attributeType = Attribute.Type.OBJECT;
            eventSize = 1;
        }
        return new EventDataMetaInfo(eventSize, attributeType);
    }

    public static void assignData(Object data, ByteBuffer eventDataBuffer) throws IOException {
        if (data instanceof String) {
            eventDataBuffer.putInt(((String)data).length());
            eventDataBuffer.put(((String)data).getBytes(Charset.defaultCharset()));
        } else if (data instanceof Integer) {
            eventDataBuffer.putInt((Integer)data);
        } else if (data instanceof Long) {
            eventDataBuffer.putLong((Long)data);
        } else if (data instanceof Float) {
            eventDataBuffer.putFloat(((Float)data).floatValue());
        } else if (data instanceof Double) {
            eventDataBuffer.putDouble((Double)data);
        } else if (data instanceof Boolean) {
            eventDataBuffer.put((byte)((Boolean)data != false ? 1 : 0));
        } else {
            eventDataBuffer.putInt(0);
        }
    }

    public static String getString(ByteBuf byteBuf, int size) throws UnsupportedEncodingException {
        byte[] bytes = new byte[size];
        byteBuf.readBytes(bytes);
        return new String(bytes, Charset.defaultCharset());
    }

    public static String getString(ByteBuffer byteBuf, int size) throws UnsupportedEncodingException {
        byte[] bytes = new byte[size];
        byteBuf.get(bytes);
        return new String(bytes, Charset.defaultCharset());
    }
}

