/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.distribution.editor.core.exception.InvalidExecutionStateException;
import io.siddhi.distribution.editor.core.exception.NoSuchStreamException;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import io.siddhi.distribution.editor.core.util.DebugCallbackEvent;
import io.siddhi.distribution.editor.core.util.SourceEditorUtils;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugRuntime {
    private String siddhiAppName;
    private Mode mode = Mode.STOP;
    private transient String siddhiApp;
    private transient SiddhiAppRuntime siddhiAppRuntime;
    private transient SiddhiDebugger debugger;
    private transient LinkedBlockingQueue<DebugCallbackEvent> callbackEventsQueue;
    private Throwable caughtException;
    private static final Logger log = LoggerFactory.getLogger(DebugRuntime.class);

    public DebugRuntime(String siddhiAppName, String siddhiApp) {
        this.siddhiAppName = siddhiAppName;
        this.siddhiApp = siddhiApp;
        this.callbackEventsQueue = new LinkedBlockingQueue(10);
        this.createRuntime(siddhiApp);
    }

    public DebugRuntime(String siddhiAppName, String siddhiApp, Map<String, String> variableMap) {
        this.siddhiAppName = siddhiAppName;
        this.siddhiApp = siddhiApp;
        this.callbackEventsQueue = new LinkedBlockingQueue(10);
        this.createRuntime(SourceEditorUtils.populateSiddhiAppWithVars(variableMap, siddhiApp));
    }

    public String getSiddhiAppName() {
        return this.siddhiAppName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public SiddhiDebugger getDebugger() {
        return this.debugger;
    }

    public String getSiddhiApp() {
        return this.siddhiApp;
    }

    public void start() {
        if (Mode.STOP.equals((Object)this.mode)) {
            try {
                this.siddhiAppRuntime.start();
                this.mode = Mode.RUN;
            }
            catch (Throwable e) {
                this.mode = Mode.FAULTY;
                String errorMessage = "Siddhi App '" + this.siddhiAppName + "' is in faulty state.";
                log.error(errorMessage, e);
                throw new InvalidExecutionStateException(errorMessage, e);
            }
        } else {
            String errorMessage = "Siddhi App '" + this.siddhiAppName + "' is in faulty state.";
            log.error(errorMessage, this.caughtException);
            throw new InvalidExecutionStateException(errorMessage);
        }
    }

    public void debug() {
        if (Mode.STOP.equals((Object)this.mode)) {
            try {
                this.debugger = this.siddhiAppRuntime.debug();
                this.debugger.setDebuggerCallback((event, queryName, queryTerminal, debugger) -> {
                    String[] queries = this.getQueries().toArray(new String[this.getQueries().size()]);
                    int queryIndex = Arrays.asList(queries).indexOf(queryName);
                    this.callbackEventsQueue.add(new DebugCallbackEvent(queryName, queryIndex, queryTerminal, event));
                });
                this.mode = Mode.DEBUG;
            }
            catch (Throwable e) {
                String errorMessage = "Siddhi App '" + this.siddhiAppName + "' is in faulty state.";
                log.error(errorMessage, e);
                this.mode = Mode.FAULTY;
                throw new InvalidExecutionStateException(errorMessage, e);
            }
        } else {
            String errorMessage = "Siddhi App '" + this.siddhiAppName + "' is in faulty state.";
            log.error(errorMessage, this.caughtException);
            throw new InvalidExecutionStateException(errorMessage);
        }
    }

    public void stop() {
        if (this.debugger != null) {
            this.debugger.releaseAllBreakPoints();
            this.debugger.play();
            this.debugger = null;
        }
        if (this.siddhiAppRuntime != null) {
            this.siddhiAppRuntime.shutdown();
            this.siddhiAppRuntime = null;
        }
        this.callbackEventsQueue.clear();
        this.createRuntime(this.siddhiApp);
    }

    public void reload(String siddhiApp) {
        this.siddhiApp = siddhiApp;
        this.stop();
    }

    public List<String> getStreams() {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return new ArrayList<String>(this.siddhiAppRuntime.getStreamDefinitionMap().keySet());
        }
        throw new InvalidExecutionStateException("Siddhi App '" + this.siddhiAppName + "' is in faulty state.");
    }

    public List<String> getQueries() {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return new ArrayList<String>(this.siddhiAppRuntime.getQueryNames());
        }
        throw new InvalidExecutionStateException("Siddhi App '" + this.siddhiAppName + "' is in faulty state.");
    }

    public InputHandler getInputHandler(String streamName) {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return this.siddhiAppRuntime.getInputHandler(streamName);
        }
        throw new InvalidExecutionStateException("Siddhi App '" + this.siddhiAppName + "' is in faulty state.");
    }

    public List<Attribute> getStreamAttributes(String streamName) {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            if (this.siddhiAppRuntime.getStreamDefinitionMap().containsKey(streamName)) {
                return ((StreamDefinition)this.siddhiAppRuntime.getStreamDefinitionMap().get(streamName)).getAttributeList();
            }
            throw new NoSuchStreamException(String.format("Stream definition %s does not exists in Siddhi app %s", streamName, this.siddhiAppName));
        }
        throw new InvalidExecutionStateException("Siddhi App '" + this.siddhiAppName + "' is in faulty state.");
    }

    public LinkedBlockingQueue<DebugCallbackEvent> getCallbackEventsQueue() {
        return this.callbackEventsQueue;
    }

    private void createRuntime(String siddhiApp) {
        try {
            if (siddhiApp != null && !siddhiApp.isEmpty()) {
                this.siddhiAppRuntime = EditorDataHolder.getSiddhiManager().createSiddhiAppRuntime(siddhiApp);
                this.mode = Mode.STOP;
            } else {
                this.mode = Mode.FAULTY;
            }
        }
        catch (Exception e) {
            this.caughtException = e;
            this.mode = Mode.FAULTY;
        }
    }

    public void setSiddhiAppRuntime(SiddhiAppRuntime siddhiAppRuntime) {
        this.siddhiAppRuntime = siddhiAppRuntime;
    }

    public SiddhiAppRuntime getSiddhiAppRuntime() {
        return this.siddhiAppRuntime;
    }

    public static enum Mode {
        RUN,
        DEBUG,
        STOP,
        FAULTY;

    }
}

