/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.core.event.Event;
import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.common.common.exception.ResourceNotFoundException;
import io.siddhi.distribution.editor.core.exception.NoSuchStreamException;
import io.siddhi.distribution.editor.core.internal.DebugRuntime;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import io.siddhi.query.api.definition.Attribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerEventStreamService
implements EventStreamService {
    private static Logger log = LoggerFactory.getLogger(DebuggerEventStreamService.class);

    public List<String> getStreamNames(String siddhiAppName) {
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        if (runtimeHolder != null) {
            return runtimeHolder.getStreams();
        }
        log.error("Siddhi App with name : " + siddhiAppName + " is not available");
        return null;
    }

    public List<Attribute> getStreamAttributes(String siddhiAppName, String streamName) throws ResourceNotFoundException {
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        if (runtimeHolder != null) {
            try {
                return runtimeHolder.getStreamAttributes(streamName);
            }
            catch (NoSuchStreamException e) {
                throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not contain stream '" + streamName + "'.", ResourceNotFoundException.ResourceType.STREAM_NAME, streamName);
            }
        }
        throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not exist.", ResourceNotFoundException.ResourceType.SIDDHI_APP_NAME, siddhiAppName);
    }

    public void pushEvent(String siddhiAppName, String streamName, Event event) {
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        if (runtimeHolder != null) {
            try {
                runtimeHolder.getInputHandler(streamName).send(event);
            }
            catch (Exception e) {
                log.error("Error when pushing events to Siddhi debugger engine ", (Throwable)e);
            }
        }
    }
}

