/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import io.siddhi.distribution.editor.core.exception.DockerGenerationException;
import io.siddhi.distribution.editor.core.internal.DockerBuilderStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilder
extends Thread {
    private Thread t;
    private static final Logger log = LoggerFactory.getLogger(DockerBuilder.class);
    private static final String UNIX_DEFAULT_DOCKER_HOST = "unix:///var/run/docker.sock";
    private static final String WINDOWS_DEFAULT_DOCKER_HOST = "http://localhost:2375";
    private static final String STEP_BUILDING = "Building";
    private static final String STEP_PUSHING = "Pushing";
    private static final String STEP_COMPLETED = "Completed";
    private static final String STEP_ERROR = "Error";
    private DockerClient dockerClient;
    private DockerBuilderStatus dockerBuilderStatus;
    private String imageId;
    private String dockerImageName;
    private String dockerUserName;
    private String dockerEmail;
    private String dockerPassword;
    private Path dockerFilePath;

    public DockerBuilder(String dockerImageName, String dockerUserName, String dockerEmail, String dockerPassword, Path dockerFilePath, DockerBuilderStatus dockerBuilderStatus) {
        this.dockerImageName = dockerImageName;
        this.dockerUserName = dockerUserName;
        this.dockerEmail = dockerEmail;
        this.dockerPassword = dockerPassword;
        this.dockerFilePath = dockerFilePath;
        this.dockerBuilderStatus = dockerBuilderStatus;
    }

    @Override
    public void run() {
        try {
            boolean isDockerBuilt = this.buildDockerImage();
            if (isDockerBuilt) {
                boolean isDockerPushed = this.pushDockerImage();
                if (isDockerPushed) {
                    this.dockerBuilderStatus.setStep(STEP_COMPLETED);
                } else {
                    this.dockerBuilderStatus.setStep(STEP_ERROR);
                }
            }
            this.removeDockerBuildTempDir();
        }
        catch (DockerGenerationException e) {
            log.error("Failed to build and push Docker artifacts automatically.\n", (Throwable)e);
        }
    }

    @Override
    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    private void createDockerClient() throws DockerGenerationException {
        String dockerHost = SystemUtils.IS_OS_WINDOWS ? WINDOWS_DEFAULT_DOCKER_HOST : UNIX_DEFAULT_DOCKER_HOST;
        this.dockerClient = DefaultDockerClient.builder().uri(dockerHost).build();
        try {
            this.dockerClient.ping();
        }
        catch (DockerException | InterruptedException e) {
            this.dockerBuilderStatus.setStatus(e.getMessage());
            throw new DockerGenerationException("Failed to connect to the Docker host using provided host URI " + dockerHost, e);
        }
    }

    private boolean buildDockerImage() throws DockerGenerationException {
        boolean isDockerBuilt = false;
        this.dockerBuilderStatus.setStep(STEP_BUILDING);
        if (this.dockerClient == null) {
            this.createDockerClient();
        }
        AtomicReference imageIdFromMessage = new AtomicReference();
        try {
            this.imageId = this.dockerClient.build(this.dockerFilePath, this.dockerImageName, message -> {
                String imageId = message.buildImageId();
                if (message.stream() != null && !message.stream().equals("\n") && !message.stream().equals("")) {
                    this.dockerBuilderStatus.setStatus(message.stream().replace("\n", ""));
                    log.info(message.stream().replace("\n", ""));
                }
                if (imageId != null) {
                    imageIdFromMessage.set(imageId);
                }
            }, DockerClient.BuildParam.noCache(), DockerClient.BuildParam.forceRm());
            if (imageIdFromMessage.get() != null) {
                isDockerBuilt = true;
            }
        }
        catch (DockerException | IOException | InterruptedException e) {
            this.dockerBuilderStatus.setStatus(e.getMessage());
            throw new DockerGenerationException("Failed to build Docker image '" + this.dockerImageName, e);
        }
        finally {
            this.removeDockerBuildTempDir();
        }
        return isDockerBuilt;
    }

    private boolean pushDockerImage() throws DockerGenerationException {
        boolean isPushed = false;
        this.dockerBuilderStatus.setStep(STEP_PUSHING);
        if (this.dockerClient == null) {
            this.createDockerClient();
        }
        RegistryAuth registryAuth = RegistryAuth.builder().email(this.dockerEmail).username(this.dockerUserName).password(this.dockerPassword).build();
        try {
            int statusCode = this.dockerClient.auth(registryAuth);
            if (statusCode != 200) {
                String errorMessage = "Authentication failed to connect to the Docker registry using UserName: " + this.dockerUserName + " and Email: " + this.dockerEmail;
                log.error(errorMessage);
                this.dockerBuilderStatus.setStatus(errorMessage);
                throw new DockerGenerationException("Authentication failed to connect to the Docker registry using UserName: " + this.dockerUserName + " and Email: " + this.dockerEmail);
            }
            log.info("Pushing Docker image '" + this.dockerImageName + "' started.");
            this.dockerClient.push(this.dockerImageName, message -> {
                if (message != null && message.status() != null && message.id() != null) {
                    this.dockerBuilderStatus.setStatus(message.status());
                    log.info(message.id() + ": " + message.status());
                }
            }, registryAuth);
            log.info("Docker image '" + this.dockerImageName + "' pushed successfully.");
            isPushed = true;
        }
        catch (DockerException | InterruptedException e) {
            String errorMessage = "Failed to push the Docker image '" + this.dockerImageName + "' with UserName: " + this.dockerUserName + " and Email: " + this.dockerEmail;
            this.dockerBuilderStatus.setStatus(e.getMessage());
            throw new DockerGenerationException(errorMessage, e);
        }
        return isPushed;
    }

    private void removeDockerBuildTempDir() {
        if (this.dockerFilePath != null && Files.exists(this.dockerFilePath, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory(new File(this.dockerFilePath.toString()));
            }
            catch (IOException e) {
                log.error("Failed automatic deletion of the temporary Docker directory " + this.dockerFilePath.toString(), (Throwable)e);
            }
        }
    }
}

